/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.db;

import jakarta.persistence.JoinTable;
import java.lang.annotation.Annotation;
import java.util.List;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinTableImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableMemberDetails;

public class TableProcessing {
    public static MutableAnnotationUsage<JoinTable> transformJoinTable(JaxbJoinTableImpl jaxbJoinTable, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        List<JaxbJoinColumnImpl> inverseJoinColumns;
        if (jaxbJoinTable == null) {
            return null;
        }
        MutableAnnotationUsage joinTableUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.JOIN_TABLE, xmlDocumentContext.getModelBuildingContext());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)joinTableUsage, "name", jaxbJoinTable.getName());
        XmlAnnotationHelper.applyTableAttributes(jaxbJoinTable, (MutableAnnotationTarget)memberDetails, joinTableUsage, JpaAnnotations.JOIN_TABLE, xmlDocumentContext);
        List<JaxbJoinColumnImpl> joinColumns = jaxbJoinTable.getJoinColumn();
        if (CollectionHelper.isNotEmpty(joinColumns)) {
            joinTableUsage.setAttributeValue("joinColumns", JoinColumnProcessing.transformJoinColumnList(joinColumns, memberDetails, xmlDocumentContext));
        }
        if (CollectionHelper.isNotEmpty(inverseJoinColumns = jaxbJoinTable.getInverseJoinColumn())) {
            joinTableUsage.setAttributeValue("inverseJoinColumns", JoinColumnProcessing.transformJoinColumnList(inverseJoinColumns, memberDetails, xmlDocumentContext));
        }
        if (jaxbJoinTable.getForeignKey() != null) {
            joinTableUsage.setAttributeValue("foreignKey", ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbJoinTable.getForeignKey(), (MemberDetails)memberDetails, xmlDocumentContext));
        }
        if (jaxbJoinTable.getInverseForeignKey() != null) {
            joinTableUsage.setAttributeValue("inverseForeignKey", ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbJoinTable.getInverseForeignKey(), (MemberDetails)memberDetails, xmlDocumentContext));
        }
        return joinTableUsage;
    }
}

