/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.InstantiationException;
import org.hibernate.Internal;
import org.hibernate.StaleStateException;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.BatchFailedException;
import org.hibernate.jdbc.BatchedTooManyRowsAffectedException;
import org.hibernate.jdbc.Expectation;
import org.hibernate.jdbc.TooManyRowsAffectedException;

public class Expectations {
    private static final @UnknownKeyFor @NonNull @Initialized CoreMessageLogger LOG = CoreLogging.messageLogger(Expectations.class);
    static final @UnknownKeyFor @NonNull @Initialized SqlExceptionHelper sqlExceptionHelper = new SqlExceptionHelper(false);
    @Deprecated(since="6.5")
    public static final @UnknownKeyFor @NonNull @Initialized Expectation NONE = new Expectation.None();
    @Deprecated(since="6.5")
    public static final @UnknownKeyFor @NonNull @Initialized Expectation BASIC = new Expectation.RowCount();
    @Deprecated(since="6.5")
    public static final @UnknownKeyFor @NonNull @Initialized Expectation PARAM = new Expectation.OutParameter();
    @Deprecated(since="6.5", forRemoval=true)
    public static final @UnknownKeyFor @NonNull @Initialized int USUAL_EXPECTED_COUNT = 1;
    @Deprecated(since="6.5", forRemoval=true)
    public static final @UnknownKeyFor @NonNull @Initialized int USUAL_PARAM_POSITION = 1;

    @Internal
    public static @UnknownKeyFor @NonNull @Initialized Expectation createExpectation(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Expectation> expectation, @UnknownKeyFor @NonNull @Initialized boolean callable) {
        Expectation instance;
        if (expectation == null) {
            expectation = callable ? Expectation.OutParameter.class : Expectation.RowCount.class;
        }
        try {
            instance = expectation.newInstance();
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate Expectation", expectation, e);
        }
        instance.validate(callable);
        return instance;
    }

    static @UnknownKeyFor @NonNull @Initialized CallableStatement toCallableStatement(@UnknownKeyFor @NonNull @Initialized PreparedStatement statement) {
        if (statement instanceof CallableStatement) {
            return (CallableStatement)statement;
        }
        throw new HibernateException("Expectation.OutParameter operates exclusively on CallableStatements: " + statement.getClass());
    }

    static void checkBatched(@UnknownKeyFor @NonNull @Initialized int expectedRowCount, @UnknownKeyFor @NonNull @Initialized int rowCount, @UnknownKeyFor @NonNull @Initialized int batchPosition, @UnknownKeyFor @NonNull @Initialized String sql) {
        switch (rowCount) {
            case -3: {
                throw new BatchFailedException("Batch update failed: " + batchPosition);
            }
            case -2: {
                LOG.debugf("Success of batch update unknown: %s", batchPosition);
                break;
            }
            default: {
                if (expectedRowCount > rowCount) {
                    throw new StaleStateException("Batch update returned unexpected row count from update [" + batchPosition + "]; actual row count: " + rowCount + "; expected: " + expectedRowCount + "; statement executed: " + sql);
                }
                if (expectedRowCount >= rowCount) break;
                throw new BatchedTooManyRowsAffectedException("Batch update returned unexpected row count from update [" + batchPosition + "]; actual row count: " + rowCount + "; expected: " + expectedRowCount, expectedRowCount, rowCount, batchPosition);
            }
        }
    }

    static void checkNonBatched(@UnknownKeyFor @NonNull @Initialized int expectedRowCount, @UnknownKeyFor @NonNull @Initialized int rowCount, @UnknownKeyFor @NonNull @Initialized String sql) {
        if (expectedRowCount > rowCount) {
            throw new StaleStateException("Unexpected row count: " + rowCount + "; expected: " + expectedRowCount + "; statement executed: " + sql);
        }
        if (expectedRowCount < rowCount) {
            throw new TooManyRowsAffectedException("Unexpected row count: " + rowCount + "; expected: " + expectedRowCount, 1, rowCount);
        }
    }

    @Deprecated(since="6.5", forRemoval=true)
    public static @UnknownKeyFor @NonNull @Initialized Expectation appropriateExpectation(@UnknownKeyFor @NonNull @Initialized ExecuteUpdateResultCheckStyle style) {
        switch (style) {
            case NONE: {
                return NONE;
            }
            case COUNT: {
                return BASIC;
            }
            case PARAM: {
                return PARAM;
            }
        }
        throw new AssertionFailure("unknown result check style: " + style);
    }

    private Expectations() {
    }

    @Deprecated(since="6.5")
    public static class BasicParamExpectation
    extends Expectation.OutParameter {
        private final @UnknownKeyFor @NonNull @Initialized int parameterPosition;
        private final @UnknownKeyFor @NonNull @Initialized int expectedRowCount;

        protected BasicParamExpectation(@UnknownKeyFor @NonNull @Initialized int expectedRowCount, @UnknownKeyFor @NonNull @Initialized int parameterPosition) {
            this.expectedRowCount = expectedRowCount;
            this.parameterPosition = parameterPosition;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized int expectedRowCount() {
            return this.expectedRowCount;
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized int parameterIndex() {
            return this.parameterPosition;
        }
    }

    @Deprecated(since="6.5")
    public static class BasicExpectation
    extends Expectation.RowCount {
        private final @UnknownKeyFor @NonNull @Initialized int expectedRowCount;

        protected BasicExpectation(@UnknownKeyFor @NonNull @Initialized int expectedRowCount) {
            this.expectedRowCount = expectedRowCount;
            if (expectedRowCount < 0) {
                throw new IllegalArgumentException("Expected row count must be greater than zero");
            }
        }

        @Override
        protected @UnknownKeyFor @NonNull @Initialized int expectedRowCount() {
            return this.expectedRowCount;
        }
    }
}

