/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.ordering.ast;

import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.mapping.ordering.ast.OrderingExpression;
import org.hibernate.metamodel.mapping.ordering.ast.SequencePart;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.query.NullPrecedence;
import org.hibernate.query.SortDirection;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.type.NullType;

public class ColumnReference
implements OrderingExpression,
SequencePart {
    private final String columnExpression;
    private final boolean isColumnExpressionFormula;

    public ColumnReference(String columnExpression, boolean isColumnExpressionFormula) {
        this.columnExpression = columnExpression;
        this.isColumnExpressionFormula = isColumnExpressionFormula;
    }

    public String getColumnExpression() {
        return this.columnExpression;
    }

    public boolean isColumnExpressionFormula() {
        return this.isColumnExpressionFormula;
    }

    @Override
    public Expression resolve(QuerySpec ast, TableGroup tableGroup, String modelPartName, SqlAstCreationState creationState) {
        TableReference tableReference = this.getTableReference(tableGroup);
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlExpressionResolver();
        return sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, this.columnExpression, (JdbcMapping)NullType.INSTANCE), sqlAstProcessingState -> new org.hibernate.sql.ast.tree.expression.ColumnReference(tableReference, this.columnExpression, this.isColumnExpressionFormula, null, null));
    }

    @Override
    public SequencePart resolvePathPart(String name, String identifier, boolean isTerminal, TranslationContext translationContext) {
        throw new UnsupportedMappingException("ColumnReference cannot be de-referenced");
    }

    @Override
    public void apply(QuerySpec ast, TableGroup tableGroup, String collation, String modelPartName, SortDirection sortOrder, NullPrecedence nullPrecedence, SqlAstCreationState creationState) {
        Expression expression = this.resolve(ast, tableGroup, modelPartName, creationState);
        if (ast.hasSortSpecifications()) {
            for (SortSpecification sortSpecification : ast.getSortSpecifications()) {
                if (sortSpecification.getSortExpression() != expression) continue;
                return;
            }
        }
        Expression sortExpression = OrderingExpression.applyCollation(expression, collation, creationState);
        ast.addSortSpecification(new SortSpecification(sortExpression, sortOrder, nullPrecedence.getJpaValue()));
    }

    TableReference getTableReference(TableGroup tableGroup) {
        ModelPartContainer modelPart = tableGroup.getModelPart();
        if (modelPart instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttribute = (PluralAttributeMapping)modelPart;
            if (!pluralAttribute.getCollectionDescriptor().hasManyToManyOrdering()) {
                return tableGroup.getPrimaryTableReference();
            }
            MappingType elementMappingType = pluralAttribute.getElementDescriptor().getPartMappingType();
            if (elementMappingType instanceof AbstractEntityPersister) {
                AbstractEntityPersister abstractEntityPersister = (AbstractEntityPersister)elementMappingType;
                int tableNumber = abstractEntityPersister.determineTableNumberForColumn(this.columnExpression);
                String tableName = abstractEntityPersister.getTableName(tableNumber);
                return tableGroup.getTableReference(tableGroup.getNavigablePath(), tableName);
            }
            return tableGroup.getPrimaryTableReference();
        }
        return null;
    }

    @Override
    public String toDescriptiveText() {
        return "column reference (" + this.columnExpression + ")";
    }
}

