/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import jakarta.persistence.metamodel.EntityType;
import java.lang.reflect.Field;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.internal.DomainPathPart;
import org.hibernate.query.hql.spi.DotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmEnumLiteral;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;

public class BasicDotIdentifierConsumer
implements DotIdentifierConsumer {
    private final SqmCreationState creationState;
    private StringBuilder pathSoFar = new StringBuilder();
    private SemanticPathPart currentPart;

    public BasicDotIdentifierConsumer(SqmCreationState creationState) {
        this.creationState = creationState;
    }

    public BasicDotIdentifierConsumer(SemanticPathPart initialState, SqmCreationState creationState) {
        this.currentPart = initialState;
        this.creationState = creationState;
    }

    protected SqmCreationState getCreationState() {
        return this.creationState;
    }

    @Override
    public SemanticPathPart getConsumedPart() {
        return this.currentPart;
    }

    @Override
    public void consumeIdentifier(String identifier, boolean isBase, boolean isTerminal) {
        if (isBase) {
            this.reset();
        }
        if (this.pathSoFar.length() != 0) {
            this.pathSoFar.append('.');
        }
        this.pathSoFar.append(identifier);
        HqlLogging.QUERY_LOGGER.tracef("BasicDotIdentifierHandler#consumeIdentifier( %s, %s, %s ) - %s", new Object[]{identifier, isBase, isTerminal, this.pathSoFar});
        this.currentPart = this.currentPart.resolvePathPart(identifier, isTerminal, this.creationState);
    }

    @Override
    public void consumeTreat(String entityName, boolean isTerminal) {
        EntityType entityDomainType = this.creationState.getCreationContext().getJpaMetamodel().entity(entityName);
        this.currentPart = ((SqmPath)this.currentPart).treatAs((EntityDomainType)entityDomainType);
    }

    protected void reset() {
        this.pathSoFar.setLength(0);
        this.currentPart = this.createBasePart();
    }

    protected SemanticPathPart createBasePart() {
        return new BaseLocalSequencePart();
    }

    public class BaseLocalSequencePart
    implements SemanticPathPart {
        private boolean isBase = true;

        @Override
        public SemanticPathPart resolvePathPart(String identifier, boolean isTerminal, SqmCreationState creationState) {
            EntityType entityDomainType;
            HqlLogging.QUERY_LOGGER.tracef("BaseLocalSequencePart#consumeIdentifier( %s, %s, %s ) - %s", new Object[]{identifier, this.isBase, isTerminal, BasicDotIdentifierConsumer.this.pathSoFar});
            if (this.isBase) {
                this.isBase = false;
                SqmPathRegistry sqmPathRegistry = creationState.getProcessingStateStack().getCurrent().getPathRegistry();
                Object pathRootByAlias = sqmPathRegistry.findFromByAlias(identifier, true);
                if (pathRootByAlias != null) {
                    this.validateAsRoot((SqmFrom<?, ?>)pathRootByAlias);
                    if (isTerminal) {
                        return pathRootByAlias;
                    }
                    return new DomainPathPart((SqmPath<?>)pathRootByAlias);
                }
                Object pathRootByExposedNavigable = sqmPathRegistry.findFromExposing(identifier);
                if (pathRootByExposedNavigable != null) {
                    this.validateAsRoot((SqmFrom<?, ?>)pathRootByExposedNavigable);
                    JpaPath sqmPath = pathRootByExposedNavigable.get(identifier);
                    if (isTerminal) {
                        return sqmPath;
                    }
                    return new DomainPathPart((SqmPath<?>)sqmPath);
                }
            }
            SqmCreationContext creationContext = creationState.getCreationContext();
            if (!isTerminal) {
                return this;
            }
            String path = BasicDotIdentifierConsumer.this.pathSoFar.toString();
            JpaMetamodelImplementor jpaMetamodel = creationContext.getJpaMetamodel();
            String importableName = jpaMetamodel.qualifyImportableName(path);
            NodeBuilder nodeBuilder = creationContext.getNodeBuilder();
            if (importableName != null && (entityDomainType = jpaMetamodel.entity(importableName)) != null) {
                return new SqmLiteralEntityType(entityDomainType, nodeBuilder);
            }
            SqmFunctionDescriptor functionDescriptor = creationContext.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(path);
            if (functionDescriptor != null) {
                return functionDescriptor.generateSqmExpression(null, creationContext.getQueryEngine());
            }
            int splitPosition = path.lastIndexOf(46);
            if (splitPosition > 0) {
                String prefix = path.substring(0, splitPosition);
                String terminal = path.substring(splitPosition + 1);
                EnumJavaType<?> enumType = jpaMetamodel.getEnumType(prefix);
                if (enumType != null) {
                    return new SqmEnumLiteral(jpaMetamodel.enumValue(enumType, terminal), enumType, terminal, nodeBuilder);
                }
                try {
                    Field referencedField;
                    Class namedClass = creationContext.getServiceRegistry().requireService(ClassLoaderService.class).classForName(prefix);
                    if (namedClass != null && (referencedField = namedClass.getDeclaredField(terminal)) != null) {
                        JavaType fieldJtd = jpaMetamodel.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(referencedField.getType());
                        return new SqmFieldLiteral(referencedField, fieldJtd, nodeBuilder);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new SemanticException(String.format("Could not interpret path expression '%s'", path));
        }

        protected void validateAsRoot(SqmFrom<?, ?> pathRoot) {
        }

        @Override
        public SqmPath<?> resolveIndexedAccess(SqmExpression<?> selector, boolean isTerminal, SqmCreationState processingState) {
            return BasicDotIdentifierConsumer.this.currentPart.resolveIndexedAccess(selector, isTerminal, processingState);
        }
    }
}

