/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.EntityType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.hql.HqlInterpretationException;
import org.hibernate.query.hql.internal.FullyQualifiedReflectivePath;
import org.hibernate.query.hql.internal.FullyQualifiedReflectivePathSource;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.expression.SqmEnumLiteral;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.type.descriptor.java.EnumJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;

public class FullyQualifiedReflectivePathTerminal
extends FullyQualifiedReflectivePath
implements SqmExpression {
    private final SqmExpressible expressibleType;
    private final SqmCreationState creationState;
    private final Function<SemanticQueryWalker, ?> handler;

    public FullyQualifiedReflectivePathTerminal(FullyQualifiedReflectivePathSource pathSource, String subPathName, SqmCreationState creationState) {
        super(pathSource, subPathName);
        this.creationState = creationState;
        this.handler = this.resolveTerminalSemantic();
        this.expressibleType = null;
    }

    @Override
    public FullyQualifiedReflectivePathTerminal copy(SqmCopyContext context) {
        return this;
    }

    private Function<SemanticQueryWalker, ?> resolveTerminalSemantic() {
        return semanticQueryWalker -> {
            SqmCreationContext creationContext = this.creationState.getCreationContext();
            ClassLoaderService cls = creationContext.getServiceRegistry().requireService(ClassLoaderService.class);
            String fullPath = this.getFullPath();
            EntityType entityDescriptor = creationContext.getJpaMetamodel().entity(fullPath);
            if (entityDescriptor != null) {
                return new SqmLiteralEntityType(entityDescriptor, creationContext.getNodeBuilder());
            }
            try {
                Class namedClass = cls.classForName(fullPath);
                if (namedClass != null) {
                    return semanticQueryWalker.visitFullyQualifiedClass(namedClass);
                }
            }
            catch (ClassLoadingException namedClass) {
                // empty catch block
            }
            String parentFullPath = this.getParent().getFullPath();
            try {
                Class namedClass = cls.classForName(parentFullPath);
                if (namedClass != null) {
                    return this.createEnumOrFieldLiteral(namedClass);
                }
            }
            catch (NoSuchFieldException | ClassLoadingException object) {
                // empty catch block
            }
            throw new HqlInterpretationException("Unsure how to handle semantic path terminal - " + fullPath);
        };
    }

    private SqmExpression createEnumOrFieldLiteral(Class namedClass) throws NoSuchFieldException {
        if (namedClass.isEnum()) {
            return new SqmEnumLiteral(Enum.valueOf(namedClass, this.getLocalName()), (EnumJavaType)this.javaTypeRegistry().resolveDescriptor((Type)namedClass, () -> new EnumJavaType(namedClass)), this.getLocalName(), this.nodeBuilder());
        }
        return new SqmFieldLiteral(namedClass.getField(this.getLocalName()), this.javaTypeRegistry().resolveDescriptor((Type)namedClass, () -> new EnumJavaType(namedClass)), this.nodeBuilder());
    }

    private JavaTypeRegistry javaTypeRegistry() {
        return this.creationState.getCreationContext().getTypeConfiguration().getJavaTypeRegistry();
    }

    @Override
    public SqmExpressible getNodeType() {
        return this.expressibleType;
    }

    public Object accept(SemanticQueryWalker walker) {
        return this.handler.apply(walker);
    }

    @Override
    public JavaType getJavaTypeDescriptor() {
        return this.expressibleType.getExpressibleJavaType();
    }

    public void applyInferableType(SqmExpressible type) {
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(this.getParent().getFullPath());
        sb.append('.');
        sb.append(this.getLocalName());
    }

    @Override
    public SqmExpression<Long> asLong() {
        return null;
    }

    @Override
    public SqmExpression<Integer> asInteger() {
        return null;
    }

    @Override
    public SqmExpression<Float> asFloat() {
        return null;
    }

    @Override
    public SqmExpression<Double> asDouble() {
        return null;
    }

    @Override
    public SqmExpression<BigDecimal> asBigDecimal() {
        return null;
    }

    @Override
    public SqmExpression<BigInteger> asBigInteger() {
        return null;
    }

    @Override
    public SqmExpression<String> asString() {
        return null;
    }

    @Override
    public SqmExpression as(Class type) {
        return null;
    }

    @Override
    public SqmPredicate isNull() {
        return null;
    }

    @Override
    public SqmPredicate isNotNull() {
        return null;
    }

    @Override
    public SqmPredicate equalTo(Expression that) {
        return null;
    }

    @Override
    public SqmPredicate equalTo(Object that) {
        return null;
    }

    public Predicate notEqualTo(Expression value) {
        return null;
    }

    public Predicate notEqualTo(Object value) {
        return null;
    }

    public Expression cast(Class type) {
        return null;
    }

    @Override
    public SqmPredicate in(Object ... values) {
        return null;
    }

    @Override
    public SqmPredicate in(Expression[] values) {
        return null;
    }

    @Override
    public SqmPredicate in(Collection values) {
        return null;
    }

    @Override
    public SqmPredicate in(Expression values) {
        return null;
    }

    @Override
    public List<? extends JpaSelection<?>> getSelectionItems() {
        return null;
    }

    @Override
    public JpaSelection alias(String name) {
        return null;
    }

    public boolean isCompoundSelection() {
        return false;
    }

    public String getAlias() {
        return null;
    }

    @Override
    public NodeBuilder nodeBuilder() {
        return null;
    }
}

