/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaCrossJoin;
import org.hibernate.query.criteria.JpaFrom;
import org.hibernate.query.criteria.JpaJoin;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.AliasCollisionException;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmTreeCreationLogger;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmAliasedNode;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.spi.NavigablePath;

public class SqmPathRegistryImpl
implements SqmPathRegistry {
    private final SqmCreationProcessingState associatedProcessingState;
    private final JpaCompliance jpaCompliance;
    private final Map<NavigablePath, SqmPath<?>> sqmPathByPath = new HashMap();
    private final Map<NavigablePath, SqmFrom<?, ?>> sqmFromByPath = new HashMap();
    private final Map<String, SqmFrom<?, ?>> sqmFromByAlias = new HashMap();
    private final List<SqmAliasedNode<?>> simpleSelectionNodes = new ArrayList();

    public SqmPathRegistryImpl(SqmCreationProcessingState associatedProcessingState) {
        this.associatedProcessingState = associatedProcessingState;
        this.jpaCompliance = associatedProcessingState.getCreationState().getCreationContext().getJpaMetamodel().getJpaCompliance();
    }

    @Override
    public void register(SqmPath<?> sqmPath) {
        SqmPath<?> previousPath;
        SqmTreeCreationLogger.LOGGER.tracef("SqmProcessingIndex#register(SqmPath) : %s", (Object)sqmPath.getNavigablePath());
        if (sqmPath instanceof SqmFrom) {
            SqmFrom sqmFrom = (SqmFrom)sqmPath;
            this.registerByAliasOnly(sqmFrom);
            SqmFrom previousFromByPath = this.sqmFromByPath.put(sqmPath.getNavigablePath(), sqmFrom);
            if (previousFromByPath != null) {
                throw new ParsingException(String.format(Locale.ROOT, "Registration for SqmFrom [%s] overrode previous registration: %s -> %s", sqmPath.getNavigablePath(), previousFromByPath, sqmFrom));
            }
        }
        if ((previousPath = this.sqmPathByPath.put(sqmPath.getNavigablePath(), sqmPath)) instanceof SqmFrom) {
            throw new ParsingException(String.format(Locale.ROOT, "Registration for path [%s] overrode previous registration: %s -> %s", sqmPath.getNavigablePath(), previousPath, sqmPath));
        }
    }

    private static String fromPath(SqmFrom<?, ?> sqmFrom, boolean first) {
        String path = sqmFrom.getNavigablePath().getLocalName();
        String alias = sqmFrom.getExplicitAlias();
        String keyword = sqmFrom instanceof SqmRoot && first ? "from " : (sqmFrom instanceof SqmJoin ? (first ? "join " : " join ") : (first ? "" : ", "));
        return keyword + (String)(alias == null ? path : path + " as " + alias);
    }

    @Override
    public void registerByAliasOnly(SqmFrom<?, ?> sqmFrom) {
        String aliasToUse;
        SqmFrom<?, ?> previousFrom;
        String alias = sqmFrom.getExplicitAlias();
        if (alias != null && (previousFrom = this.sqmFromByAlias.put(aliasToUse = this.jpaCompliance.isJpaQueryComplianceEnabled() ? alias.toLowerCase(Locale.getDefault()) : alias, sqmFrom)) != null) {
            throw new AliasCollisionException(String.format(Locale.ENGLISH, "Duplicate identification variable '%s' in 'from' clause [%s%s]", alias, SqmPathRegistryImpl.fromPath(previousFrom, true), SqmPathRegistryImpl.fromPath(sqmFrom, false)));
        }
    }

    @Override
    public <E> void replace(SqmEntityJoin<?, E> sqmJoin, SqmRoot<E> sqmRoot) {
        String aliasToUse;
        SqmFrom previousFrom;
        String alias = sqmJoin.getExplicitAlias();
        if (alias != null && (previousFrom = (SqmFrom)this.sqmFromByAlias.put(aliasToUse = this.jpaCompliance.isJpaQueryComplianceEnabled() ? alias.toLowerCase(Locale.getDefault()) : alias, sqmJoin)) != null && !(previousFrom instanceof SqmRoot)) {
            throw new AliasCollisionException(String.format(Locale.ENGLISH, "Duplicate identification variable '%s' in 'join' clause [%s%s]", alias, SqmPathRegistryImpl.fromPath(previousFrom, true), SqmPathRegistryImpl.fromPath(sqmJoin, false)));
        }
        SqmFrom previousFromByPath = this.sqmFromByPath.put(sqmJoin.getNavigablePath(), sqmJoin);
        if (previousFromByPath != null && !(previousFromByPath instanceof SqmRoot)) {
            throw new ParsingException(String.format(Locale.ROOT, "Registration for SqmFrom [%s] overrode previous registration: %s -> %s", sqmJoin.getNavigablePath(), previousFromByPath, sqmJoin));
        }
        SqmPath previousPath = this.sqmPathByPath.put(sqmJoin.getNavigablePath(), sqmJoin);
        if (previousPath instanceof SqmFrom && !(previousPath instanceof SqmRoot)) {
            throw new ParsingException(String.format(Locale.ROOT, "Registration for path [%s] overrode previous registration: %s -> %s", sqmJoin.getNavigablePath(), previousPath, sqmJoin));
        }
    }

    @Override
    public <X extends SqmFrom<?, ?>> X findFromByPath(NavigablePath navigablePath) {
        return (X)this.sqmFromByPath.get(navigablePath);
    }

    @Override
    public <X extends SqmFrom<?, ?>> X findFromByAlias(String alias, boolean searchParent) {
        String localAlias = this.jpaCompliance.isJpaQueryComplianceEnabled() ? alias.toLowerCase(Locale.getDefault()) : alias;
        SqmFrom<?, ?> registered = this.sqmFromByAlias.get(localAlias);
        if (registered != null) {
            return (X)registered;
        }
        SqmCreationProcessingState parentProcessingState = this.associatedProcessingState.getParentProcessingState();
        if (searchParent && parentProcessingState != null) {
            Object parentRegistered;
            do {
                parentRegistered = parentProcessingState.getPathRegistry().findFromByAlias(alias, false);
            } while ((parentProcessingState = parentProcessingState.getParentProcessingState()) != null && parentRegistered == null);
            if (parentRegistered != null) {
                JpaFrom correlated;
                SqmSubQuery selectQuery = (SqmSubQuery)this.associatedProcessingState.getProcessingQuery();
                if (parentRegistered instanceof Root) {
                    correlated = selectQuery.correlate((Root)parentRegistered);
                } else if (parentRegistered instanceof Join) {
                    correlated = selectQuery.correlate((Join)parentRegistered);
                } else if (parentRegistered instanceof SqmCrossJoin) {
                    correlated = selectQuery.correlate((JpaCrossJoin)parentRegistered);
                } else if (parentRegistered instanceof SqmEntityJoin) {
                    correlated = selectQuery.correlate((Join)((SqmEntityJoin)parentRegistered));
                } else {
                    throw new UnsupportedOperationException("Can't correlate from node: " + parentRegistered);
                }
                this.register((SqmPath<?>)((Object)correlated));
                return (X)correlated;
            }
        }
        return null;
    }

    @Override
    public <X extends SqmFrom<?, ?>> X findFromExposing(String navigableName) {
        SqmFrom<?, ?> found = null;
        for (Map.Entry<NavigablePath, SqmFrom<?, ?>> entry : this.sqmFromByPath.entrySet()) {
            SqmFrom<?, ?> fromElement = entry.getValue();
            if (!this.definesAttribute(fromElement.getReferencedPathSource(), navigableName)) continue;
            if (found != null) {
                throw new SemanticException("Ambiguous unqualified attribute reference '" + navigableName + "' (qualify the attribute reference by an identification variable)");
            }
            found = fromElement;
        }
        if (found == null && this.associatedProcessingState.getParentProcessingState() != null) {
            HqlLogging.QUERY_LOGGER.debugf("Unable to resolve unqualified attribute [%s] in local from-clause; checking parent ", navigableName);
            found = (SqmFrom<?, ?>)this.associatedProcessingState.getParentProcessingState().getPathRegistry().findFromExposing(navigableName);
        }
        HqlLogging.QUERY_LOGGER.debugf("Unable to resolve unqualified attribute [%s] in local from-clause", navigableName);
        return (X)found;
    }

    @Override
    public <X extends SqmFrom<?, ?>> X resolveFrom(NavigablePath navigablePath, Function<NavigablePath, SqmFrom<?, ?>> creator) {
        SqmTreeCreationLogger.LOGGER.tracef("SqmProcessingIndex#resolvePath(NavigablePath) : %s", (Object)navigablePath);
        SqmFrom<?, ?> existing = this.sqmFromByPath.get(navigablePath);
        if (existing != null) {
            return (X)existing;
        }
        SqmFrom<?, ?> sqmFrom = creator.apply(navigablePath);
        this.register(sqmFrom);
        return (X)sqmFrom;
    }

    @Override
    public <X extends SqmFrom<?, ?>> X resolveFrom(SqmPath<?> path) {
        SqmTreeCreationLogger.LOGGER.tracef("SqmProcessingIndex#resolvePath(SqmPath) : %s", path);
        SqmFrom<?, ?> existing = this.sqmFromByPath.get(path.getNavigablePath());
        if (existing != null) {
            return (X)existing;
        }
        JpaJoin sqmFrom = this.resolveFrom((SqmPath<?>)path.getLhs()).join(path.getNavigablePath().getLocalName());
        this.register((SqmPath<?>)((Object)sqmFrom));
        return (X)sqmFrom;
    }

    private boolean definesAttribute(SqmPathSource<?> containerType, String name) {
        return !(containerType.getSqmType() instanceof BasicDomainType) && containerType.findSubPathSource(name, this.getJpaMetamodel()) != null;
    }

    private JpaMetamodelImplementor getJpaMetamodel() {
        return this.associatedProcessingState.getCreationState().getCreationContext().getJpaMetamodel();
    }

    @Override
    public SqmAliasedNode<?> findAliasedNodeByAlias(String alias) {
        assert (alias != null);
        String aliasToUse = this.jpaCompliance.isJpaQueryComplianceEnabled() ? alias.toLowerCase(Locale.getDefault()) : alias;
        for (int i = 0; i < this.simpleSelectionNodes.size(); ++i) {
            SqmAliasedNode<?> node = this.simpleSelectionNodes.get(i);
            if (!aliasToUse.equals(node.getAlias())) continue;
            return node;
        }
        return null;
    }

    @Override
    public Integer findAliasedNodePosition(String alias) {
        if (alias == null) {
            return null;
        }
        String aliasToUse = this.jpaCompliance.isJpaQueryComplianceEnabled() ? alias.toLowerCase(Locale.getDefault()) : alias;
        for (int i = 0; i < this.simpleSelectionNodes.size(); ++i) {
            SqmAliasedNode<?> node = this.simpleSelectionNodes.get(i);
            if (!aliasToUse.equals(node.getAlias())) continue;
            return i + 1;
        }
        return null;
    }

    @Override
    public SqmAliasedNode<?> findAliasedNodeByPosition(int position) {
        return position > this.simpleSelectionNodes.size() ? null : this.simpleSelectionNodes.get(position - 1);
    }

    @Override
    public void register(SqmAliasedNode<?> node) {
        this.checkResultVariable(node);
        this.simpleSelectionNodes.add(node);
    }

    private void checkResultVariable(SqmAliasedNode<?> selection) {
        String alias = selection.getAlias();
        if (alias == null) {
            return;
        }
        Integer position = this.findAliasedNodePosition(alias);
        if (position != null) {
            throw new AliasCollisionException(String.format(Locale.ENGLISH, "Duplicate alias '%s' at position %s in 'select' clause", alias, position));
        }
    }
}

