/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedRootJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public class SqmCorrelatedMapJoin<L, K, V>
extends SqmMapJoin<L, K, V>
implements SqmCorrelatedJoin<L, V> {
    private final SqmCorrelatedRootJoin<L> correlatedRootJoin;
    private final SqmMapJoin<L, K, V> correlationParent;

    public SqmCorrelatedMapJoin(SqmMapJoin<L, K, V> correlationParent) {
        super(correlationParent.getLhs(), correlationParent.getNavigablePath(), correlationParent.getAttribute(), correlationParent.getExplicitAlias(), SqmJoinType.INNER, false, (NodeBuilder)correlationParent.nodeBuilder());
        this.correlatedRootJoin = SqmCorrelatedRootJoin.create(correlationParent, this);
        this.correlationParent = correlationParent;
    }

    private SqmCorrelatedMapJoin(SqmFrom<?, L> lhs, MapPersistentAttribute<L, K, V> attribute, String alias, SqmJoinType sqmJoinType, boolean fetched, NodeBuilder nodeBuilder, SqmCorrelatedRootJoin<L> correlatedRootJoin, SqmMapJoin<L, K, V> correlationParent) {
        super(lhs, correlationParent.getNavigablePath(), attribute, alias, sqmJoinType, fetched, nodeBuilder);
        this.correlatedRootJoin = correlatedRootJoin;
        this.correlationParent = correlationParent;
    }

    @Override
    public SqmCorrelatedMapJoin<L, K, V> copy(SqmCopyContext context) {
        SqmCorrelatedMapJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmCorrelatedMapJoin<L, K, V> path = context.registerCopy(this, new SqmCorrelatedMapJoin<L, K, V>(this.getLhs().copy(context), this.getAttribute(), this.getExplicitAlias(), this.getSqmJoinType(), this.isFetched(), this.nodeBuilder(), this.correlatedRootJoin.copy(context), this.correlationParent.copy(context)));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public SqmMapJoin<L, K, V> getCorrelationParent() {
        return this.correlationParent;
    }

    @Override
    public SqmPath<V> getWrappedPath() {
        return this.correlationParent;
    }

    @Override
    public boolean isCorrelated() {
        return true;
    }

    @Override
    public SqmRoot<L> getCorrelatedRoot() {
        return this.correlatedRootJoin;
    }

    @Override
    public SqmCorrelatedMapJoin<L, K, V> makeCopy(SqmCreationProcessingState creationProcessingState) {
        SqmPathRegistry pathRegistry = creationProcessingState.getPathRegistry();
        return new SqmCorrelatedMapJoin<L, K, V>(pathRegistry.findFromByPath(this.getLhs().getNavigablePath()), this.getAttribute(), this.getExplicitAlias(), this.getSqmJoinType(), this.isFetched(), this.nodeBuilder(), (SqmCorrelatedRootJoin)pathRegistry.findFromByPath(this.correlatedRootJoin.getNavigablePath()), (SqmMapJoin)pathRegistry.findFromByPath(this.correlationParent.getNavigablePath()));
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitCorrelatedMapJoin(this);
    }
}

