/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import jakarta.persistence.criteria.JoinType;
import org.hibernate.Incubating;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedEntityJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatedJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.NavigablePath;

@Incubating
public class SqmCteJoin<T>
extends AbstractSqmJoin<T, T> {
    private final SqmCteStatement<T> cte;

    public SqmCteJoin(SqmCteStatement<T> cte, String alias, SqmJoinType joinType, SqmRoot<T> sqmRoot) {
        this(SqmCreationHelper.buildRootNavigablePath("<<cte>>", alias), cte, cte.getCteTable().getTupleType(), alias, joinType, sqmRoot);
    }

    protected SqmCteJoin(NavigablePath navigablePath, SqmCteStatement<T> cte, SqmPathSource<T> pathSource, String alias, SqmJoinType joinType, SqmRoot<T> sqmRoot) {
        super(navigablePath, pathSource, sqmRoot, alias, joinType, sqmRoot.nodeBuilder());
        this.cte = cte;
    }

    @Override
    public boolean isImplicitlySelectable() {
        return false;
    }

    @Override
    public SqmCteJoin<T> copy(SqmCopyContext context) {
        SqmCteJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmCteJoin path = context.registerCopy(this, new SqmCteJoin(this.getNavigablePath(), this.cte.copy(context), this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), this.findRoot().copy(context)));
        this.copyTo(path, context);
        return path;
    }

    public SqmRoot<?> getRoot() {
        return (SqmRoot)super.getLhs();
    }

    @Override
    public SqmRoot<?> findRoot() {
        return this.getRoot();
    }

    public SqmCteStatement<T> getCte() {
        return this.cte;
    }

    @Override
    public SqmFrom<?, T> getLhs() {
        return null;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitQualifiedCteJoin(this);
    }

    @Override
    public SqmCorrelatedEntityJoin<T, T> createCorrelation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PersistentAttribute<? super T, ?> getAttribute() {
        return null;
    }

    @Override
    public <S extends T> SqmTreatedJoin<T, T, S> treatAs(Class<S> treatJavaType, String alias) {
        throw new UnsupportedOperationException("CTE joins can not be treated");
    }

    @Override
    public <S extends T> SqmTreatedJoin<T, T, S> treatAs(EntityDomainType<S> treatTarget, String alias) {
        throw new UnsupportedOperationException("CTE joins can not be treated");
    }

    @Override
    public <S extends T> SqmTreatedJoin<T, T, S> treatAs(Class<S> treatJavaType, String alias, boolean fetched) {
        throw new UnsupportedOperationException("CTE joins can not be treated");
    }

    @Override
    public <S extends T> SqmTreatedJoin<T, T, S> treatAs(EntityDomainType<S> treatTarget, String alias, boolean fetched) {
        throw new UnsupportedOperationException("CTE joins can not be treated");
    }

    @Override
    public SqmFrom<?, T> getParent() {
        return this.getCorrelationParent();
    }

    @Override
    public JoinType getJoinType() {
        return this.getSqmJoinType().getCorrespondingJpaJoinType();
    }
}

