/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.spi;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.ResultListTransformer;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.jdbc.spi.JdbcValues;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.EntityJavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class ListResultsConsumer<R>
implements ResultsConsumer<List<R>, R> {
    private static final ListResultsConsumer<?> NEVER_DE_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.NEVER);
    private static final ListResultsConsumer<?> ALLOW_DE_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.ALLOW);
    private static final ListResultsConsumer<?> IGNORE_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.NONE);
    private static final ListResultsConsumer<?> DE_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.FILTER);
    private static final ListResultsConsumer<?> ERROR_DUP_CONSUMER = new ListResultsConsumer(UniqueSemantic.ASSERT);
    private final UniqueSemantic uniqueSemantic;

    public static <R> ListResultsConsumer<R> instance(UniqueSemantic uniqueSemantic) {
        switch (uniqueSemantic) {
            case ASSERT: {
                return ERROR_DUP_CONSUMER;
            }
            case FILTER: {
                return DE_DUP_CONSUMER;
            }
            case NEVER: {
                return NEVER_DE_DUP_CONSUMER;
            }
            case ALLOW: {
                return ALLOW_DE_DUP_CONSUMER;
            }
        }
        return IGNORE_DUP_CONSUMER;
    }

    public ListResultsConsumer(UniqueSemantic uniqueSemantic) {
        this.uniqueSemantic = uniqueSemantic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<R> consume(JdbcValues jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader) {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        TypeConfiguration typeConfiguration = session.getTypeConfiguration();
        QueryOptions queryOptions = rowProcessingState.getQueryOptions();
        RuntimeException ex = null;
        persistenceContext.beforeLoad();
        persistenceContext.getLoadContexts().register(jdbcValuesSourceProcessingState);
        try {
            JavaType<R> domainResultJavaType = this.resolveDomainResultJavaType(rowReader.getDomainResultResultJavaType(), rowReader.getResultJavaTypes(), typeConfiguration);
            boolean isEntityResultType = domainResultJavaType instanceof EntityJavaType;
            Results results = isEntityResultType && (this.uniqueSemantic == UniqueSemantic.ALLOW || this.uniqueSemantic == UniqueSemantic.FILTER) ? new EntityResult<R>(domainResultJavaType) : new Results(domainResultJavaType);
            rowReader.getInitializersList().startLoading(rowProcessingState);
            int readRows = 0;
            if (this.uniqueSemantic == UniqueSemantic.FILTER || this.uniqueSemantic == UniqueSemantic.ASSERT && rowProcessingState.hasCollectionInitializers() || this.uniqueSemantic == UniqueSemantic.ALLOW && isEntityResultType) {
                while (rowProcessingState.next()) {
                    boolean added = results.addUnique(rowReader.readRow(rowProcessingState, processingOptions));
                    rowProcessingState.finishRowProcessing(added);
                    ++readRows;
                }
            } else if (this.uniqueSemantic != UniqueSemantic.ASSERT) {
                while (rowProcessingState.next()) {
                    results.add(rowReader.readRow(rowProcessingState, processingOptions));
                    rowProcessingState.finishRowProcessing(true);
                    ++readRows;
                }
            } else {
                while (rowProcessingState.next()) {
                    if (!results.addUnique(rowReader.readRow(rowProcessingState, processingOptions))) {
                        throw new HibernateException(String.format(Locale.ROOT, "Duplicate row was found and `%s` was specified", new Object[]{UniqueSemantic.ASSERT}));
                    }
                    rowProcessingState.finishRowProcessing(true);
                    ++readRows;
                }
            }
            rowReader.finishUp(jdbcValuesSourceProcessingState);
            jdbcValuesSourceProcessingState.finishUp(readRows > 1);
            ResultListTransformer<?> resultListTransformer = queryOptions.getResultListTransformer();
            if (resultListTransformer != null) {
                List<?> list = resultListTransformer.transformList(results.getResults());
                return list;
            }
            List<R> list = results.getResults();
            return list;
        }
        catch (RuntimeException e) {
            ex = e;
            return ex;
        }
        finally {
            try {
                jdbcValues.finishUp(session);
                persistenceContext.afterLoad();
                persistenceContext.getLoadContexts().deregister(jdbcValuesSourceProcessingState);
                persistenceContext.initializeNonLazyCollections();
            }
            catch (RuntimeException e) {
                if (ex != null) {
                    ex.addSuppressed(e);
                }
                ex = e;
                return ex;
            }
            finally {
                if (ex == null) throw new IllegalStateException("Should not reach this");
                throw ex;
            }
        }
    }

    private JavaType<R> resolveDomainResultJavaType(Class<R> domainResultResultJavaType, List<JavaType<?>> resultJavaTypes, TypeConfiguration typeConfiguration) {
        JavaTypeRegistry javaTypeRegistry = typeConfiguration.getJavaTypeRegistry();
        if (domainResultResultJavaType != null) {
            return javaTypeRegistry.resolveDescriptor(domainResultResultJavaType);
        }
        if (resultJavaTypes.size() == 1) {
            return resultJavaTypes.get(0);
        }
        return javaTypeRegistry.resolveDescriptor((Type)((Object)Object[].class));
    }

    @Override
    public boolean canResultsBeCached() {
        return true;
    }

    public String toString() {
        return "ListResultsConsumer(" + this.uniqueSemantic + ")";
    }

    public static enum UniqueSemantic {
        NONE,
        FILTER,
        ASSERT,
        NEVER,
        ALLOW;

    }

    private static class EntityResult<R>
    extends Results<R> {
        private static final Object DUMP_VALUE = new Object();
        private final IdentityHashMap<R, Object> added = new IdentityHashMap();

        public EntityResult(JavaType<R> resultJavaType) {
            super(resultJavaType);
        }

        @Override
        public boolean addUnique(R result) {
            if (this.added.put(result, DUMP_VALUE) == null) {
                super.add(result);
                return true;
            }
            return false;
        }
    }

    private static class Results<R> {
        private final List<R> results = new ArrayList<R>();
        private final JavaType<R> resultJavaType;

        public Results(JavaType<R> resultJavaType) {
            this.resultJavaType = resultJavaType;
        }

        public boolean addUnique(R result) {
            for (int i = 0; i < this.results.size(); ++i) {
                if (!this.resultJavaType.areEqual(this.results.get(i), result)) continue;
                return false;
            }
            this.results.add(result);
            return true;
        }

        public void add(R result) {
            this.results.add(result);
        }

        public List<R> getResults() {
            return this.results;
        }
    }
}

