/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import jakarta.persistence.GenerationType;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.TableGenerator;
import java.util.List;
import java.util.UUID;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.id.IncrementGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationUsage;

public class GenerationStrategyInterpreter {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(GenerationStrategyInterpreter.class);
    public static final GenerationStrategyInterpreter STRATEGY_INTERPRETER = new GenerationStrategyInterpreter();

    private GenerationStrategyInterpreter() {
    }

    public String determineGeneratorName(GenerationType generationType, GeneratorNameDeterminationContext context) {
        switch (generationType) {
            case IDENTITY: {
                return "identity";
            }
            case SEQUENCE: {
                return SequenceStyleGenerator.class.getName();
            }
            case TABLE: {
                return org.hibernate.id.enhanced.TableGenerator.class.getName();
            }
            case UUID: {
                return UUIDGenerator.class.getName();
            }
            case AUTO: {
                if (UUID.class.isAssignableFrom(context.getIdType())) {
                    return UUIDGenerator.class.getName();
                }
                if ("increment".equalsIgnoreCase(context.getGeneratedValueGeneratorName())) {
                    return IncrementGenerator.class.getName();
                }
                return SequenceStyleGenerator.class.getName();
            }
        }
        throw new UnsupportedOperationException("Unsupported generation type:" + generationType);
    }

    public void interpretTableGenerator(AnnotationUsage<TableGenerator> tableGeneratorAnnotation, IdentifierGeneratorDefinition.Builder definitionBuilder) {
        String valueColumnName;
        String pkColumnValue;
        String pkColumnName;
        String table;
        String schema;
        definitionBuilder.setName(tableGeneratorAnnotation.getString("name"));
        definitionBuilder.setStrategy(org.hibernate.id.enhanced.TableGenerator.class.getName());
        definitionBuilder.addParam("prefer_entity_table_as_segment_value", "true");
        String catalog = tableGeneratorAnnotation.getString("catalog");
        if (StringHelper.isNotEmpty(catalog)) {
            definitionBuilder.addParam("catalog", catalog);
        }
        if (StringHelper.isNotEmpty(schema = tableGeneratorAnnotation.getString("schema"))) {
            definitionBuilder.addParam("schema", schema);
        }
        if (StringHelper.isNotEmpty(table = tableGeneratorAnnotation.getString("table"))) {
            definitionBuilder.addParam("table_name", table);
        }
        if (StringHelper.isNotEmpty(pkColumnName = tableGeneratorAnnotation.getString("pkColumnName"))) {
            definitionBuilder.addParam("segment_column_name", pkColumnName);
        }
        if (StringHelper.isNotEmpty(pkColumnValue = tableGeneratorAnnotation.getString("pkColumnValue"))) {
            definitionBuilder.addParam("segment_value", pkColumnValue);
        }
        if (StringHelper.isNotEmpty(valueColumnName = tableGeneratorAnnotation.getString("valueColumnName"))) {
            definitionBuilder.addParam("value_column_name", valueColumnName);
        }
        definitionBuilder.addParam("increment_size", String.valueOf(tableGeneratorAnnotation.getInteger("allocationSize")));
        definitionBuilder.addParam("initial_value", String.valueOf(tableGeneratorAnnotation.getInteger("initialValue") + 1));
        List uniqueConstraints = tableGeneratorAnnotation.getList("uniqueConstraints");
        if (CollectionHelper.isNotEmpty(uniqueConstraints)) {
            LOG.ignoringTableGeneratorConstraints(tableGeneratorAnnotation.getString("name"));
        }
    }

    public void interpretSequenceGenerator(AnnotationUsage<SequenceGenerator> sequenceGeneratorAnnotation, IdentifierGeneratorDefinition.Builder definitionBuilder) {
        String sequenceName;
        String schema;
        definitionBuilder.setName(sequenceGeneratorAnnotation.getString("name"));
        definitionBuilder.setStrategy(SequenceStyleGenerator.class.getName());
        String catalog = sequenceGeneratorAnnotation.getString("catalog");
        if (StringHelper.isNotEmpty(catalog)) {
            definitionBuilder.addParam("catalog", catalog);
        }
        if (StringHelper.isNotEmpty(schema = sequenceGeneratorAnnotation.getString("schema"))) {
            definitionBuilder.addParam("schema", schema);
        }
        if (StringHelper.isNotEmpty(sequenceName = sequenceGeneratorAnnotation.getString("sequenceName"))) {
            definitionBuilder.addParam("sequence_name", sequenceName);
        }
        definitionBuilder.addParam("increment_size", String.valueOf(sequenceGeneratorAnnotation.getInteger("allocationSize")));
        definitionBuilder.addParam("initial_value", String.valueOf(sequenceGeneratorAnnotation.getInteger("initialValue")));
    }

    public static interface GeneratorNameDeterminationContext {
        public Class<?> getIdType();

        public String getGeneratedValueGeneratorName();
    }
}

