/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.CheckConstraint;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.MappedSuperclass;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.ColumnTransformer;
import org.hibernate.annotations.TimeZoneColumn;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.internal.AttributeConversionInfo;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.TimeZoneStorageHelper;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitBasicColumnNameSource;
import org.hibernate.boot.model.source.spi.AttributePath;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.AnnotationUsageHelper;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.jboss.logging.Logger;

public abstract class AbstractPropertyHolder
implements PropertyHolder {
    private static final Logger log = CoreLogging.logger(AbstractPropertyHolder.class);
    private final String path;
    protected final AbstractPropertyHolder parent;
    private final MetadataBuildingContext context;
    private Boolean isInIdClass;
    private Map<String, List<AnnotationUsage<Column>>> holderColumnOverride;
    private Map<String, List<AnnotationUsage<Column>>> currentPropertyColumnOverride;
    private Map<String, AnnotationUsage<ColumnTransformer>> holderColumnTransformerOverride;
    private Map<String, AnnotationUsage<ColumnTransformer>> currentPropertyColumnTransformerOverride;
    private Map<String, List<AnnotationUsage<JoinColumn>>> holderJoinColumnOverride;
    private Map<String, List<AnnotationUsage<JoinColumn>>> currentPropertyJoinColumnOverride;
    private Map<String, AnnotationUsage<JoinTable>> holderJoinTableOverride;
    private Map<String, AnnotationUsage<JoinTable>> currentPropertyJoinTableOverride;
    private Map<String, AnnotationUsage<ForeignKey>> holderForeignKeyOverride;
    private Map<String, AnnotationUsage<ForeignKey>> currentPropertyForeignKeyOverride;

    AbstractPropertyHolder(String path, PropertyHolder parent, ClassDetails clazzToProcess, MetadataBuildingContext context) {
        this.path = path;
        this.parent = (AbstractPropertyHolder)parent;
        this.context = context;
        this.buildHierarchyColumnOverride(clazzToProcess);
    }

    protected abstract String normalizeCompositePathForLogging(String var1);

    protected abstract String normalizeCompositePath(String var1);

    protected abstract AttributeConversionInfo locateAttributeConversionInfo(MemberDetails var1);

    protected abstract AttributeConversionInfo locateAttributeConversionInfo(String var1);

    @Override
    public ConverterDescriptor resolveAttributeConverterDescriptor(MemberDetails attributeMember) {
        AttributeConversionInfo info = this.locateAttributeConversionInfo(attributeMember);
        if (info != null) {
            if (info.isConversionDisabled()) {
                return null;
            }
            try {
                return this.makeAttributeConverterDescriptor(info);
            }
            catch (Exception e) {
                throw this.buildExceptionFromInstantiationError(info, e);
            }
        }
        log.debugf("Attempting to locate auto-apply AttributeConverter for attributeMember [%s:%s]", (Object)this.path, (Object)attributeMember.getName());
        return this.context.getMetadataCollector().getConverterRegistry().getAttributeConverterAutoApplyHandler().findAutoApplyConverterForAttribute(attributeMember, this.context);
    }

    protected IllegalStateException buildExceptionFromInstantiationError(AttributeConversionInfo info, Exception e) {
        if (Void.TYPE.equals(info.getConverterClass())) {
            return new IllegalStateException("Unable to instantiate AttributeConverter: you left @Convert.converter to its default value void.", e);
        }
        return new IllegalStateException(String.format("Unable to instantiate AttributeConverter [%s]", info.getConverterClass().getName()), e);
    }

    protected ConverterDescriptor makeAttributeConverterDescriptor(AttributeConversionInfo conversion) {
        try {
            return new ClassBasedConverterDescriptor(conversion.getConverterClass(), false, this.context.getBootstrapContext().getClassmateContext());
        }
        catch (Exception e) {
            throw new AnnotationException("Unable to create AttributeConverter instance", e);
        }
    }

    @Override
    public boolean isInIdClass() {
        if (this.isInIdClass != null) {
            return this.isInIdClass;
        }
        if (this.parent != null) {
            return this.parent.isInIdClass();
        }
        return false;
    }

    @Override
    public void setInIdClass(Boolean isInIdClass) {
        this.isInIdClass = isInIdClass;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    protected MetadataBuildingContext getContext() {
        return this.context;
    }

    protected void setCurrentProperty(MemberDetails attributeMember) {
        if (attributeMember == null) {
            this.currentPropertyColumnOverride = null;
            this.currentPropertyColumnTransformerOverride = null;
            this.currentPropertyJoinColumnOverride = null;
            this.currentPropertyJoinTableOverride = null;
            this.currentPropertyForeignKeyOverride = null;
        } else {
            this.currentPropertyColumnOverride = AbstractPropertyHolder.buildColumnOverride((AnnotationTarget)attributeMember, this.getPath(), this.context);
            if (this.currentPropertyColumnOverride.isEmpty()) {
                this.currentPropertyColumnOverride = null;
            }
            this.currentPropertyColumnTransformerOverride = AbstractPropertyHolder.buildColumnTransformerOverride((AnnotationTarget)attributeMember);
            if (this.currentPropertyColumnTransformerOverride.isEmpty()) {
                this.currentPropertyColumnTransformerOverride = null;
            }
            this.currentPropertyJoinColumnOverride = AbstractPropertyHolder.buildJoinColumnOverride((AnnotationTarget)attributeMember, this.getPath());
            if (this.currentPropertyJoinColumnOverride.isEmpty()) {
                this.currentPropertyJoinColumnOverride = null;
            }
            this.currentPropertyJoinTableOverride = AbstractPropertyHolder.buildJoinTableOverride((AnnotationTarget)attributeMember, this.getPath());
            if (this.currentPropertyJoinTableOverride.isEmpty()) {
                this.currentPropertyJoinTableOverride = null;
            }
            this.currentPropertyForeignKeyOverride = AbstractPropertyHolder.buildForeignKeyOverride((AnnotationTarget)attributeMember, this.getPath());
            if (this.currentPropertyForeignKeyOverride.isEmpty()) {
                this.currentPropertyForeignKeyOverride = null;
            }
        }
    }

    @Override
    public List<AnnotationUsage<Column>> getOverriddenColumn(String propertyName) {
        List<AnnotationUsage<Column>> result = this.getExactOverriddenColumn(propertyName);
        if (result == null && propertyName.contains(".collection&&element.")) {
            return this.getExactOverriddenColumn(propertyName.replace(".collection&&element.", "."));
        }
        return result;
    }

    @Override
    public AnnotationUsage<ColumnTransformer> getOverriddenColumnTransformer(String logicalColumnName) {
        AnnotationUsage<ColumnTransformer> result = null;
        if (this.parent != null) {
            result = this.parent.getOverriddenColumnTransformer(logicalColumnName);
        }
        if (result == null && this.currentPropertyColumnTransformerOverride != null) {
            result = this.currentPropertyColumnTransformerOverride.get(logicalColumnName);
        }
        if (result == null && this.holderColumnTransformerOverride != null) {
            result = this.holderColumnTransformerOverride.get(logicalColumnName);
        }
        return result;
    }

    private List<AnnotationUsage<Column>> getExactOverriddenColumn(String propertyName) {
        List<AnnotationUsage<Column>> result = null;
        if (this.parent != null) {
            result = this.parent.getExactOverriddenColumn(propertyName);
        }
        if (result == null && this.currentPropertyColumnOverride != null) {
            result = this.currentPropertyColumnOverride.get(propertyName);
        }
        if (result == null && this.holderColumnOverride != null) {
            result = this.holderColumnOverride.get(propertyName);
        }
        return result;
    }

    @Override
    public List<AnnotationUsage<JoinColumn>> getOverriddenJoinColumn(String propertyName) {
        List<AnnotationUsage<JoinColumn>> result = this.getExactOverriddenJoinColumn(propertyName);
        if (result == null && propertyName.contains(".collection&&element.")) {
            return this.getExactOverriddenJoinColumn(propertyName.replace(".collection&&element.", "."));
        }
        return result;
    }

    private List<AnnotationUsage<JoinColumn>> getExactOverriddenJoinColumn(String propertyName) {
        List<AnnotationUsage<JoinColumn>> result = null;
        if (this.parent != null) {
            result = this.parent.getExactOverriddenJoinColumn(propertyName);
        }
        if (result == null && this.currentPropertyJoinColumnOverride != null) {
            result = this.currentPropertyJoinColumnOverride.get(propertyName);
        }
        if (result == null && this.holderJoinColumnOverride != null) {
            result = this.holderJoinColumnOverride.get(propertyName);
        }
        return result;
    }

    @Override
    public AnnotationUsage<ForeignKey> getOverriddenForeignKey(String propertyName) {
        AnnotationUsage<ForeignKey> result = this.getExactOverriddenForeignKey(propertyName);
        if (result == null && propertyName.contains(".collection&&element.")) {
            return this.getExactOverriddenForeignKey(propertyName.replace(".collection&&element.", "."));
        }
        return result;
    }

    private AnnotationUsage<ForeignKey> getExactOverriddenForeignKey(String propertyName) {
        AnnotationUsage<ForeignKey> result = null;
        if (this.parent != null) {
            result = this.parent.getExactOverriddenForeignKey(propertyName);
        }
        if (result == null && this.currentPropertyForeignKeyOverride != null) {
            result = this.currentPropertyForeignKeyOverride.get(propertyName);
        }
        if (result == null && this.holderForeignKeyOverride != null) {
            result = this.holderForeignKeyOverride.get(propertyName);
        }
        return result;
    }

    @Override
    public AnnotationUsage<JoinTable> getJoinTable(MemberDetails attributeMember) {
        String propertyName = StringHelper.qualify(this.getPath(), attributeMember.getName());
        AnnotationUsage<JoinTable> result = this.getOverriddenJoinTable(propertyName);
        if (result == null) {
            return attributeMember.getAnnotationUsage(JoinTable.class);
        }
        return result;
    }

    public AnnotationUsage<JoinTable> getOverriddenJoinTable(String propertyName) {
        AnnotationUsage<JoinTable> result = this.getExactOverriddenJoinTable(propertyName);
        if (result == null && propertyName.contains(".collection&&element.")) {
            return this.getExactOverriddenJoinTable(propertyName.replace(".collection&&element.", "."));
        }
        return result;
    }

    private AnnotationUsage<JoinTable> getExactOverriddenJoinTable(String propertyName) {
        AnnotationUsage<JoinTable> override = null;
        if (this.parent != null) {
            override = this.parent.getExactOverriddenJoinTable(propertyName);
        }
        if (override == null && this.currentPropertyJoinTableOverride != null) {
            override = this.currentPropertyJoinTableOverride.get(propertyName);
        }
        if (override == null && this.holderJoinTableOverride != null) {
            override = this.holderJoinTableOverride.get(propertyName);
        }
        return override;
    }

    private void buildHierarchyColumnOverride(ClassDetails element) {
        Map<String, List<AnnotationUsage<Column>>> columnOverride = new HashMap<String, List<AnnotationUsage<Column>>>();
        Map<String, AnnotationUsage<ColumnTransformer>> columnTransformerOverride = new HashMap<String, AnnotationUsage<ColumnTransformer>>();
        Map<String, List<AnnotationUsage<JoinColumn>>> joinColumnOverride = new HashMap<String, List<AnnotationUsage<JoinColumn>>>();
        Map<String, AnnotationUsage<JoinTable>> joinTableOverride = new HashMap<String, AnnotationUsage<JoinTable>>();
        Map<String, AnnotationUsage<ForeignKey>> foreignKeyOverride = new HashMap<String, AnnotationUsage<ForeignKey>>();
        for (ClassDetails current = element; current != null && !ClassDetails.OBJECT_CLASS_DETAILS.equals(current); current = current.getSuperClass()) {
            if (!current.hasAnnotationUsage(Entity.class) && !current.hasAnnotationUsage(MappedSuperclass.class) && !current.hasAnnotationUsage(Embeddable.class)) continue;
            Map<String, List<AnnotationUsage<Column>>> currentOverride = AbstractPropertyHolder.buildColumnOverride((AnnotationTarget)current, this.getPath(), this.context);
            Map<String, AnnotationUsage<ColumnTransformer>> currentTransformerOverride = AbstractPropertyHolder.buildColumnTransformerOverride((AnnotationTarget)current);
            Map<String, List<AnnotationUsage<JoinColumn>>> currentJoinOverride = AbstractPropertyHolder.buildJoinColumnOverride((AnnotationTarget)current, this.getPath());
            Map<String, AnnotationUsage<JoinTable>> currentJoinTableOverride = AbstractPropertyHolder.buildJoinTableOverride((AnnotationTarget)current, this.getPath());
            Map<String, AnnotationUsage<ForeignKey>> currentForeignKeyOverride = AbstractPropertyHolder.buildForeignKeyOverride((AnnotationTarget)current, this.getPath());
            currentOverride.putAll(columnOverride);
            currentTransformerOverride.putAll(columnTransformerOverride);
            currentJoinOverride.putAll(joinColumnOverride);
            currentJoinTableOverride.putAll(joinTableOverride);
            currentForeignKeyOverride.putAll(foreignKeyOverride);
            columnOverride = currentOverride;
            columnTransformerOverride = currentTransformerOverride;
            joinColumnOverride = currentJoinOverride;
            joinTableOverride = currentJoinTableOverride;
            foreignKeyOverride = currentForeignKeyOverride;
        }
        this.holderColumnOverride = !columnOverride.isEmpty() ? columnOverride : null;
        this.holderColumnTransformerOverride = !columnTransformerOverride.isEmpty() ? columnTransformerOverride : null;
        this.holderJoinColumnOverride = !joinColumnOverride.isEmpty() ? joinColumnOverride : null;
        this.holderJoinTableOverride = !joinTableOverride.isEmpty() ? joinTableOverride : null;
        this.holderForeignKeyOverride = !foreignKeyOverride.isEmpty() ? foreignKeyOverride : null;
    }

    private static Map<String, List<AnnotationUsage<Column>>> buildColumnOverride(AnnotationTarget element, String path, MetadataBuildingContext context) {
        HashMap<String, List<AnnotationUsage<Column>>> columnOverrideMap = new HashMap<String, List<AnnotationUsage<Column>>>();
        if (element == null) {
            return columnOverrideMap;
        }
        List overrides = element.getRepeatedAnnotationUsages(AttributeOverride.class);
        if (CollectionHelper.isNotEmpty(overrides)) {
            for (AnnotationUsage depAttr : overrides) {
                String qualifiedName = StringHelper.qualify(path, depAttr.getString("name"));
                AnnotationUsage column = depAttr.getNestedUsage("column");
                if (columnOverrideMap.containsKey(qualifiedName)) {
                    ((List)columnOverrideMap.get(qualifiedName)).add(column);
                    continue;
                }
                ArrayList<AnnotationUsage> list = new ArrayList<AnnotationUsage>();
                list.add(column);
                columnOverrideMap.put(qualifiedName, list);
            }
        } else if (TimeZoneStorageHelper.useColumnForTimeZoneStorage(element, context)) {
            AnnotationUsage<Column> column = AbstractPropertyHolder.createTemporalColumn(element, path, context);
            if (TimeZoneStorageHelper.isOffsetTimeClass(element)) {
                columnOverrideMap.put(path + ".utcTime", List.of(column));
            } else {
                columnOverrideMap.put(path + ".instant", List.of(column));
            }
            AnnotationUsage<Column> offsetColumn = AbstractPropertyHolder.createTimeZoneColumn(element, column, context);
            columnOverrideMap.put(path + ".zoneOffset", List.of(offsetColumn));
        }
        return columnOverrideMap;
    }

    private static AnnotationUsage<Column> createTimeZoneColumn(AnnotationTarget element, AnnotationUsage<Column> column, MetadataBuildingContext context) {
        AnnotationUsage<Column> timeZoneColumn = element.getAnnotationUsage(TimeZoneColumn.class);
        MutableAnnotationUsage created = JpaAnnotations.COLUMN.createUsage(context.getMetadataCollector().getSourceModelBuildingContext());
        Object columnName = timeZoneColumn != null ? timeZoneColumn.getString("name") : column.getString("name") + "_tz";
        created.setAttributeValue("name", columnName);
        AnnotationUsageHelper.applyAttributeIfSpecified("nullable", column.getBoolean("nullable"), created);
        AnnotationUsage<Column> source = timeZoneColumn != null ? timeZoneColumn : column;
        AnnotationUsageHelper.applyAttributeIfSpecified("table", source.getString("table"), created);
        AnnotationUsageHelper.applyAttributeIfSpecified("insertable", source.getAttributeValue("insertable"), created);
        AnnotationUsageHelper.applyAttributeIfSpecified("updatable", source.getAttributeValue("updatable"), created);
        if (timeZoneColumn != null) {
            AnnotationUsageHelper.applyStringAttributeIfSpecified("columnDefinition", (String)timeZoneColumn.getAttributeValue("columnDefinition"), created);
        }
        return created;
    }

    private static AnnotationUsage<Column> createTemporalColumn(AnnotationTarget element, final String path, final MetadataBuildingContext context) {
        int secondPrecision;
        int precision;
        AnnotationUsage annotatedColumn = element.getAnnotationUsage(Column.class);
        if (annotatedColumn != null) {
            if (StringHelper.isNotEmpty(annotatedColumn.getString("name"))) {
                return annotatedColumn;
            }
            precision = annotatedColumn.getInteger("precision");
            secondPrecision = annotatedColumn.getInteger("secondPrecision");
        } else {
            precision = 0;
            secondPrecision = -1;
        }
        Identifier implicitName = context.getObjectNameNormalizer().normalizeIdentifierQuoting(context.getBuildingOptions().getImplicitNamingStrategy().determineBasicColumnName(new ImplicitBasicColumnNameSource(){
            final AttributePath attributePath;
            {
                this.attributePath = AttributePath.parse(path);
            }

            @Override
            public AttributePath getAttributePath() {
                return this.attributePath;
            }

            @Override
            public boolean isCollectionElement() {
                return false;
            }

            @Override
            public MetadataBuildingContext getBuildingContext() {
                return context;
            }
        }));
        MutableAnnotationUsage usage = JpaAnnotations.COLUMN.createUsage(context.getMetadataCollector().getSourceModelBuildingContext());
        AnnotationUsageHelper.applyStringAttributeIfSpecified("name", implicitName.getText(), usage);
        usage.setAttributeValue("precision", (Object)precision);
        usage.setAttributeValue("secondPrecision", (Object)secondPrecision);
        return usage;
    }

    private static Map<String, AnnotationUsage<ColumnTransformer>> buildColumnTransformerOverride(AnnotationTarget element) {
        HashMap<String, AnnotationUsage<ColumnTransformer>> columnOverride = new HashMap<String, AnnotationUsage<ColumnTransformer>>();
        if (element != null) {
            element.forEachAnnotationUsage(ColumnTransformer.class, usage -> columnOverride.put(usage.getString("forColumn"), (AnnotationUsage<ColumnTransformer>)usage));
        }
        return columnOverride;
    }

    private static Map<String, List<AnnotationUsage<JoinColumn>>> buildJoinColumnOverride(AnnotationTarget element, String path) {
        HashMap<String, List<AnnotationUsage<JoinColumn>>> columnOverride = new HashMap<String, List<AnnotationUsage<JoinColumn>>>();
        if (element != null) {
            List<AnnotationUsage<AssociationOverride>> overrides = AbstractPropertyHolder.buildAssociationOverrides(element, path);
            for (AnnotationUsage<AssociationOverride> override : overrides) {
                columnOverride.put(StringHelper.qualify(path, override.getString("name")), override.getList("joinColumns"));
            }
        }
        return columnOverride;
    }

    private static Map<String, AnnotationUsage<ForeignKey>> buildForeignKeyOverride(AnnotationTarget element, String path) {
        HashMap<String, AnnotationUsage<ForeignKey>> foreignKeyOverride = new HashMap<String, AnnotationUsage<ForeignKey>>();
        if (element != null) {
            List<AnnotationUsage<AssociationOverride>> overrides = AbstractPropertyHolder.buildAssociationOverrides(element, path);
            for (AnnotationUsage<AssociationOverride> override : overrides) {
                foreignKeyOverride.put(StringHelper.qualify(path, override.getString("name")), (AnnotationUsage<ForeignKey>)override.getNestedUsage("foreignKey"));
            }
        }
        return foreignKeyOverride;
    }

    private static List<AnnotationUsage<AssociationOverride>> buildAssociationOverrides(AnnotationTarget element, String path) {
        ArrayList<AnnotationUsage<AssociationOverride>> overrides = new ArrayList<AnnotationUsage<AssociationOverride>>();
        element.forEachAnnotationUsage(AssociationOverride.class, overrides::add);
        return overrides;
    }

    private static Map<String, AnnotationUsage<JoinTable>> buildJoinTableOverride(AnnotationTarget element, String path) {
        HashMap<String, AnnotationUsage<JoinTable>> result = new HashMap<String, AnnotationUsage<JoinTable>>();
        if (element != null) {
            List<AnnotationUsage<AssociationOverride>> overrides = AbstractPropertyHolder.buildAssociationOverrides(element, path);
            for (AnnotationUsage<AssociationOverride> override : overrides) {
                List joinColumns = override.getList("joinColumns");
                if (!CollectionHelper.isEmpty(joinColumns)) continue;
                result.put(StringHelper.qualify(path, override.getString("name")), (AnnotationUsage<JoinTable>)override.getNestedUsage("joinTable"));
            }
        }
        return result;
    }

    @Override
    public void setParentProperty(String parentProperty) {
        throw new AssertionFailure("Setting the parent property to a non component");
    }

    private static class ColumnImpl
    implements Column {
        private final String name;
        private final boolean unique;
        private final boolean nullable;
        private final boolean insertable;
        private final boolean updatable;
        private final String columnDefinition;
        private final String table;
        private final int precision;
        private final int secondPrecision;

        private ColumnImpl(String name, boolean unique, boolean nullable, boolean insertable, boolean updatable, String columnDefinition, String table, int precision, int secondPrecision) {
            this.name = name;
            this.unique = unique;
            this.nullable = nullable;
            this.insertable = insertable;
            this.updatable = updatable;
            this.columnDefinition = columnDefinition;
            this.table = table;
            this.precision = precision;
            this.secondPrecision = secondPrecision;
        }

        public String name() {
            return this.name;
        }

        public boolean unique() {
            return this.unique;
        }

        public boolean nullable() {
            return this.nullable;
        }

        public boolean insertable() {
            return this.insertable;
        }

        public boolean updatable() {
            return this.updatable;
        }

        public String columnDefinition() {
            return this.columnDefinition;
        }

        public String options() {
            return "";
        }

        public String table() {
            return this.table;
        }

        public int length() {
            return 255;
        }

        public int precision() {
            return this.precision;
        }

        public int scale() {
            return 0;
        }

        public int secondPrecision() {
            return this.secondPrecision;
        }

        public CheckConstraint[] check() {
            return new CheckConstraint[0];
        }

        public String comment() {
            return "";
        }

        public Class<? extends Annotation> annotationType() {
            return Column.class;
        }
    }
}

