/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.CollectionTypeRegistration;
import org.hibernate.annotations.CompositeTypeRegistration;
import org.hibernate.annotations.ConverterRegistration;
import org.hibernate.annotations.EmbeddableInstantiatorRegistration;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.FetchProfile;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Imported;
import org.hibernate.annotations.JavaTypeRegistration;
import org.hibernate.annotations.JdbcTypeRegistration;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.TypeRegistration;
import org.hibernate.boot.internal.GenerationStrategyInterpreter;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.convert.spi.RegisteredConversion;
import org.hibernate.boot.model.internal.AnnotatedClassType;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.FetchOverrideSecondPass;
import org.hibernate.boot.model.internal.FilterDefBinder;
import org.hibernate.boot.model.internal.GeneratorBinder;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.QueryBinder;
import org.hibernate.boot.models.categorize.spi.GlobalRegistrations;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.MetadataSource;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public final class AnnotationBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(AnnotationBinder.class);

    private AnnotationBinder() {
    }

    public static void bindDefaults(MetadataBuildingContext context) {
        GlobalRegistrations globalRegistrations = context.getMetadataCollector().getGlobalRegistrations();
        globalRegistrations.getSequenceGeneratorRegistrations().forEach((name, generatorRegistration) -> {
            IdentifierGeneratorDefinition.Builder definitionBuilder = new IdentifierGeneratorDefinition.Builder();
            GenerationStrategyInterpreter.STRATEGY_INTERPRETER.interpretSequenceGenerator(generatorRegistration.configuration(), definitionBuilder);
            IdentifierGeneratorDefinition idGenDef = definitionBuilder.build();
            if (LOG.isTraceEnabled()) {
                LOG.tracef("Adding global sequence generator with name: %s", name);
            }
            context.getMetadataCollector().addDefaultIdentifierGenerator(idGenDef);
        });
        globalRegistrations.getTableGeneratorRegistrations().forEach((name, generatorRegistration) -> {
            IdentifierGeneratorDefinition.Builder definitionBuilder = new IdentifierGeneratorDefinition.Builder();
            GenerationStrategyInterpreter.STRATEGY_INTERPRETER.interpretTableGenerator(generatorRegistration.configuration(), definitionBuilder);
            IdentifierGeneratorDefinition idGenDef = definitionBuilder.build();
            if (LOG.isTraceEnabled()) {
                LOG.tracef("Adding global table generator with name: %s", name);
            }
            context.getMetadataCollector().addDefaultIdentifierGenerator(idGenDef);
        });
        globalRegistrations.getSqlResultSetMappingRegistrations().forEach((name, mappingRegistration) -> QueryBinder.bindSqlResultSetMapping(mappingRegistration.configuration(), context, true));
        globalRegistrations.getNamedQueryRegistrations().forEach((name, queryRegistration) -> QueryBinder.bindQuery(queryRegistration.configuration(), context, true));
        globalRegistrations.getNamedNativeQueryRegistrations().forEach((name, queryRegistration) -> QueryBinder.bindNativeQuery(queryRegistration.configuration(), context, true));
        globalRegistrations.getNamedStoredProcedureQueryRegistrations().forEach((name, queryRegistration) -> QueryBinder.bindNamedStoredProcedureQuery(queryRegistration.configuration(), context, true));
    }

    public static void bindPackage(ClassLoaderService cls, String packageName, MetadataBuildingContext context) {
        Package pack = cls.packageForNameOrNull(packageName);
        if (pack == null) {
            return;
        }
        ClassDetails packageInfoClassDetails = context.getMetadataCollector().getSourceModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(pack.getName() + ".package-info");
        AnnotationBinder.handleIdGenerators(packageInfoClassDetails, context);
        AnnotationBinder.bindTypeDescriptorRegistrations((AnnotationTarget)packageInfoClassDetails, context);
        AnnotationBinder.bindEmbeddableInstantiatorRegistrations((AnnotationTarget)packageInfoClassDetails, context);
        AnnotationBinder.bindUserTypeRegistrations((AnnotationTarget)packageInfoClassDetails, context);
        AnnotationBinder.bindCompositeUserTypeRegistrations((AnnotationTarget)packageInfoClassDetails, context);
        AnnotationBinder.bindConverterRegistrations((AnnotationTarget)packageInfoClassDetails, context);
        AnnotationBinder.bindGenericGenerators((AnnotationTarget)packageInfoClassDetails, context);
        AnnotationBinder.bindQueries((AnnotationTarget)packageInfoClassDetails, context);
        FilterDefBinder.bindFilterDefs((AnnotationTarget)packageInfoClassDetails, context);
    }

    private static void handleIdGenerators(ClassDetails packageInfoClassDetails, MetadataBuildingContext context) {
        packageInfoClassDetails.forEachAnnotationUsage(SequenceGenerator.class, usage -> {
            IdentifierGeneratorDefinition idGen = GeneratorBinder.buildIdGenerator(usage, context);
            context.getMetadataCollector().addIdentifierGenerator(idGen);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add sequence generator with name: {0}", idGen.getName());
            }
        });
        packageInfoClassDetails.forEachAnnotationUsage(TableGenerator.class, usage -> {
            IdentifierGeneratorDefinition idGen = GeneratorBinder.buildIdGenerator(usage, context);
            context.getMetadataCollector().addIdentifierGenerator(idGen);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add table generator with name: {0}", idGen.getName());
            }
        });
    }

    private static void bindGenericGenerators(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        annotatedElement.forEachAnnotationUsage(GenericGenerator.class, usage -> AnnotationBinder.bindGenericGenerator((AnnotationUsage<GenericGenerator>)usage, context));
    }

    private static void bindGenericGenerator(AnnotationUsage<GenericGenerator> def, MetadataBuildingContext context) {
        context.getMetadataCollector().addIdentifierGenerator(GeneratorBinder.buildIdGenerator(def, context));
    }

    public static void bindQueries(AnnotationTarget annotationTarget, MetadataBuildingContext context) {
        AnnotationBinder.bindNamedJpaQueries(annotationTarget, context);
        AnnotationBinder.bindNamedHibernateQueries(annotationTarget, context);
    }

    private static void bindNamedHibernateQueries(AnnotationTarget annotationTarget, MetadataBuildingContext context) {
        annotationTarget.forEachAnnotationUsage(org.hibernate.annotations.NamedQuery.class, usage -> QueryBinder.bindQuery((AnnotationUsage<org.hibernate.annotations.NamedQuery>)usage, context));
        annotationTarget.forEachAnnotationUsage(NamedNativeQuery.class, usage -> QueryBinder.bindNativeQuery((AnnotationUsage<NamedNativeQuery>)usage, context));
    }

    private static void bindNamedJpaQueries(AnnotationTarget annotationTarget, MetadataBuildingContext context) {
        annotationTarget.forEachAnnotationUsage(SqlResultSetMapping.class, usage -> QueryBinder.bindSqlResultSetMapping((AnnotationUsage<SqlResultSetMapping>)usage, context, false));
        annotationTarget.forEachAnnotationUsage(NamedQuery.class, usage -> QueryBinder.bindQuery((AnnotationUsage<NamedQuery>)usage, context, false));
        annotationTarget.forEachAnnotationUsage(jakarta.persistence.NamedNativeQuery.class, usage -> QueryBinder.bindNativeQuery((AnnotationUsage<jakarta.persistence.NamedNativeQuery>)usage, context, false));
        annotationTarget.forEachAnnotationUsage(NamedStoredProcedureQuery.class, usage -> QueryBinder.bindNamedStoredProcedureQuery((AnnotationUsage<NamedStoredProcedureQuery>)usage, context, false));
    }

    public static void bindClass(ClassDetails classDetails, Map<ClassDetails, InheritanceState> inheritanceStatePerClass, MetadataBuildingContext context) throws MappingException {
        AnnotationBinder.detectMappedSuperclassProblems(classDetails);
        AnnotationBinder.bindQueries((AnnotationTarget)classDetails, context);
        AnnotationBinder.handleImport(classDetails, context);
        AnnotationBinder.bindTypeDescriptorRegistrations((AnnotationTarget)classDetails, context);
        AnnotationBinder.bindEmbeddableInstantiatorRegistrations((AnnotationTarget)classDetails, context);
        AnnotationBinder.bindUserTypeRegistrations((AnnotationTarget)classDetails, context);
        AnnotationBinder.bindCompositeUserTypeRegistrations((AnnotationTarget)classDetails, context);
        AnnotationBinder.bindConverterRegistrations((AnnotationTarget)classDetails, context);
        Map<String, IdentifierGeneratorDefinition> generators = GeneratorBinder.buildGenerators((AnnotationTarget)classDetails, context);
        if (context.getMetadataCollector().getClassType(classDetails) == AnnotatedClassType.ENTITY) {
            EntityBinder.bindEntityClass(classDetails, inheritanceStatePerClass, generators, context);
        }
    }

    private static void handleImport(ClassDetails annotatedClass, MetadataBuildingContext context) {
        if (annotatedClass.hasAnnotationUsage(Imported.class)) {
            String qualifiedName = annotatedClass.getName();
            String name = StringHelper.unqualify(qualifiedName);
            String rename = annotatedClass.getAnnotationUsage(Imported.class).getString("rename");
            context.getMetadataCollector().addImport(rename.isEmpty() ? name : rename, qualifiedName);
        }
    }

    private static void detectMappedSuperclassProblems(ClassDetails annotatedClass) {
        if (annotatedClass.hasAnnotationUsage(MappedSuperclass.class)) {
            if (annotatedClass.hasAnnotationUsage(Entity.class)) {
                throw new AnnotationException("Type '" + annotatedClass.getName() + "' is annotated both '@Entity' and '@MappedSuperclass'");
            }
            if (annotatedClass.hasAnnotationUsage(Table.class)) {
                throw new AnnotationException("Mapped superclass '" + annotatedClass.getName() + "' may not specify a '@Table'");
            }
            if (annotatedClass.hasAnnotationUsage(Inheritance.class)) {
                throw new AnnotationException("Mapped superclass '" + annotatedClass.getName() + "' may not specify an '@Inheritance' mapping strategy");
            }
        }
    }

    private static void bindTypeDescriptorRegistrations(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        ManagedBeanRegistry managedBeanRegistry = context.getBootstrapContext().getServiceRegistry().getService(ManagedBeanRegistry.class);
        annotatedElement.forEachAnnotationUsage(JavaTypeRegistration.class, usage -> AnnotationBinder.handleJavaTypeRegistration(context, managedBeanRegistry, (AnnotationUsage<JavaTypeRegistration>)usage));
        annotatedElement.forEachAnnotationUsage(JdbcTypeRegistration.class, usage -> AnnotationBinder.handleJdbcTypeRegistration(context, managedBeanRegistry, (AnnotationUsage<JdbcTypeRegistration>)usage));
        annotatedElement.forEachAnnotationUsage(CollectionTypeRegistration.class, usage -> context.getMetadataCollector().addCollectionTypeRegistration((AnnotationUsage<CollectionTypeRegistration>)usage));
    }

    private static void handleJdbcTypeRegistration(MetadataBuildingContext context, ManagedBeanRegistry managedBeanRegistry, AnnotationUsage<JdbcTypeRegistration> annotation) {
        Class jdbcTypeClass = annotation.getClassDetails("value").toJavaClass();
        JdbcType jdbcType = !context.getBuildingOptions().isAllowExtensionsInCdi() ? (JdbcType)FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(jdbcTypeClass) : (JdbcType)managedBeanRegistry.getBean(jdbcTypeClass).getBeanInstance();
        Integer registrationCode = annotation.getInteger("registrationCode");
        int typeCode = registrationCode == Integer.MIN_VALUE ? jdbcType.getDefaultSqlTypeCode() : registrationCode.intValue();
        context.getMetadataCollector().addJdbcTypeRegistration(typeCode, jdbcType);
    }

    private static void handleJavaTypeRegistration(MetadataBuildingContext context, ManagedBeanRegistry managedBeanRegistry, AnnotationUsage<JavaTypeRegistration> annotation) {
        Class javaTypeClass = annotation.getClassDetails("descriptorClass").toJavaClass();
        BasicJavaType javaType = !context.getBuildingOptions().isAllowExtensionsInCdi() ? (BasicJavaType)FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(javaTypeClass) : (BasicJavaType)managedBeanRegistry.getBean(javaTypeClass).getBeanInstance();
        context.getMetadataCollector().addJavaTypeRegistration(annotation.getClassDetails("javaType").toJavaClass(), javaType);
    }

    private static void bindEmbeddableInstantiatorRegistrations(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        annotatedElement.forEachAnnotationUsage(EmbeddableInstantiatorRegistration.class, usage -> AnnotationBinder.handleEmbeddableInstantiatorRegistration(context, (AnnotationUsage<EmbeddableInstantiatorRegistration>)usage));
    }

    private static void handleEmbeddableInstantiatorRegistration(MetadataBuildingContext context, AnnotationUsage<EmbeddableInstantiatorRegistration> annotation) {
        context.getMetadataCollector().registerEmbeddableInstantiator(annotation.getClassDetails("embeddableClass").toJavaClass(), annotation.getClassDetails("instantiator").toJavaClass());
    }

    private static void bindCompositeUserTypeRegistrations(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        annotatedElement.forEachAnnotationUsage(CompositeTypeRegistration.class, usage -> AnnotationBinder.handleCompositeUserTypeRegistration(context, (AnnotationUsage<CompositeTypeRegistration>)usage));
    }

    private static void bindUserTypeRegistrations(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        annotatedElement.forEachAnnotationUsage(TypeRegistration.class, usage -> AnnotationBinder.handleUserTypeRegistration(context, (AnnotationUsage<TypeRegistration>)usage));
    }

    private static void handleUserTypeRegistration(MetadataBuildingContext context, AnnotationUsage<TypeRegistration> compositeTypeRegistration) {
        context.getMetadataCollector().registerUserType(compositeTypeRegistration.getClassDetails("basicClass").toJavaClass(), compositeTypeRegistration.getClassDetails("userType").toJavaClass());
    }

    private static void handleCompositeUserTypeRegistration(MetadataBuildingContext context, AnnotationUsage<CompositeTypeRegistration> compositeTypeRegistration) {
        context.getMetadataCollector().registerCompositeUserType(compositeTypeRegistration.getClassDetails("embeddableClass").toJavaClass(), compositeTypeRegistration.getClassDetails("userType").toJavaClass());
    }

    private static void bindConverterRegistrations(AnnotationTarget container, MetadataBuildingContext context) {
        container.forEachAnnotationUsage(ConverterRegistration.class, usage -> AnnotationBinder.handleConverterRegistration((AnnotationUsage<ConverterRegistration>)usage, context));
    }

    private static void handleConverterRegistration(AnnotationUsage<ConverterRegistration> registration, MetadataBuildingContext context) {
        context.getMetadataCollector().getConverterRegistry().addRegisteredConversion(new RegisteredConversion(registration.getClassDetails("domainType").toJavaClass(), registration.getClassDetails("converter").toJavaClass(), registration.getBoolean("autoApply"), context));
    }

    public static void bindFetchProfilesForClass(AnnotationTarget annotatedClass, MetadataBuildingContext context) {
        AnnotationBinder.bindFetchProfiles(annotatedClass, context);
    }

    public static void bindFetchProfilesForPackage(ClassLoaderService cls, String packageName, MetadataBuildingContext context) {
        ClassDetails packageInfoClassDetails = context.getMetadataCollector().getClassDetailsRegistry().findClassDetails(packageName + ".package-info");
        if (packageInfoClassDetails != null) {
            AnnotationBinder.bindFetchProfiles((AnnotationTarget)packageInfoClassDetails, context);
        }
    }

    private static void bindFetchProfiles(AnnotationTarget annotatedElement, MetadataBuildingContext context) {
        annotatedElement.forEachAnnotationUsage(FetchProfile.class, usage -> AnnotationBinder.bindFetchProfile((AnnotationUsage<FetchProfile>)usage, context));
    }

    private static void bindFetchProfile(AnnotationUsage<FetchProfile> fetchProfile, MetadataBuildingContext context) {
        String name = fetchProfile.getString("name");
        if (AnnotationBinder.reuseOrCreateFetchProfile(context, name)) {
            List fetchOverrides = fetchProfile.getList("fetchOverrides");
            for (AnnotationUsage fetchOverride : fetchOverrides) {
                FetchType type = (FetchType)fetchOverride.getEnum("fetch");
                FetchMode mode = (FetchMode)fetchOverride.getEnum("mode");
                if (type == FetchType.LAZY && mode == FetchMode.JOIN) {
                    throw new AnnotationException("Fetch profile '" + name + "' has a '@FetchOverride' with 'fetch=LAZY' and 'mode=JOIN' (join fetching is eager by nature)");
                }
                context.getMetadataCollector().addSecondPass(new FetchOverrideSecondPass(name, (AnnotationUsage<FetchProfile.FetchOverride>)fetchOverride, context));
            }
        }
    }

    private static boolean reuseOrCreateFetchProfile(MetadataBuildingContext context, String name) {
        org.hibernate.mapping.FetchProfile existing = context.getMetadataCollector().getFetchProfile(name);
        if (existing == null) {
            org.hibernate.mapping.FetchProfile profile = new org.hibernate.mapping.FetchProfile(name, MetadataSource.ANNOTATIONS);
            context.getMetadataCollector().addFetchProfile(profile);
            return true;
        }
        return existing.getSource() == MetadataSource.ANNOTATIONS;
    }

    public static Map<ClassDetails, InheritanceState> buildInheritanceStates(List<ClassDetails> orderedClasses, MetadataBuildingContext buildingContext) {
        HashMap<ClassDetails, InheritanceState> inheritanceStatePerClass = new HashMap<ClassDetails, InheritanceState>(orderedClasses.size());
        for (ClassDetails clazz : orderedClasses) {
            InheritanceState superclassState = InheritanceState.getSuperclassInheritanceState(clazz, inheritanceStatePerClass);
            InheritanceState state = new InheritanceState(clazz, inheritanceStatePerClass, buildingContext);
            if (superclassState != null) {
                superclassState.setHasSiblings(true);
                InheritanceState superEntityState = InheritanceState.getInheritanceStateOfSuperEntity(clazz, inheritanceStatePerClass);
                state.setHasParents(superEntityState != null);
                AnnotationBinder.logMixedInheritance(clazz, superclassState, state);
                if (superclassState.getType() != null) {
                    state.setType(superclassState.getType());
                }
            }
            switch (buildingContext.getMetadataCollector().getClassType(clazz)) {
                case ENTITY: 
                case MAPPED_SUPERCLASS: 
                case EMBEDDABLE: {
                    inheritanceStatePerClass.put(clazz, state);
                }
            }
        }
        return inheritanceStatePerClass;
    }

    private static void logMixedInheritance(ClassDetails classDetails, InheritanceState superclassState, InheritanceState state) {
        if (state.getType() != null && superclassState.getType() != null) {
            boolean mixingStrategy;
            boolean nonDefault = InheritanceType.SINGLE_TABLE != state.getType();
            boolean bl = mixingStrategy = state.getType() != superclassState.getType();
            if (nonDefault && mixingStrategy) {
                throw new AnnotationException("Entity '" + classDetails.getName() + "' may not override the inheritance mapping strategy '" + superclassState.getType() + "' of its hierarchy' (each entity hierarchy has a single inheritance mapping strategy)");
            }
        }
    }
}

