/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Convert;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;

public class AttributeConversionInfo {
    private final Class<? extends AttributeConverter<?, ?>> converterClass;
    private final boolean conversionDisabled;
    private final String attributeName;
    private final AnnotationTarget source;

    public AttributeConversionInfo(Class<? extends AttributeConverter> converterClass, boolean conversionDisabled, String attributeName, AnnotationTarget source) {
        this.converterClass = converterClass;
        this.conversionDisabled = conversionDisabled;
        this.attributeName = attributeName;
        this.source = source;
    }

    public AttributeConversionInfo(AnnotationUsage<Convert> convertAnnotation, AnnotationTarget source) {
        this(convertAnnotation.getClassDetails("converter").toJavaClass(), convertAnnotation.getBoolean("disableConversion"), convertAnnotation.getString("attributeName"), source);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Class<? extends AttributeConverter<?, ?>> getConverterClass() {
        return this.converterClass;
    }

    public boolean isConversionDisabled() {
        return this.conversionDisabled;
    }

    public AnnotationTarget getSource() {
        return this.source;
    }
}

