/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.FetchType;
import java.util.Map;
import org.hibernate.MappingException;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.FetchProfile;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;

public class FetchOverrideSecondPass
implements SecondPass {
    private final String fetchProfileName;
    private final AnnotationUsage<FetchProfile.FetchOverride> fetch;
    private final MetadataBuildingContext buildingContext;

    public FetchOverrideSecondPass(String fetchProfileName, AnnotationUsage<FetchProfile.FetchOverride> fetch, MetadataBuildingContext buildingContext) {
        this.fetchProfileName = fetchProfileName;
        this.fetch = fetch;
        this.buildingContext = buildingContext;
    }

    @Override
    public void doSecondPass(Map<String, PersistentClass> persistentClasses) throws MappingException {
        ClassDetails entityClassDetails = this.fetch.getClassDetails("entity");
        String attributeName = this.fetch.getString("association");
        this.buildingContext.getMetadataCollector().getEntityBinding(entityClassDetails.getName()).getProperty(attributeName);
        FetchProfile profile = this.buildingContext.getMetadataCollector().getFetchProfile(this.fetchProfileName);
        profile.addFetch(new FetchProfile.Fetch(entityClassDetails.getName(), attributeName, (FetchMode)this.fetch.getEnum("mode"), (FetchType)this.fetch.getEnum("fetch")));
    }
}

