/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.SqlResultSetMapping;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.annotations.CacheModeType;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.HQLSelect;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.SQLSelect;
import org.hibernate.boot.internal.NamedHqlQueryDefinitionImpl;
import org.hibernate.boot.internal.NamedProcedureCallDefinitionImpl;
import org.hibernate.boot.model.internal.QueryHintDefinition;
import org.hibernate.boot.model.internal.ResultSetMappingSecondPass;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedProcedureCallDefinition;
import org.hibernate.boot.query.SqlResultSetMappingDescriptor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.internal.util.StringHelper;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.query.sql.internal.ParameterParser;
import org.hibernate.query.sql.spi.ParameterRecognizer;
import org.hibernate.type.BasicType;
import org.jboss.logging.Logger;

public abstract class QueryBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)QueryBinder.class.getName());

    public static void bindQuery(AnnotationUsage<NamedQuery> namedQuery, MetadataBuildingContext context, boolean isDefault) {
        if (namedQuery == null) {
            return;
        }
        String queryName = namedQuery.getString("name");
        String queryString = namedQuery.getString("query");
        if (queryName.isEmpty()) {
            throw new AnnotationException("Class or package level '@NamedQuery' annotation must specify a 'name'");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named query: %s => %s", queryName, queryString);
        }
        QueryHintDefinition hints = new QueryHintDefinition(queryName, namedQuery.getList("hints"));
        NamedHqlQueryDefinitionImpl queryMapping = ((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(queryName).setHqlString(queryString).setResultClass(QueryBinder.loadClass(namedQuery.getClassDetails("resultClass"), context))).setCacheable(hints.getCacheability())).setCacheMode(hints.getCacheMode())).setCacheRegion(hints.getString("org.hibernate.cacheRegion"))).setTimeout(hints.getTimeout())).setFetchSize(hints.getInteger("org.hibernate.fetchSize"))).setFlushMode(hints.getFlushMode())).setReadOnly(hints.getBooleanWrapper("org.hibernate.readOnly"))).setLockOptions(hints.determineLockOptions(namedQuery))).setComment(hints.getString("org.hibernate.comment"))).build();
        if (isDefault) {
            context.getMetadataCollector().addDefaultQuery(queryMapping);
        } else {
            context.getMetadataCollector().addNamedQuery(queryMapping);
        }
    }

    private static Class<Object> loadClass(ClassDetails classDetails, MetadataBuildingContext context) {
        return ClassDetails.VOID_CLASS_DETAILS == classDetails ? null : context.getBootstrapContext().getServiceRegistry().requireService(ClassLoaderService.class).classForName(classDetails.getName());
    }

    public static void bindNativeQuery(AnnotationUsage<jakarta.persistence.NamedNativeQuery> namedNativeQuery, MetadataBuildingContext context, boolean isDefault) {
        if (namedNativeQuery == null) {
            return;
        }
        String registrationName = namedNativeQuery.getString("name");
        String queryString = namedNativeQuery.getString("query");
        if (registrationName.isEmpty()) {
            throw new AnnotationException("Class or package level '@NamedNativeQuery' annotation must specify a 'name'");
        }
        QueryHintDefinition hints = new QueryHintDefinition(registrationName, namedNativeQuery.getList("hints"));
        String resultSetMappingName = namedNativeQuery.getString("resultSetMapping");
        ClassDetails resultClassDetails = namedNativeQuery.getClassDetails("resultClass");
        Class resultClass = ClassDetails.VOID_CLASS_DETAILS == resultClassDetails ? null : context.getBootstrapContext().getServiceRegistry().requireService(ClassLoaderService.class).classForName(resultClassDetails.getClassName());
        NamedNativeQueryDefinition.Builder builder = (NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)new NamedNativeQueryDefinition.Builder(registrationName).setSqlString(queryString).setResultClass(resultClass)).setResultSetMappingName(resultSetMappingName).setQuerySpaces(null).setCacheable(hints.getCacheability())).setCacheMode(hints.getCacheMode())).setCacheRegion(hints.getString("org.hibernate.cacheRegion"))).setTimeout(hints.getTimeout())).setFetchSize(hints.getInteger("org.hibernate.fetchSize"))).setFlushMode(hints.getFlushMode())).setReadOnly(hints.getBooleanWrapper("org.hibernate.readOnly"))).setComment(hints.getString("org.hibernate.comment"))).addHints(hints.getHintsMap());
        NamedNativeQueryDefinition queryDefinition = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named native query: %s => %s", queryDefinition.getRegistrationName(), queryDefinition.getSqlQueryString());
        }
        if (isDefault) {
            context.getMetadataCollector().addDefaultNamedNativeQuery(queryDefinition);
        } else {
            context.getMetadataCollector().addNamedNativeQuery(queryDefinition);
        }
    }

    public static void bindNativeQuery(String name, AnnotationUsage<SQLSelect> sqlSelect, ClassDetails annotatedClass, MetadataBuildingContext context) {
        AnnotationUsage resultSetMapping;
        NamedNativeQueryDefinition.Builder builder = ((NamedNativeQueryDefinition.Builder)new NamedNativeQueryDefinition.Builder(name).setFlushMode(FlushMode.MANUAL)).setSqlString(sqlSelect.getString("sql")).setQuerySpaces(CollectionHelper.setOf(sqlSelect.getList("querySpaces")));
        if (annotatedClass != null) {
            builder.setResultClass(context.getBootstrapContext().getServiceRegistry().requireService(ClassLoaderService.class).classForName(annotatedClass.getClassName()));
        }
        if (!((resultSetMapping = sqlSelect.getNestedUsage("resultSetMapping")).getList("columns").isEmpty() && resultSetMapping.getList("entities").isEmpty() && resultSetMapping.getList("classes").isEmpty())) {
            context.getMetadataCollector().addResultSetMapping(SqlResultSetMappingDescriptor.from((AnnotationUsage<SqlResultSetMapping>)resultSetMapping, name));
            builder.setResultSetMappingName(name);
        }
        context.getMetadataCollector().addNamedNativeQuery(builder.build());
    }

    public static void bindNativeQuery(AnnotationUsage<NamedNativeQuery> namedNativeQuery, MetadataBuildingContext context) {
        if (namedNativeQuery == null) {
            return;
        }
        String registrationName = namedNativeQuery.getString("name");
        if (registrationName.isEmpty()) {
            throw new AnnotationException("Class or package level '@NamedNativeQuery' annotation must specify a 'name'");
        }
        String resultSetMappingName = namedNativeQuery.getString("resultSetMapping");
        ClassDetails resultClassDetails = namedNativeQuery.getClassDetails("resultClass");
        Class resultClass = ClassDetails.VOID_CLASS_DETAILS == resultClassDetails ? null : context.getBootstrapContext().getServiceRegistry().requireService(ClassLoaderService.class).classForName(resultClassDetails.getClassName());
        Integer timeout = namedNativeQuery.getInteger("timeout");
        Integer fetchSize = namedNativeQuery.getInteger("fetchSize");
        List querySpacesList = namedNativeQuery.getList("querySpaces");
        HashSet<String> querySpaces = new HashSet<String>(CollectionHelper.determineProperSizing(querySpacesList.size()));
        querySpaces.addAll(querySpacesList);
        NamedNativeQueryDefinition.Builder builder = (NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)((NamedNativeQueryDefinition.Builder)new NamedNativeQueryDefinition.Builder(registrationName).setSqlString(namedNativeQuery.getString("query")).setResultSetMappingName(resultSetMappingName).setResultClass(resultClass)).setCacheable(namedNativeQuery.getBoolean("cacheable"))).setCacheRegion(org.hibernate.internal.util.StringHelper.nullIfEmpty(namedNativeQuery.getString("cacheRegion")))).setCacheMode(QueryBinder.getCacheMode(namedNativeQuery))).setTimeout(timeout < 0 ? null : timeout)).setFetchSize(fetchSize < 0 ? null : fetchSize)).setFlushMode(QueryBinder.getFlushMode((FlushModeType)namedNativeQuery.getEnum("flushMode")))).setReadOnly(namedNativeQuery.getBoolean("readOnly"))).setQuerySpaces(querySpaces).setComment(org.hibernate.internal.util.StringHelper.nullIfEmpty(namedNativeQuery.getString("comment")));
        if (Boolean.TRUE == namedNativeQuery.getBoolean("callable")) {
            NamedProcedureCallDefinition definition = QueryBinder.createStoredProcedure(builder, context, () -> QueryBinder.illegalCallSyntax(namedNativeQuery));
            context.getMetadataCollector().addNamedProcedureCallDefinition(definition);
            DeprecationLogger.DEPRECATION_LOGGER.warn("Marking named native queries as callable is no longer supported; use '@jakarta.persistence.NamedStoredProcedureQuery' instead. Ignoring.");
        } else {
            NamedNativeQueryDefinition queryDefinition = builder.build();
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Binding named native query: %s => %s", queryDefinition.getRegistrationName(), queryDefinition.getSqlQueryString());
            }
            context.getMetadataCollector().addNamedNativeQuery(queryDefinition);
        }
    }

    public static NamedProcedureCallDefinition createStoredProcedure(NamedNativeQueryDefinition.Builder<?> builder, MetadataBuildingContext context, Supplier<RuntimeException> exceptionProducer) {
        MutableAnnotationUsage queryHintAnn;
        Class resultClass;
        String sqlString = builder.getSqlString().trim();
        if (!sqlString.startsWith("{") || !sqlString.endsWith("}")) {
            throw exceptionProducer.get();
        }
        JdbcCall jdbcCall = QueryBinder.parseJdbcCall(sqlString, exceptionProducer);
        SourceModelBuildingContext sourceModelBuildingContext = context.getMetadataCollector().getSourceModelBuildingContext();
        MutableAnnotationUsage nameStoredProcedureQueryAnn = JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY.createUsage(sourceModelBuildingContext);
        nameStoredProcedureQueryAnn.setAttributeValue("name", (Object)builder.getName());
        nameStoredProcedureQueryAnn.setAttributeValue("procedureName", (Object)jdbcCall.callableName);
        ArrayList<MutableAnnotationUsage> storedProcedureParameters = new ArrayList<MutableAnnotationUsage>();
        for (String parameterName : jdbcCall.parameters) {
            ClassDetails classDetails;
            MutableAnnotationUsage storedProcedureParameterAnn = JpaAnnotations.STORED_PROCEDURE_PARAMETER.createUsage(sourceModelBuildingContext);
            storedProcedureParameterAnn.setAttributeValue("name", (Object)parameterName);
            storedProcedureParameterAnn.setAttributeValue("mode", (Object)ParameterMode.IN);
            String typeName = builder.getParameterTypes().get(parameterName);
            if (StringHelper.isEmpty((String)typeName)) {
                classDetails = ClassDetails.VOID_CLASS_DETAILS;
            } else {
                BasicType registeredType = context.getBootstrapContext().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(typeName);
                classDetails = storedProcedureParameterAnn.getClassDetails(registeredType.getJavaType().getName());
            }
            storedProcedureParameterAnn.setAttributeValue("type", (Object)classDetails);
            storedProcedureParameters.add(storedProcedureParameterAnn);
        }
        nameStoredProcedureQueryAnn.setAttributeValue("parameters", storedProcedureParameters);
        if (builder.getResultSetMappingName() != null) {
            ArrayList<String> resultSetMappings = new ArrayList<String>(1);
            resultSetMappings.add(builder.getResultSetMappingName());
            nameStoredProcedureQueryAnn.setAttributeValue("resultSetMappings", resultSetMappings);
        }
        if ((resultClass = builder.getResultClass()) != null) {
            ArrayList<ClassDetails> resultClasses = new ArrayList<ClassDetails>(1);
            ClassDetails classDetails = nameStoredProcedureQueryAnn.getClassDetails(resultClass.getName());
            resultClasses.add(classDetails);
            nameStoredProcedureQueryAnn.setAttributeValue("resultClasses", resultClasses);
        }
        ArrayList<MutableAnnotationUsage> queryHints = new ArrayList<MutableAnnotationUsage>();
        if (builder.getQuerySpaces() != null) {
            queryHintAnn = JpaAnnotations.QUERY_HINT.createUsage(sourceModelBuildingContext);
            queryHintAnn.setAttributeValue("name", (Object)"org.hibernate.query.native.spaces");
            queryHintAnn.setAttributeValue("value", (Object)String.join((CharSequence)" ", builder.getQuerySpaces()));
            queryHints.add(queryHintAnn);
        }
        if (jdbcCall.resultParameter) {
            queryHintAnn = JpaAnnotations.QUERY_HINT.createUsage(sourceModelBuildingContext);
            queryHintAnn.setAttributeValue("name", (Object)"org.hibernate.callableFunction");
            queryHintAnn.setAttributeValue("value", (Object)"true");
            queryHints.add(queryHintAnn);
        }
        nameStoredProcedureQueryAnn.setAttributeValue("hints", queryHints);
        return new NamedProcedureCallDefinitionImpl((AnnotationUsage<NamedStoredProcedureQuery>)nameStoredProcedureQueryAnn);
    }

    public static void bindQuery(String name, AnnotationUsage<HQLSelect> hqlSelect, MetadataBuildingContext context) {
        NamedHqlQueryDefinitionImpl hqlQueryDefinition = ((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(name).setFlushMode(FlushMode.MANUAL)).setHqlString(hqlSelect.getString("query")).build();
        context.getMetadataCollector().addNamedQuery(hqlQueryDefinition);
    }

    public static void bindQuery(AnnotationUsage<org.hibernate.annotations.NamedQuery> namedQuery, MetadataBuildingContext context) {
        if (namedQuery == null) {
            return;
        }
        String registrationName = namedQuery.getString("name");
        if (registrationName.isEmpty()) {
            throw new AnnotationException("Class or package level '@NamedQuery' annotation must specify a 'name'");
        }
        Integer timeout = namedQuery.getInteger("timeout");
        Integer fetchSize = namedQuery.getInteger("fetchSize");
        NamedHqlQueryDefinition.Builder builder = (NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(registrationName).setHqlString(namedQuery.getString("query")).setResultClass(QueryBinder.loadClass(namedQuery.getClassDetails("resultClass"), context))).setCacheable(namedQuery.getBoolean("cacheable"))).setCacheRegion(org.hibernate.internal.util.StringHelper.nullIfEmpty(namedQuery.getString("cacheRegion")))).setCacheMode(QueryBinder.getCacheMode(namedQuery))).setTimeout(timeout < 0 ? null : timeout)).setFetchSize(fetchSize < 0 ? null : fetchSize)).setFlushMode(QueryBinder.getFlushMode((FlushModeType)namedQuery.getEnum("flushMode")))).setReadOnly(namedQuery.getBoolean("readOnly"))).setComment(org.hibernate.internal.util.StringHelper.nullIfEmpty(namedQuery.getString("comment")));
        NamedHqlQueryDefinitionImpl hqlQueryDefinition = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named query: %s => %s", hqlQueryDefinition.getRegistrationName(), hqlQueryDefinition.getHqlString());
        }
        context.getMetadataCollector().addNamedQuery(hqlQueryDefinition);
    }

    private static CacheMode getCacheMode(AnnotationUsage<?> namedQuery) {
        CacheMode cacheMode = CacheMode.fromJpaModes((CacheRetrieveMode)namedQuery.getEnum("cacheRetrieveMode"), (CacheStoreMode)namedQuery.getEnum("cacheStoreMode"));
        return cacheMode == null || cacheMode == CacheMode.NORMAL ? QueryBinder.interpretCacheMode((CacheModeType)namedQuery.getEnum("cacheMode")) : cacheMode;
    }

    private static FlushMode getFlushMode(FlushModeType flushModeType) {
        switch (flushModeType) {
            case ALWAYS: {
                return FlushMode.ALWAYS;
            }
            case AUTO: {
                return FlushMode.AUTO;
            }
            case COMMIT: {
                return FlushMode.COMMIT;
            }
            case MANUAL: {
                return FlushMode.MANUAL;
            }
            case PERSISTENCE_CONTEXT: {
                return null;
            }
        }
        throw new AssertionFailure("Unknown FlushModeType: " + flushModeType);
    }

    private static CacheMode interpretCacheMode(CacheModeType cacheModeType) {
        switch (cacheModeType) {
            case GET: {
                return CacheMode.GET;
            }
            case IGNORE: {
                return CacheMode.IGNORE;
            }
            case NORMAL: {
                return CacheMode.NORMAL;
            }
            case PUT: {
                return CacheMode.PUT;
            }
            case REFRESH: {
                return CacheMode.REFRESH;
            }
        }
        throw new AssertionFailure("Unknown cacheModeType: " + cacheModeType);
    }

    public static void bindNamedStoredProcedureQuery(AnnotationUsage<NamedStoredProcedureQuery> namedStoredProcedureQuery, MetadataBuildingContext context, boolean isDefault) {
        if (namedStoredProcedureQuery != null) {
            if (namedStoredProcedureQuery.getString("name").isEmpty()) {
                throw new AnnotationException("Class or package level '@NamedStoredProcedureQuery' annotation must specify a 'name'");
            }
            NamedProcedureCallDefinitionImpl definition = new NamedProcedureCallDefinitionImpl(namedStoredProcedureQuery);
            if (isDefault) {
                context.getMetadataCollector().addDefaultNamedProcedureCall(definition);
            } else {
                context.getMetadataCollector().addNamedProcedureCallDefinition(definition);
            }
            LOG.debugf("Bound named stored procedure query : %s => %s", definition.getRegistrationName(), definition.getProcedureName());
        }
    }

    public static void bindSqlResultSetMapping(AnnotationUsage<SqlResultSetMapping> resultSetMappingAnn, MetadataBuildingContext context, boolean isDefault) {
        context.getMetadataCollector().addSecondPass(new ResultSetMappingSecondPass(resultSetMappingAnn, context, isDefault));
    }

    private static JdbcCall parseJdbcCall(String sqlString, Supplier<RuntimeException> exceptionProducer) {
        String callableName = null;
        boolean resultParameter = false;
        int index = QueryBinder.skipWhitespace(sqlString, 1);
        if (sqlString.charAt(index) == '?') {
            resultParameter = true;
            ++index;
            if (sqlString.charAt(index = QueryBinder.skipWhitespace(sqlString, index)) != '=') {
                throw exceptionProducer.get();
            }
            ++index;
            index = QueryBinder.skipWhitespace(sqlString, index);
        }
        if (!sqlString.regionMatches(true, index, "call", 0, 4)) {
            throw exceptionProducer.get();
        }
        index += 4;
        int procedureStart = index = QueryBinder.skipWhitespace(sqlString, index);
        while (index < sqlString.length()) {
            char c = sqlString.charAt(index);
            if (c == '(' || Character.isWhitespace(c)) {
                callableName = sqlString.substring(procedureStart, index);
                break;
            }
            ++index;
        }
        index = QueryBinder.skipWhitespace(sqlString, index);
        final ArrayList<String> parameters = new ArrayList<String>();
        ParameterParser.parse(sqlString.substring(index, sqlString.length() - 1), new ParameterRecognizer(){

            @Override
            public void ordinalParameter(int sourcePosition) {
                parameters.add("");
            }

            @Override
            public void namedParameter(String name, int sourcePosition) {
                parameters.add(name);
            }

            @Override
            public void jpaPositionalParameter(int label, int sourcePosition) {
                parameters.add("");
            }

            @Override
            public void other(char character) {
            }
        });
        return new JdbcCall(callableName, resultParameter, parameters);
    }

    private static int skipWhitespace(String sqlString, int i) {
        while (i < sqlString.length() && Character.isWhitespace(sqlString.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static AnnotationException illegalCallSyntax(AnnotationUsage<NamedNativeQuery> queryAnn) {
        return new AnnotationException("Callable 'NamedNativeQuery' named '" + queryAnn.getString("name") + "' does not use the JDBC call syntax");
    }

    private static class JdbcCall {
        private final String callableName;
        private final boolean resultParameter;
        private final ArrayList<String> parameters;

        public JdbcCall(String callableName, boolean resultParameter, ArrayList<String> parameters) {
            this.callableName = callableName;
            this.resultParameter = resultParameter;
            this.parameters = parameters;
        }
    }
}

