/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import org.hibernate.TimeZoneStorageStrategy;
import org.hibernate.annotations.TimeZoneStorage;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.dialect.TimeZoneSupport;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.usertype.CompositeUserType;
import org.hibernate.usertype.internal.OffsetDateTimeCompositeUserType;
import org.hibernate.usertype.internal.OffsetTimeCompositeUserType;
import org.hibernate.usertype.internal.ZonedDateTimeCompositeUserType;

public class TimeZoneStorageHelper {
    private static final String OFFSET_TIME_CLASS = OffsetTime.class.getName();
    private static final String OFFSET_DATETIME_CLASS = OffsetDateTime.class.getName();
    private static final String ZONED_DATETIME_CLASS = ZonedDateTime.class.getName();

    static Class<? extends CompositeUserType<?>> resolveTimeZoneStorageCompositeUserType(MemberDetails attributeMember, ClassDetails returnedClass, MetadataBuildingContext context) {
        if (TimeZoneStorageHelper.useColumnForTimeZoneStorage((AnnotationTarget)attributeMember, context)) {
            String returnedClassName = returnedClass.getName();
            if (OFFSET_DATETIME_CLASS.equals(returnedClassName)) {
                return OffsetDateTimeCompositeUserType.class;
            }
            if (ZONED_DATETIME_CLASS.equals(returnedClassName)) {
                return ZonedDateTimeCompositeUserType.class;
            }
            if (OFFSET_TIME_CLASS.equals(returnedClassName)) {
                return OffsetTimeCompositeUserType.class;
            }
        }
        return null;
    }

    private static boolean isTemporalWithTimeZoneClass(String returnedClassName) {
        return OFFSET_DATETIME_CLASS.equals(returnedClassName) || ZONED_DATETIME_CLASS.equals(returnedClassName) || TimeZoneStorageHelper.isOffsetTimeClass(returnedClassName);
    }

    public static boolean isOffsetTimeClass(AnnotationTarget element) {
        if (element instanceof MemberDetails) {
            MemberDetails memberDetails = (MemberDetails)element;
            return TimeZoneStorageHelper.isOffsetTimeClass(memberDetails);
        }
        return false;
    }

    public static boolean isOffsetTimeClass(MemberDetails element) {
        TypeDetails type = element.getType();
        if (type == null) {
            return false;
        }
        return TimeZoneStorageHelper.isOffsetTimeClass(type.determineRawClass().getClassName());
    }

    private static boolean isOffsetTimeClass(String returnedClassName) {
        return OFFSET_TIME_CLASS.equals(returnedClassName);
    }

    static boolean useColumnForTimeZoneStorage(AnnotationTarget element, MetadataBuildingContext context) {
        AnnotationUsage timeZoneStorage = element.getAnnotationUsage(TimeZoneStorage.class);
        if (timeZoneStorage == null) {
            if (element instanceof MemberDetails) {
                MemberDetails attributeMember = (MemberDetails)element;
                return TimeZoneStorageHelper.isTemporalWithTimeZoneClass(attributeMember.getType().getName()) && context.getBuildingOptions().getDefaultTimeZoneStorage() == TimeZoneStorageStrategy.COLUMN;
            }
            return false;
        }
        return switch ((TimeZoneStorageType)timeZoneStorage.getEnum("value", TimeZoneStorageType.class)) {
            case TimeZoneStorageType.COLUMN -> true;
            case TimeZoneStorageType.AUTO -> {
                if (context.getBuildingOptions().getTimeZoneSupport() != TimeZoneSupport.NATIVE) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

