/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Mutability;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.OptimisticLock;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.models.AnnotationPlacementException;
import org.hibernate.boot.models.bind.internal.BasicValueHelper;
import org.hibernate.boot.models.bind.internal.Binding;
import org.hibernate.boot.models.bind.spi.BindingContext;
import org.hibernate.boot.models.bind.spi.BindingOptions;
import org.hibernate.boot.models.bind.spi.BindingState;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.models.ModelsException;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public class AttributeBinding
extends Binding {
    private final AttributeMetadata attributeMetadata;
    private final Property property;
    private final Table attributeTable;
    private final Value mappingValue;

    public AttributeBinding(AttributeMetadata attributeMetadata, PersistentClass owner, Table primaryTable, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        super(bindingOptions, bindingState, bindingContext);
        SimpleValue value;
        this.attributeMetadata = attributeMetadata;
        this.property = new Property();
        this.property.setName(attributeMetadata.getName());
        if (attributeMetadata.getNature() == AttributeMetadata.AttributeNature.BASIC) {
            value = this.createBasicValue(primaryTable);
        } else if (attributeMetadata.getNature() == AttributeMetadata.AttributeNature.EMBEDDED) {
            value = this.createComponentValue(primaryTable, owner);
        } else {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.property.setValue(value);
        this.attributeTable = value.getTable();
        this.mappingValue = value;
        this.applyNaturalId(attributeMetadata, this.property);
    }

    public AttributeBinding(AttributeMetadata attributeMetadata, Component owner, Table primaryTable, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        super(bindingOptions, bindingState, bindingContext);
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private BasicValue createBasicValue(Table primaryTable) {
        BasicValue basicValue = new BasicValue(this.bindingState.getMetadataBuildingContext());
        MemberDetails member = this.attributeMetadata.getMember();
        BasicValueHelper.bindImplicitJavaType(member, basicValue, this.bindingOptions, this.bindingState, this.bindingContext);
        this.bindMutability(member, this.property, basicValue);
        this.bindOptimisticLocking(member, this.property, basicValue);
        this.bindConversion(member, this.property, basicValue);
        this.processColumn(member, this.property, basicValue, primaryTable, Column.class);
        BasicValueHelper.bindJavaType(member, basicValue, this.bindingOptions, this.bindingState, this.bindingContext);
        BasicValueHelper.bindJdbcType(member, basicValue, this.bindingOptions, this.bindingState, this.bindingContext);
        BasicValueHelper.bindLob(member, basicValue, this.bindingOptions, this.bindingState, this.bindingContext);
        BasicValueHelper.bindNationalized(member, basicValue, this.bindingOptions, this.bindingState, this.bindingContext);
        BasicValueHelper.bindEnumerated(member, basicValue, this.bindingOptions, this.bindingState, this.bindingContext);
        BasicValueHelper.bindTemporalPrecision(member, basicValue, this.bindingOptions, this.bindingState, this.bindingContext);
        BasicValueHelper.bindTimeZoneStorage(member, this.property, basicValue, this.bindingOptions, this.bindingState, this.bindingContext);
        return basicValue;
    }

    private Component createComponentValue(Table primaryTable, PersistentClass persistentClass) {
        Component component = new Component(this.bindingState.getMetadataBuildingContext(), persistentClass);
        MemberDetails member = this.attributeMetadata.getMember();
        return component;
    }

    public Property getProperty() {
        return this.property;
    }

    public Table getAttributeTable() {
        return this.attributeTable;
    }

    public Value getMappingValue() {
        return this.mappingValue;
    }

    @Override
    public Property getBinding() {
        return this.getProperty();
    }

    private void bindMutability(MemberDetails member, Property property, BasicValue basicValue) {
        AnnotationUsage mutabilityAnn = member.getAnnotationUsage(Mutability.class);
        AnnotationUsage immutableAnn = member.getAnnotationUsage(Immutable.class);
        if (immutableAnn != null) {
            if (mutabilityAnn != null) {
                throw new AnnotationPlacementException("Illegal combination of @Mutability and @Immutable - " + member.getName());
            }
            property.setUpdateable(false);
        } else if (mutabilityAnn != null) {
            basicValue.setExplicitMutabilityPlanAccess(typeConfiguration -> {
                ClassDetails classDetails = mutabilityAnn.getClassDetails("value");
                Class javaClass = classDetails.toJavaClass();
                try {
                    return (MutabilityPlan)javaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    ModelsException modelsException = new ModelsException("Error instantiating local @MutabilityPlan - " + member.getName());
                    modelsException.addSuppressed((Throwable)e);
                    throw modelsException;
                }
            });
        }
    }

    private void bindOptimisticLocking(MemberDetails member, Property property, BasicValue basicValue) {
        AnnotationUsage annotationUsage = member.getAnnotationUsage(OptimisticLock.class);
        if (annotationUsage != null && annotationUsage.getBoolean("excluded").booleanValue()) {
            property.setOptimisticLocked(false);
            return;
        }
        property.setOptimisticLocked(true);
    }

    private void bindConversion(MemberDetails member, Property property, BasicValue basicValue) {
        AnnotationUsage convertAnn = member.getAnnotationUsage(Convert.class);
        if (convertAnn == null) {
            return;
        }
        if (convertAnn.getBoolean("disableConversion").booleanValue()) {
            return;
        }
        if (convertAnn.getString("attributeName") != null) {
            throw new ModelsException("@Convert#attributeName should not be specified on basic mappings - " + member.getName());
        }
        ClassDetails converterClassDetails = convertAnn.getClassDetails("converter");
        Class javaClass = converterClassDetails.toJavaClass();
        basicValue.setJpaAttributeConverterDescriptor(new ClassBasedConverterDescriptor(javaClass, this.bindingContext.getClassmateContext()));
    }

    public <A extends Annotation> void processColumn(MemberDetails member, Property property, BasicValue basicValue, Table primaryTable, Class<A> annotation) {
        BasicValueHelper.bindColumn(member, property::getName, basicValue, primaryTable, this.bindingOptions, this.bindingState, this.bindingContext);
    }

    private void applyNaturalId(AttributeMetadata attributeMetadata, Property property) {
        AnnotationUsage naturalIdAnn = attributeMetadata.getMember().getAnnotationUsage(NaturalId.class);
        if (naturalIdAnn == null) {
            return;
        }
        property.setNaturalIdentifier(true);
        property.setUpdateable(naturalIdAnn.getBoolean("mutable"));
    }
}

