/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Lob;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.function.Supplier;
import org.hibernate.MappingException;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.Nationalized;
import org.hibernate.annotations.TimeZoneColumn;
import org.hibernate.annotations.TimeZoneStorage;
import org.hibernate.annotations.TimeZoneStorageType;
import org.hibernate.boot.model.convert.internal.ClassBasedConverterDescriptor;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.models.AnnotationPlacementException;
import org.hibernate.boot.models.bind.internal.BindingHelper;
import org.hibernate.boot.models.bind.internal.ColumnHelper;
import org.hibernate.boot.models.bind.spi.BindingContext;
import org.hibernate.boot.models.bind.spi.BindingOptions;
import org.hibernate.boot.models.bind.spi.BindingState;
import org.hibernate.boot.models.bind.spi.TableReference;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.boot.models.categorize.spi.EntityTypeMetadata;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Table;
import org.hibernate.models.ModelsException;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.spi.TypeConfiguration;

public class BasicValueHelper {
    public static final String TENANT_FILTER_NAME = "_tenantId";
    public static final String TENANT_PARAMETER_NAME = "tenantId";

    public static void bindImplicitJavaType(MemberDetails member, BasicValue basicValue, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        basicValue.setImplicitJavaTypeAccess(typeConfiguration -> member.getType().determineRawClass().toJavaClass());
    }

    public static void bindJavaType(MemberDetails member, BasicValue basicValue, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        AnnotationUsage javaTypeAnn = member.getAnnotationUsage(org.hibernate.annotations.JavaType.class);
        if (javaTypeAnn == null) {
            return;
        }
        basicValue.setExplicitJavaTypeAccess(typeConfiguration -> {
            ClassDetails classDetails = javaTypeAnn.getClassDetails("value");
            Class javaClass = classDetails.toJavaClass();
            try {
                return (BasicJavaType)javaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                ModelsException modelsException = new ModelsException("Error instantiating local @JavaType - " + member.getName());
                modelsException.addSuppressed((Throwable)e);
                throw modelsException;
            }
        });
    }

    public static void bindJdbcType(MemberDetails member, BasicValue basicValue, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        AnnotationUsage jdbcTypeAnn = member.getAnnotationUsage(org.hibernate.annotations.JdbcType.class);
        AnnotationUsage jdbcTypeCodeAnn = member.getAnnotationUsage(JdbcTypeCode.class);
        if (jdbcTypeAnn != null) {
            if (jdbcTypeCodeAnn != null) {
                throw new AnnotationPlacementException("Illegal combination of @JdbcType and @JdbcTypeCode - " + member.getName());
            }
            basicValue.setExplicitJdbcTypeAccess(typeConfiguration -> {
                ClassDetails classDetails = jdbcTypeAnn.getClassDetails("value");
                Class javaClass = classDetails.toJavaClass();
                try {
                    return (JdbcType)javaClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    ModelsException modelsException = new ModelsException("Error instantiating local @JdbcType - " + member.getName());
                    modelsException.addSuppressed((Throwable)e);
                    throw modelsException;
                }
            });
        } else if (jdbcTypeCodeAnn != null) {
            Integer typeCode = jdbcTypeCodeAnn.getInteger("value");
            basicValue.setExplicitJdbcTypeCode(typeCode);
        }
    }

    public static void bindNationalized(MemberDetails member, BasicValue basicValue, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        if (member.getAnnotationUsage(Nationalized.class) != null) {
            basicValue.makeNationalized();
        }
    }

    public static void bindLob(MemberDetails member, BasicValue basicValue, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        if (member.getAnnotationUsage(Lob.class) != null) {
            basicValue.makeLob();
        }
    }

    public static void bindEnumerated(MemberDetails member, BasicValue basicValue, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        AnnotationUsage enumerated = member.getAnnotationUsage(Enumerated.class);
        if (enumerated == null) {
            return;
        }
        basicValue.setEnumerationStyle((EnumType)enumerated.getEnum("value"));
    }

    public static void bindTemporalPrecision(MemberDetails member, BasicValue basicValue, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        AnnotationUsage temporalAnn = member.getAnnotationUsage(Temporal.class);
        if (temporalAnn == null) {
            return;
        }
        TemporalType precision = (TemporalType)temporalAnn.getEnum("value");
        basicValue.setTemporalPrecision(precision);
    }

    public static void bindTimeZoneStorage(MemberDetails member, Property property, BasicValue basicValue, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        AnnotationUsage storageAnn = member.getAnnotationUsage(TimeZoneStorage.class);
        AnnotationUsage columnAnn = member.getAnnotationUsage(TimeZoneColumn.class);
        if (storageAnn != null) {
            TimeZoneStorageType strategy = (TimeZoneStorageType)storageAnn.getEnum("value");
            if (strategy != TimeZoneStorageType.COLUMN && columnAnn != null) {
                throw new AnnotationPlacementException("Illegal combination of @TimeZoneStorage(" + strategy.name() + ") and @TimeZoneColumn");
            }
            basicValue.setTimeZoneStorageType(strategy);
        }
        if (columnAnn != null) {
            org.hibernate.mapping.Column column = (org.hibernate.mapping.Column)basicValue.getColumn();
            String name = columnAnn.getString("name");
            if (StringHelper.isEmpty(name)) {
                column.setName(property.getName() + "_tz");
            } else {
                column.setName(name);
            }
            column.setSqlType(columnAnn.getString("columnDefinition"));
            String tableName = columnAnn.getString("table");
            TableReference tableByName = null;
            if (tableName != null) {
                Identifier identifier = Identifier.toIdentifier(tableName);
                tableByName = (TableReference)bindingState.getTableByName(identifier.getCanonicalName());
                basicValue.setTable(tableByName.table());
            }
            property.setInsertable(columnAnn.getBoolean("insertable"));
            property.setUpdateable(columnAnn.getBoolean("updatable"));
        }
    }

    public static void bindConversion(MemberDetails member, BasicValue basicValue, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        AnnotationUsage convertAnn = member.getAnnotationUsage(Convert.class);
        if (convertAnn == null) {
            return;
        }
        if (convertAnn.getBoolean("disableConversion").booleanValue()) {
            return;
        }
        if (convertAnn.getString("attributeName") != null) {
            throw new ModelsException("@Convert#attributeName should not be specified on basic mappings - " + member.getName());
        }
        ClassDetails converterClassDetails = convertAnn.getClassDetails("converter");
        Class javaClass = converterClassDetails.toJavaClass();
        basicValue.setJpaAttributeConverterDescriptor(new ClassBasedConverterDescriptor(javaClass, bindingContext.getClassmateContext()));
    }

    public static org.hibernate.mapping.Column bindColumn(MemberDetails member, Supplier<String> defaultNameSupplier, BasicValue basicValue, Table primaryTable, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        return BasicValueHelper.bindColumn(member, Column.class, defaultNameSupplier, basicValue, primaryTable, bindingOptions, bindingState, bindingContext);
    }

    public static <A extends Annotation> org.hibernate.mapping.Column bindColumn(MemberDetails member, Class<A> annotationType, Supplier<String> defaultNameSupplier, BasicValue basicValue, Table primaryTable, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        AnnotationUsage columnAnn = member.getAnnotationUsage(annotationType);
        org.hibernate.mapping.Column column = ColumnHelper.bindColumn(columnAnn, defaultNameSupplier);
        String tableName = BindingHelper.getValue(columnAnn, "table", "");
        if (StringHelper.isEmpty(tableName)) {
            basicValue.setTable(primaryTable);
        } else {
            Identifier identifier = Identifier.toIdentifier(tableName);
            Object tableByName = bindingState.getTableByName(identifier.getCanonicalName());
            basicValue.setTable(tableByName.table());
        }
        basicValue.addColumn(column);
        return column;
    }

    public static void bindTenantId(EntityTypeMetadata managedType, RootClass rootClass, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        AttributeMetadata tenantIdAttribute = managedType.getHierarchy().getTenantIdAttribute();
        if (tenantIdAttribute == null) {
            return;
        }
        InFlightMetadataCollector collector = bindingState.getMetadataBuildingContext().getMetadataCollector();
        TypeConfiguration typeConfiguration = collector.getTypeConfiguration();
        MemberDetails memberDetails = tenantIdAttribute.getMember();
        String returnedClassName = memberDetails.getType().determineRawClass().getClassName();
        BasicType tenantIdType = typeConfiguration.getBasicTypeRegistry().getRegisteredType(returnedClassName);
        FilterDefinition filterDefinition = collector.getFilterDefinition(TENANT_FILTER_NAME);
        if (filterDefinition == null) {
            collector.addFilterDefinition(new FilterDefinition(TENANT_FILTER_NAME, "", Collections.singletonMap(TENANT_PARAMETER_NAME, tenantIdType)));
        } else {
            JavaType tenantIdTypeJtd = tenantIdType.getJavaTypeDescriptor();
            JavaType parameterJtd = filterDefinition.getParameterJdbcMapping(TENANT_PARAMETER_NAME).getJavaTypeDescriptor();
            if (!parameterJtd.getJavaTypeClass().equals(tenantIdTypeJtd.getJavaTypeClass())) {
                throw new MappingException("all @TenantId fields must have the same type: " + parameterJtd.getJavaType().getTypeName() + " differs from " + tenantIdTypeJtd.getJavaType().getTypeName());
            }
        }
        Property property = new Property();
        rootClass.addProperty(property);
        property.setName(tenantIdAttribute.getName());
        BasicValue basicValue = new BasicValue(bindingState.getMetadataBuildingContext(), rootClass.getRootTable());
        property.setValue(basicValue);
        BasicValueHelper.bindImplicitJavaType(memberDetails, basicValue, bindingOptions, bindingState, bindingContext);
        BasicValueHelper.bindJavaType(memberDetails, basicValue, bindingOptions, bindingState, bindingContext);
        BasicValueHelper.bindJdbcType(memberDetails, basicValue, bindingOptions, bindingState, bindingContext);
        BasicValueHelper.bindConversion(memberDetails, basicValue, bindingOptions, bindingState, bindingContext);
        BasicValueHelper.bindEnumerated(memberDetails, basicValue, bindingOptions, bindingState, bindingContext);
        BasicValueHelper.bindColumn(memberDetails, property::getName, basicValue, rootClass.getRootTable(), bindingOptions, bindingState, bindingContext);
        property.resetUpdateable(false);
        property.resetOptional(false);
    }

    public static void bindVersion(EntityTypeMetadata typeMetadata, RootClass rootClass, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        AttributeMetadata versionAttribute = typeMetadata.getHierarchy().getVersionAttribute();
        if (versionAttribute == null) {
            return;
        }
        Property property = new Property();
        property.setName(versionAttribute.getName());
        rootClass.setVersion(property);
        rootClass.addProperty(property);
        BasicValue basicValue = new BasicValue(bindingState.getMetadataBuildingContext(), rootClass.getRootTable());
        property.setValue(basicValue);
        MemberDetails memberDetails = versionAttribute.getMember();
        BasicValueHelper.bindImplicitJavaType(memberDetails, basicValue, bindingOptions, bindingState, bindingContext);
        BasicValueHelper.bindJavaType(memberDetails, basicValue, bindingOptions, bindingState, bindingContext);
        BasicValueHelper.bindJdbcType(memberDetails, basicValue, bindingOptions, bindingState, bindingContext);
        org.hibernate.mapping.Column column = BasicValueHelper.bindColumn(memberDetails, property::getName, basicValue, rootClass.getRootTable(), bindingOptions, bindingState, bindingContext);
        column.setNullable(false);
    }
}

