/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ObjectNameNormalizer;
import org.hibernate.boot.models.bind.spi.BindingOptions;
import org.hibernate.boot.models.bind.spi.BindingState;
import org.hibernate.boot.models.bind.spi.QuotedIdentifierTarget;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationUsage;

public class BindingHelper {
    public static Identifier toIdentifier(String name, QuotedIdentifierTarget target, BindingOptions options, JdbcEnvironment jdbcEnvironment) {
        boolean globallyQuoted = options.getGloballyQuotedIdentifierTargets().contains((Object)target);
        return jdbcEnvironment.getIdentifierHelper().toIdentifier(name, globallyQuoted);
    }

    public static <T, A extends Annotation> T getValue(AnnotationUsage<A> ann, String attributeName, T defaultValue) {
        if (ann == null) {
            return defaultValue;
        }
        return (T)ann.getAttributeValue(attributeName);
    }

    public static <T, A extends Annotation> T getValue(AnnotationUsage<A> ann, String attributeName, AnnotationDescriptor<A> descriptor) {
        if (ann == null) {
            return (T)descriptor.getAttribute(attributeName).getAttributeMethod().getDefaultValue();
        }
        return (T)ann.getAttributeValue(attributeName);
    }

    public static <T, A extends Annotation> T getValue(AnnotationUsage<A> ann, String attributeName, Supplier<T> defaultValueSupplier) {
        if (ann == null) {
            return defaultValueSupplier.get();
        }
        return (T)ann.getAttributeValue(attributeName);
    }

    public static <A extends Annotation> String getGloballyQuotedValue(AnnotationUsage<A> ann, String attributeName, Supplier<String> defaultValueSupplier, BindingOptions bindingOptions, BindingState bindingState) {
        String value = BindingHelper.getValue(ann, attributeName, defaultValueSupplier);
        return BindingHelper.applyGlobalQuoting(value, QuotedIdentifierTarget.COLUMN_DEFINITION, bindingOptions, bindingState);
    }

    public static String applyGlobalQuoting(String text, QuotedIdentifierTarget target, BindingOptions options, BindingState bindingState) {
        boolean globallyQuoted = options.getGloballyQuotedIdentifierTargets().contains((Object)target);
        if (!globallyQuoted) {
            return text;
        }
        ObjectNameNormalizer objectNameNormalizer = bindingState.getMetadataBuildingContext().getObjectNameNormalizer();
        return objectNameNormalizer.applyGlobalQuoting(text);
    }
}

