/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.models.bind.internal.EntityBinding;
import org.hibernate.boot.models.bind.internal.IdentifiableTypeBinding;
import org.hibernate.boot.models.bind.internal.ManagedTypeBinding;
import org.hibernate.boot.models.bind.internal.MappedSuperclassBinding;
import org.hibernate.boot.models.bind.internal.SecondaryTable;
import org.hibernate.boot.models.bind.spi.BindingState;
import org.hibernate.boot.models.bind.spi.TableReference;
import org.hibernate.boot.models.categorize.spi.FilterDefRegistration;
import org.hibernate.boot.models.categorize.spi.IdentifiableTypeMetadata;
import org.hibernate.boot.models.categorize.spi.ManagedTypeMetadata;
import org.hibernate.boot.models.categorize.spi.TableOwner;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.internal.util.KeyedConsumer;
import org.hibernate.models.spi.ClassDetails;

public class BindingStateImpl
implements BindingState {
    private final MetadataBuildingContext metadataBuildingContext;
    private final Database database;
    private final JdbcServices jdbcServices;
    private final Map<String, TableReference> tableMap = new HashMap<String, TableReference>();
    private final Map<TableOwner, TableReference> tableByOwnerMap = new HashMap<TableOwner, TableReference>();
    private final Map<ClassDetails, ManagedTypeBinding> typeBindings = new HashMap<ClassDetails, ManagedTypeBinding>();
    private final Map<ClassDetails, IdentifiableTypeBinding> typeBindersBySuper = new HashMap<ClassDetails, IdentifiableTypeBinding>();

    public BindingStateImpl(MetadataBuildingContext metadataBuildingContext) {
        this.metadataBuildingContext = metadataBuildingContext;
        this.database = metadataBuildingContext.getMetadataCollector().getDatabase();
        this.jdbcServices = metadataBuildingContext.getBootstrapContext().getServiceRegistry().getService(JdbcServices.class);
    }

    @Override
    public MetadataBuildingContext getMetadataBuildingContext() {
        return this.metadataBuildingContext;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.jdbcServices;
    }

    @Override
    public int getTableCount() {
        return this.tableMap.size();
    }

    @Override
    public void forEachTable(KeyedConsumer<String, TableReference> consumer) {
        this.tableMap.forEach((BiConsumer)((Object)consumer));
    }

    @Override
    public <T extends TableReference> T getTableByName(String name) {
        return (T)this.tableMap.get(name);
    }

    @Override
    public <T extends TableReference> T getTableByOwner(TableOwner owner) {
        return (T)this.tableByOwnerMap.get(owner);
    }

    @Override
    public void addTable(TableOwner owner, TableReference table) {
        this.tableMap.put(table.logicalName().getCanonicalName(), table);
        this.tableByOwnerMap.put(owner, table);
    }

    @Override
    public void addSecondaryTable(SecondaryTable table) {
        this.tableMap.put(table.logicalName().getCanonicalName(), table);
    }

    private String resolveSchemaName(Identifier explicit) {
        Identifier defaultSchemaName;
        if (explicit != null) {
            return explicit.getCanonicalName();
        }
        Namespace defaultNamespace = this.metadataBuildingContext.getMetadataCollector().getDatabase().getDefaultNamespace();
        if (defaultNamespace != null && (defaultSchemaName = defaultNamespace.getName().getSchema()) != null) {
            return defaultSchemaName.getCanonicalName();
        }
        return null;
    }

    private String resolveCatalogName(Identifier explicit) {
        Identifier defaultCatalogName;
        if (explicit != null) {
            return explicit.getCanonicalName();
        }
        Namespace defaultNamespace = this.metadataBuildingContext.getMetadataCollector().getDatabase().getDefaultNamespace();
        if (defaultNamespace != null && (defaultCatalogName = defaultNamespace.getName().getCatalog()) != null) {
            return defaultCatalogName.getCanonicalName();
        }
        return null;
    }

    @Override
    public void registerTypeBinding(ManagedTypeMetadata type, ManagedTypeBinding binding) {
        IdentifiableTypeMetadata identifiableType;
        this.typeBindings.put(type.getClassDetails(), binding);
        if (type instanceof IdentifiableTypeMetadata && (identifiableType = (IdentifiableTypeMetadata)type).getSuperType() != null) {
            this.typeBindersBySuper.put(identifiableType.getSuperType().getClassDetails(), (IdentifiableTypeBinding)binding);
        }
        if (binding instanceof EntityBinding) {
            EntityBinding entityTypeBinding = (EntityBinding)binding;
            this.metadataBuildingContext.getMetadataCollector().addEntityBinding(entityTypeBinding.getPersistentClass());
        } else if (binding instanceof MappedSuperclassBinding) {
            MappedSuperclassBinding mappedSuperBinding = (MappedSuperclassBinding)binding;
            this.metadataBuildingContext.getMetadataCollector().addMappedSuperclass(mappedSuperBinding.typeMetadata.getClassDetails().toJavaClass(), mappedSuperBinding.getMappedSuperclass());
        }
    }

    @Override
    public ManagedTypeBinding getTypeBinding(ClassDetails type) {
        return this.typeBindings.get(type);
    }

    @Override
    public IdentifiableTypeBinding getSuperTypeBinding(ClassDetails type) {
        return this.typeBindersBySuper.get(type);
    }

    @Override
    public void apply(FilterDefRegistration registration) {
        this.metadataBuildingContext.getMetadataCollector().addFilterDefinition(registration.toFilterDefinition(this.metadataBuildingContext));
    }
}

