/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorType;
import java.util.function.Supplier;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.boot.models.bind.internal.BindingHelper;
import org.hibernate.boot.models.bind.spi.BindingContext;
import org.hibernate.boot.models.bind.spi.BindingOptions;
import org.hibernate.boot.models.bind.spi.BindingState;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationUsage;

public class ColumnHelper {
    public static Column bindColumn(AnnotationUsage<?> annotationUsage, Supplier<String> defaultNameSupplier) {
        return ColumnHelper.bindColumn(annotationUsage, defaultNameSupplier, false, true, 255, 0, 0, -1);
    }

    public static Column bindColumn(AnnotationUsage<?> annotationUsage, Supplier<String> defaultNameSupplier, boolean uniqueByDefault, boolean nullableByDefault) {
        return ColumnHelper.bindColumn(annotationUsage, defaultNameSupplier, uniqueByDefault, nullableByDefault, 255, 0, 0, -1);
    }

    public static Column bindColumn(AnnotationUsage<?> annotationUsage, Supplier<String> defaultNameSupplier, boolean uniqueByDefault, boolean nullableByDefault, int lengthByDefault, int precisionByDefault, int scaleByDefault, int secondPrecisionByDefault) {
        Column result = new Column();
        result.setName(ColumnHelper.columnName(annotationUsage, defaultNameSupplier));
        result.setUnique(BindingHelper.getValue(annotationUsage, "unique", uniqueByDefault));
        result.setNullable(BindingHelper.getValue(annotationUsage, "nullable", nullableByDefault));
        result.setSqlType(BindingHelper.getValue(annotationUsage, "columnDefinition", (String)null));
        result.setLength(BindingHelper.getValue(annotationUsage, "length", lengthByDefault));
        result.setPrecision(BindingHelper.getValue(annotationUsage, "precision", precisionByDefault));
        result.setPrecision(BindingHelper.getValue(annotationUsage, "secondPrecision", secondPrecisionByDefault));
        result.setScale(BindingHelper.getValue(annotationUsage, "scale", scaleByDefault));
        return result;
    }

    public static String columnName(AnnotationUsage<?> columnAnnotation, Supplier<String> defaultNameSupplier) {
        if (columnAnnotation == null) {
            return defaultNameSupplier.get();
        }
        return NullnessHelper.nullif((String)columnAnnotation.getAttributeValue("name"), defaultNameSupplier);
    }

    private ColumnHelper() {
    }

    public static DiscriminatorType bindDiscriminatorColumn(BindingContext bindingContext, AnnotationUsage<DiscriminatorFormula> formulaAnn, BasicValue value, AnnotationUsage<DiscriminatorColumn> columnAnn, BindingOptions bindingOptions, BindingState bindingState) {
        DiscriminatorType discriminatorType;
        if (formulaAnn != null) {
            Formula formula = new Formula(formulaAnn.getString("value"));
            value.addFormula(formula);
            discriminatorType = (DiscriminatorType)formulaAnn.getEnum("discriminatorType");
        } else {
            Column column = new Column();
            value.addColumn(column, true, false);
            discriminatorType = BindingHelper.getValue(columnAnn, "discriminatorType", DiscriminatorType.STRING);
            column.setName(ColumnHelper.columnName(columnAnn, () -> "dtype"));
            column.setLength((Integer)BindingHelper.getValue(columnAnn, "length", () -> {
                AnnotationDescriptor descriptor = columnAnn != null ? columnAnn.getAnnotationDescriptor() : bindingContext.getAnnotationDescriptorRegistry().getDescriptor(DiscriminatorColumn.class);
                return descriptor.getAttribute("length").getAttributeMethod().getDefaultValue();
            }));
            column.setSqlType(BindingHelper.getGloballyQuotedValue(columnAnn, "columnDefinition", () -> {
                AnnotationDescriptor descriptor = columnAnn != null ? columnAnn.getAnnotationDescriptor() : bindingContext.getAnnotationDescriptorRegistry().getDescriptor(DiscriminatorColumn.class);
                return (String)descriptor.getAttribute("columnDefinition").getAttributeMethod().getDefaultValue();
            }, bindingOptions, bindingState));
            ColumnHelper.applyOptions(column, columnAnn);
        }
        return discriminatorType;
    }

    private static void applyOptions(Column column, AnnotationUsage<?> columnAnn) {
        String options;
        if (columnAnn != null && StringHelper.isNotEmpty(options = columnAnn.getString("options"))) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }
}

