/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import jakarta.persistence.Cacheable;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import jakarta.persistence.SharedCacheMode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.ResultCheckStyle;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.bind.ModelBindingLogging;
import org.hibernate.boot.models.bind.internal.AttributeBinding;
import org.hibernate.boot.models.bind.internal.BindingHelper;
import org.hibernate.boot.models.bind.internal.IdentifiableTypeBinding;
import org.hibernate.boot.models.bind.internal.MappedSuperclassBinding;
import org.hibernate.boot.models.bind.internal.RootEntityBinding;
import org.hibernate.boot.models.bind.internal.SubclassEntityBinding;
import org.hibernate.boot.models.bind.spi.BindingContext;
import org.hibernate.boot.models.bind.spi.BindingOptions;
import org.hibernate.boot.models.bind.spi.BindingState;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.EntityTypeMetadata;
import org.hibernate.boot.models.categorize.spi.JpaEventListener;
import org.hibernate.boot.models.categorize.spi.JpaEventListenerStyle;
import org.hibernate.boot.models.categorize.spi.MappedSuperclassTypeMetadata;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.event.internal.EntityCallback;
import org.hibernate.jpa.event.internal.ListenerCallback;
import org.hibernate.jpa.event.spi.CallbackDefinition;
import org.hibernate.jpa.event.spi.CallbackType;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.models.ModelsException;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MethodDetails;

public abstract class EntityBinding
extends IdentifiableTypeBinding {
    public EntityBinding(EntityTypeMetadata entityTypeMetadata, IdentifiableTypeBinding superTypeBinding, EntityHierarchy.HierarchyRelation hierarchyRelation, BindingOptions bindingOptions, BindingState bindingState, BindingContext bindingContext) {
        super(entityTypeMetadata, superTypeBinding, hierarchyRelation, bindingOptions, bindingState, bindingContext);
    }

    public abstract PersistentClass getPersistentClass();

    @Override
    public EntityTypeMetadata getTypeMetadata() {
        return (EntityTypeMetadata)super.getTypeMetadata();
    }

    protected static void applyNaming(EntityTypeMetadata source, PersistentClass persistentClass, BindingState bindingState) {
        ClassDetails classDetails = source.getClassDetails();
        AnnotationUsage entityAnn = classDetails.getAnnotationUsage(Entity.class);
        String jpaEntityName = BindingHelper.getValue(entityAnn, "name", (String)null);
        String entityName = classDetails.getName() != null && !classDetails.getName().equals(classDetails.getClassName()) ? classDetails.getName() : classDetails.getClassName();
        String importName = StringHelper.isNotEmpty(jpaEntityName) ? jpaEntityName : StringHelper.unqualifyEntityName(entityName);
        persistentClass.setClassName(classDetails.getClassName());
        persistentClass.setEntityName(entityName);
        persistentClass.setJpaEntityName(importName);
        bindingState.getMetadataBuildingContext().getMetadataCollector().addImport(importName, entityName);
    }

    protected static void applyCommonInformation(EntityTypeMetadata typeMetadata, PersistentClass persistentClass, BindingState bindingState) {
        EntityBinding.applyCaching(typeMetadata, persistentClass, bindingState);
        EntityBinding.applyFilters(typeMetadata, persistentClass);
        EntityBinding.applyJpaEventListeners(typeMetadata, persistentClass);
        EntityBinding.applyBatchSize(typeMetadata, persistentClass, bindingState);
        EntityBinding.applySqlCustomizations(typeMetadata, persistentClass, bindingState);
        EntityBinding.applySynchronizedTableNames(typeMetadata, persistentClass, bindingState);
    }

    protected static void applyDiscriminatorValue(EntityTypeMetadata typeMetadata, PersistentClass persistentClass) {
        BasicValue discriminatorMapping = (BasicValue)persistentClass.getRootClass().getDiscriminator();
        if (discriminatorMapping == null) {
            return;
        }
        AnnotationUsage ann = typeMetadata.getClassDetails().getAnnotationUsage(DiscriminatorValue.class);
        if (ann == null) {
            Type resolvedJavaType = discriminatorMapping.resolve().getRelationalJavaType().getJavaType();
            if (resolvedJavaType == String.class) {
                persistentClass.setDiscriminatorValue(persistentClass.getEntityName());
            } else {
                persistentClass.setDiscriminatorValue(Integer.toString(persistentClass.getSubclassId()));
            }
        } else {
            persistentClass.setDiscriminatorValue(ann.getString("value"));
        }
    }

    protected static void applyCaching(EntityTypeMetadata source, PersistentClass persistentClass, BindingState bindingState) {
        ClassDetails classDetails = source.getClassDetails();
        AnnotationUsage cacheableAnn = classDetails.getAnnotationUsage(Cacheable.class);
        if (cacheableAnn == null) {
            return;
        }
        SharedCacheMode sharedCacheMode = bindingState.getMetadataBuildingContext().getBuildingOptions().getSharedCacheMode();
        persistentClass.setCached(EntityBinding.isCacheable(sharedCacheMode, (AnnotationUsage<Cacheable>)cacheableAnn));
    }

    private static boolean isCacheable(SharedCacheMode sharedCacheMode, AnnotationUsage<Cacheable> explicitCacheableAnn) {
        return switch (sharedCacheMode) {
            case SharedCacheMode.ALL -> true;
            case SharedCacheMode.ENABLE_SELECTIVE, SharedCacheMode.UNSPECIFIED -> {
                if (explicitCacheableAnn != null && explicitCacheableAnn.getBoolean("value").booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case SharedCacheMode.DISABLE_SELECTIVE -> {
                if (explicitCacheableAnn == null || explicitCacheableAnn.getBoolean("value").booleanValue()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    protected static void applyFilters(EntityTypeMetadata source, PersistentClass persistentClass) {
        ClassDetails classDetails = source.getClassDetails();
        List filters = classDetails.getRepeatedAnnotationUsages(Filter.class);
        if (CollectionHelper.isEmpty(filters)) {
            return;
        }
        filters.forEach(filter -> persistentClass.addFilter(filter.getString("name"), filter.getString("condition"), (Boolean)filter.getAttributeValue("deduceAliasInjectionPoints"), EntityBinding.extractFilterAliasTableMap((AnnotationUsage<Filter>)filter), EntityBinding.extractFilterAliasEntityMap((AnnotationUsage<Filter>)filter)));
    }

    private static Map<String, String> extractFilterAliasTableMap(AnnotationUsage<Filter> filter) {
        return null;
    }

    private static Map<String, String> extractFilterAliasEntityMap(AnnotationUsage<Filter> filter) {
        return null;
    }

    protected static void applyJpaEventListeners(EntityTypeMetadata typeMetadata, PersistentClass persistentClass) {
        List<JpaEventListener> listeners = typeMetadata.getCompleteJpaEventListeners();
        if (CollectionHelper.isEmpty(listeners)) {
            return;
        }
        listeners.forEach(listener -> {
            if (listener.getStyle() == JpaEventListenerStyle.CALLBACK) {
                EntityBinding.processEntityCallbacks(listener, typeMetadata, persistentClass);
            } else {
                assert (listener.getStyle() == JpaEventListenerStyle.LISTENER);
                EntityBinding.processListenerCallbacks(listener, typeMetadata, persistentClass);
            }
        });
    }

    private static void processEntityCallbacks(JpaEventListener listener, EntityTypeMetadata typeMetadata, PersistentClass persistentClass) {
        Class entityClass = listener.getCallbackClass().toJavaClass();
        EntityBinding.processJpaEventCallbacks(entityClass, listener, JpaEventListenerStyle.CALLBACK, null, typeMetadata, persistentClass);
    }

    private static void processJpaEventCallbacks(Class<?> listenerClass, JpaEventListener listener, JpaEventListenerStyle style, Class<?> methodArgumentType, EntityTypeMetadata typeMetadata, PersistentClass persistentClass) {
        MethodDetails postLoadMethod;
        MethodDetails postRemoveMethod;
        MethodDetails preRemoveMethod;
        MethodDetails postUpdateMethod;
        MethodDetails preUpdateMethod;
        MethodDetails postPersistMethod;
        assert (style == JpaEventListenerStyle.CALLBACK || methodArgumentType != null);
        ArrayList<CallbackDefinition> callbackDefinitions = new ArrayList<CallbackDefinition>();
        MethodDetails prePersistMethod = listener.getPrePersistMethod();
        if (prePersistMethod != null) {
            Method callbackMethod = EntityBinding.findCallbackMethod(listenerClass, prePersistMethod);
            callbackDefinitions.add(EntityBinding.createCallbackDefinition(listenerClass, callbackMethod, style, CallbackType.PRE_PERSIST));
        }
        if ((postPersistMethod = listener.getPostPersistMethod()) != null) {
            Method callbackMethod = EntityBinding.findCallbackMethod(listenerClass, postPersistMethod);
            callbackDefinitions.add(EntityBinding.createCallbackDefinition(listenerClass, callbackMethod, style, CallbackType.POST_PERSIST));
        }
        if ((preUpdateMethod = listener.getPreUpdateMethod()) != null) {
            Method callbackMethod = EntityBinding.findCallbackMethod(listenerClass, preUpdateMethod);
            callbackDefinitions.add(EntityBinding.createCallbackDefinition(listenerClass, callbackMethod, style, CallbackType.PRE_UPDATE));
        }
        if ((postUpdateMethod = listener.getPostUpdateMethod()) != null) {
            Method callbackMethod = EntityBinding.findCallbackMethod(listenerClass, postUpdateMethod);
            callbackDefinitions.add(EntityBinding.createCallbackDefinition(listenerClass, callbackMethod, style, CallbackType.POST_UPDATE));
        }
        if ((preRemoveMethod = listener.getPreRemoveMethod()) != null) {
            Method callbackMethod = EntityBinding.findCallbackMethod(listenerClass, preRemoveMethod);
            callbackDefinitions.add(EntityBinding.createCallbackDefinition(listenerClass, callbackMethod, style, CallbackType.PRE_REMOVE));
        }
        if ((postRemoveMethod = listener.getPostRemoveMethod()) != null) {
            Method callbackMethod = EntityBinding.findCallbackMethod(listenerClass, postRemoveMethod);
            callbackDefinitions.add(EntityBinding.createCallbackDefinition(listenerClass, callbackMethod, style, CallbackType.POST_REMOVE));
        }
        if ((postLoadMethod = listener.getPostLoadMethod()) != null) {
            Method callbackMethod = EntityBinding.findCallbackMethod(listenerClass, postLoadMethod);
            callbackDefinitions.add(EntityBinding.createCallbackDefinition(listenerClass, callbackMethod, style, CallbackType.POST_LOAD));
        }
        persistentClass.addCallbackDefinitions(callbackDefinitions);
    }

    private static CallbackDefinition createCallbackDefinition(Class<?> listenerClass, Method callbackMethod, JpaEventListenerStyle style, CallbackType callbackType) {
        CallbackDefinition callback = style == JpaEventListenerStyle.CALLBACK ? new EntityCallback.Definition(callbackMethod, callbackType) : new ListenerCallback.Definition(listenerClass, callbackMethod, callbackType);
        return callback;
    }

    private static void processListenerCallbacks(JpaEventListener listener, EntityTypeMetadata typeMetadata, PersistentClass persistentClass) {
        Class listenerClass = listener.getCallbackClass().toJavaClass();
        EntityBinding.processJpaEventCallbacks(listenerClass, listener, JpaEventListenerStyle.LISTENER, typeMetadata.getClassDetails().toJavaClass(), typeMetadata, persistentClass);
    }

    private static Method findCallbackMethod(Class<?> callbackTarget, MethodDetails callbackMethod) {
        try {
            if (callbackMethod.getArgumentTypes().isEmpty()) {
                return callbackTarget.getDeclaredMethod(callbackMethod.getName(), new Class[0]);
            }
            ClassDetails argClassDetails = (ClassDetails)callbackMethod.getArgumentTypes().get(0);
            return callbackTarget.getMethod(callbackMethod.getName(), argClassDetails.toJavaClass());
        }
        catch (NoSuchMethodException e) {
            ModelsException modelsException = new ModelsException(String.format(Locale.ROOT, "Unable to locate callback method - %s.%s", callbackTarget.getName(), callbackMethod.getName()));
            modelsException.addSuppressed((Throwable)e);
            throw modelsException;
        }
    }

    private static void applyBatchSize(EntityTypeMetadata typeMetadata, PersistentClass persistentClass, BindingState bindingState) {
        AnnotationUsage batchSizeAnnotation = typeMetadata.getClassDetails().getAnnotationUsage(HibernateAnnotations.BATCH_SIZE);
        if (batchSizeAnnotation == null) {
            return;
        }
        persistentClass.setBatchSize(batchSizeAnnotation.getInteger("size"));
    }

    private static void applySqlCustomizations(EntityTypeMetadata typeMetadata, PersistentClass persistentClass, BindingState bindingState) {
        AnnotationUsage dynamicInsert = typeMetadata.getClassDetails().getAnnotationUsage(HibernateAnnotations.DYNAMIC_INSERT);
        AnnotationUsage dynamicUpdate = typeMetadata.getClassDetails().getAnnotationUsage(HibernateAnnotations.DYNAMIC_UPDATE);
        List customInserts = typeMetadata.getClassDetails().getRepeatedAnnotationUsages(HibernateAnnotations.SQL_INSERT);
        List customUpdates = typeMetadata.getClassDetails().getRepeatedAnnotationUsages(HibernateAnnotations.SQL_UPDATE);
        List customDeletes = typeMetadata.getClassDetails().getRepeatedAnnotationUsages(HibernateAnnotations.SQL_DELETE);
        if (dynamicInsert != null) {
            if (CollectionHelper.isNotEmpty(customInserts)) {
                ModelBindingLogging.MODEL_BINDING_MSG_LOGGER.dynamicAndCustomInsert(persistentClass.getEntityName());
            }
            persistentClass.setDynamicInsert(dynamicInsert.getBoolean("value"));
        }
        if (dynamicUpdate != null) {
            if (CollectionHelper.isNotEmpty(customUpdates)) {
                ModelBindingLogging.MODEL_BINDING_MSG_LOGGER.dynamicAndCustomUpdate(persistentClass.getEntityName());
            }
            persistentClass.setDynamicUpdate(dynamicUpdate.getBoolean("value"));
        }
        if (CollectionHelper.isNotEmpty(customInserts) || CollectionHelper.isNotEmpty(customUpdates) || CollectionHelper.isNotEmpty(customDeletes)) {
            Map<String, Join> joinMap = EntityBinding.extractJoinMap(persistentClass);
            EntityBinding.applyCustomSql(customInserts, persistentClass, joinMap, PersistentClass::setCustomSQLInsert, Join::setCustomSQLInsert);
            EntityBinding.applyCustomSql(customUpdates, persistentClass, joinMap, PersistentClass::setCustomSQLUpdate, Join::setCustomSQLUpdate);
            EntityBinding.applyCustomSql(customDeletes, persistentClass, joinMap, PersistentClass::setCustomSQLDelete, Join::setCustomSQLDelete);
        }
    }

    private static Map<String, Join> extractJoinMap(PersistentClass persistentClass) {
        List<Join> joins = persistentClass.getJoins();
        if (CollectionHelper.isEmpty(joins)) {
            return Collections.emptyMap();
        }
        HashMap<String, Join> joinMap = CollectionHelper.mapOfSize(joins.size());
        joins.forEach(join -> joinMap.put(join.getTable().getName(), (Join)join));
        return joinMap;
    }

    private static <A extends Annotation> void applyCustomSql(List<AnnotationUsage<A>> annotationUsages, PersistentClass persistentClass, Map<String, Join> joinMap, PrimaryCustomSqlInjector primaryTableInjector, SecondaryCustomSqlInjector secondaryTableInjector) {
        if (CollectionHelper.isEmpty(annotationUsages)) {
            return;
        }
        annotationUsages.forEach(annotationUsage -> {
            String tableName = annotationUsage.getString("table");
            if (StringHelper.isEmpty(tableName)) {
                primaryTableInjector.injectCustomSql(persistentClass, annotationUsage.getString("sql"), annotationUsage.getBoolean("callable"), ExecuteUpdateResultCheckStyle.fromResultCheckStyle((ResultCheckStyle)annotationUsage.getEnum("", ResultCheckStyle.class)));
            } else {
                Join join = (Join)joinMap.get(tableName);
                secondaryTableInjector.injectCustomSql(join, annotationUsage.getString("sql"), annotationUsage.getBoolean("callable"), ExecuteUpdateResultCheckStyle.fromResultCheckStyle((ResultCheckStyle)annotationUsage.getEnum("", ResultCheckStyle.class)));
            }
        });
    }

    public abstract RootEntityBinding getRootEntityBinding();

    private static void applySynchronizedTableNames(EntityTypeMetadata typeMetadata, PersistentClass persistentClass, BindingState bindingState) {
        AnnotationUsage usage = typeMetadata.getClassDetails().getAnnotationUsage(HibernateAnnotations.SYNCHRONIZE);
        if (usage == null) {
            return;
        }
        List names = usage.getList("value");
        names.forEach(persistentClass::addSynchronizedTable);
    }

    protected void prepareSubclassBindings() {
        this.getTypeMetadata().forEachSubType(subType -> {
            if (subType instanceof EntityTypeMetadata) {
                EntityTypeMetadata entityTypeMetadata = (EntityTypeMetadata)subType;
                new SubclassEntityBinding(entityTypeMetadata, (IdentifiableTypeBinding)this, EntityHierarchy.HierarchyRelation.SUB, this.bindingOptions, this.bindingState, this.bindingContext);
            } else {
                new MappedSuperclassBinding((MappedSuperclassTypeMetadata)subType, (IdentifiableTypeBinding)this, EntityHierarchy.HierarchyRelation.SUB, this.bindingOptions, this.bindingState, this.bindingContext);
            }
        });
    }

    @Override
    protected boolean excludeAttributeFromPreparation(AttributeMetadata attributeMetadata) {
        EntityHierarchy hierarchy = this.getTypeMetadata().getHierarchy();
        if (hierarchy.getIdMapping().contains(attributeMetadata) || hierarchy.getVersionAttribute() == attributeMetadata || hierarchy.getTenantIdAttribute() == attributeMetadata) {
            return true;
        }
        return super.excludeAttributeFromPreparation(attributeMetadata);
    }

    @Override
    protected AttributeBinding createAttributeBinding(AttributeMetadata attributeMetadata, Table primaryTable) {
        return new AttributeBinding(attributeMetadata, this.getPersistentClass(), primaryTable, this.bindingOptions, this.bindingState, this.bindingContext);
    }

    @FunctionalInterface
    private static interface PrimaryCustomSqlInjector {
        public void injectCustomSql(PersistentClass var1, String var2, boolean var3, ExecuteUpdateResultCheckStyle var4);
    }

    @FunctionalInterface
    private static interface SecondaryCustomSqlInjector {
        public void injectCustomSql(Join var1, String var2, boolean var3, ExecuteUpdateResultCheckStyle var4);
    }
}

