/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import jakarta.persistence.ForeignKey;
import jakarta.persistence.PrimaryKeyJoinColumn;
import java.util.List;
import java.util.Locale;
import org.hibernate.MappingException;
import org.hibernate.boot.models.bind.internal.ColumnHelper;
import org.hibernate.boot.models.bind.internal.ResolutionCallback;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;

public record JoinedSubclassKeyHandler(ClassDetails subclassDetails, JoinedSubclass subclass, MetadataBuildingContext buildingContext) implements ResolutionCallback<KeyValue>
{
    @Override
    public boolean handleResolution(KeyValue targetKeyValue) {
        List pkJoinColumns = this.subclassDetails.getRepeatedAnnotationUsages(PrimaryKeyJoinColumn.class);
        DependantValue fkValue = new DependantValue(this.buildingContext, this.subclass.getTable(), targetKeyValue);
        if (CollectionHelper.isEmpty(pkJoinColumns)) {
            this.handleImplicitJoinColumns(targetKeyValue, fkValue);
        } else {
            this.handleExplicitJoinColumns(pkJoinColumns, targetKeyValue, fkValue);
        }
        AnnotationUsage fkAnn = this.subclassDetails.getAnnotationUsage(ForeignKey.class);
        String foreignKeyName = fkAnn == null ? "" : fkAnn.getString("name");
        String foreignKeyDefinition = fkAnn == null ? "" : fkAnn.getString("foreignKeyDefinition");
        org.hibernate.mapping.ForeignKey foreignKey = this.subclass.getTable().createForeignKey(foreignKeyName, fkValue.getColumns(), this.subclass.getRootClass().getEntityName(), foreignKeyDefinition, targetKeyValue.getColumns());
        foreignKey.setReferencedTable(this.subclass.getRootTable());
        return true;
    }

    private void handleImplicitJoinColumns(KeyValue targetKeyValue, DependantValue fkValue) {
        targetKeyValue.getColumns().forEach(column -> {
            Column fkColumn = column.clone();
            this.subclass.getTable().getPrimaryKey().addColumn(fkColumn);
            fkValue.addColumn(fkColumn);
        });
    }

    private void handleExplicitJoinColumns(List<AnnotationUsage<PrimaryKeyJoinColumn>> pkJoinColumns, KeyValue targetKeyValue, DependantValue fkValue) {
        for (int i = 0; i < targetKeyValue.getColumnSpan(); ++i) {
            Column targetColumn = targetKeyValue.getColumns().get(i);
            AnnotationUsage<PrimaryKeyJoinColumn> joinColumnAnn = this.resolveMatchingJoinColumnAnn(targetColumn, pkJoinColumns, i);
            Column keyColumn = ColumnHelper.bindColumn(joinColumnAnn, targetColumn::getName, true, false);
            this.subclass().getTable().getPrimaryKey().addColumn(keyColumn);
            fkValue.addColumn(keyColumn);
        }
    }

    private AnnotationUsage<PrimaryKeyJoinColumn> resolveMatchingJoinColumnAnn(Column targetPkColumn, List<AnnotationUsage<PrimaryKeyJoinColumn>> keyJoinColumns, int pkColumnPosition) {
        for (int j = 0; j < keyJoinColumns.size(); ++j) {
            AnnotationUsage<PrimaryKeyJoinColumn> keyJoinColumn = keyJoinColumns.get(j);
            String name = keyJoinColumn.getString("name");
            String referencedColumnName = keyJoinColumn.getString("referencedColumnName");
            if (StringHelper.isEmpty(name) && StringHelper.isEmpty(referencedColumnName)) {
                if (j != pkColumnPosition) continue;
                return keyJoinColumn;
            }
            if (StringHelper.isNotEmpty(referencedColumnName)) {
                if (!targetPkColumn.getName().equals(referencedColumnName)) continue;
                return keyJoinColumn;
            }
            assert (StringHelper.isNotEmpty(name));
            if (!targetPkColumn.getName().equals(name)) continue;
            return keyJoinColumn;
        }
        throw new MappingException(String.format(Locale.ROOT, "Unable to match primary key column [%s] to any PrimaryKeyJoinColumn - %s", targetPkColumn.getName(), this.subclass().getEntityName()));
    }
}

