/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.bind.internal;

import java.util.Iterator;
import java.util.List;
import org.hibernate.boot.models.bind.ModelBindingLogging;
import org.hibernate.boot.models.bind.internal.ResolutionCallback;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.ModelsException;

public class ObservableHelper {
    public static <T> void processCallbacks(T resolvedInstance, List<? extends ResolutionCallback<T>> callbacks) {
        ObservableHelper.processCallbacks(resolvedInstance, callbacks, false);
    }

    public static <T> void processCallbacks(T resolvedInstance, List<? extends ResolutionCallback<T>> callbacks, boolean allowUnresolved) {
        if (CollectionHelper.isEmpty(callbacks)) {
            return;
        }
        int processedCount = 0;
        Iterator<ResolutionCallback<T>> secondPassItr = callbacks.iterator();
        while (secondPassItr.hasNext()) {
            ResolutionCallback<T> callback = secondPassItr.next();
            try {
                boolean success = callback.handleResolution(resolvedInstance);
                if (!success) continue;
                ++processedCount;
                secondPassItr.remove();
            }
            catch (Exception e) {
                ModelBindingLogging.MODEL_BINDING_LOGGER.debug((Object)"Error processing second pass", (Throwable)e);
            }
        }
        if (!callbacks.isEmpty()) {
            if (processedCount == 0 && !allowUnresolved) {
                throw new ModelsException("Unable to process second-pass list");
            }
            ObservableHelper.processCallbacks(resolvedInstance, callbacks);
        }
    }
}

