/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import jakarta.persistence.AccessType;
import java.util.EnumSet;
import org.hibernate.annotations.TenantId;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.MultipleAttributeNaturesException;
import org.hibernate.boot.models.categorize.ModelCategorizationLogging;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.boot.models.categorize.spi.ClassAttributeAccessType;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;

public class CategorizationHelper {
    public static boolean isMappedSuperclass(ClassDetails classDetails) {
        return classDetails.getAnnotationUsage(JpaAnnotations.MAPPED_SUPERCLASS) != null;
    }

    public static boolean isEntity(ClassDetails classDetails) {
        return classDetails.getAnnotationUsage(JpaAnnotations.ENTITY) != null;
    }

    public static boolean isIdentifiable(ClassDetails classDetails) {
        return CategorizationHelper.isEntity(classDetails) || CategorizationHelper.isMappedSuperclass(classDetails);
    }

    public static ClassAttributeAccessType determineAccessType(ClassDetails classDetails, AccessType implicitAccessType) {
        AnnotationUsage annotation = classDetails.getAnnotationUsage(JpaAnnotations.ACCESS);
        if (annotation != null) {
            AccessType explicitValue = (AccessType)annotation.getAttributeValue("value");
            assert (explicitValue != null);
            return explicitValue == AccessType.FIELD ? ClassAttributeAccessType.EXPLICIT_FIELD : ClassAttributeAccessType.EXPLICIT_PROPERTY;
        }
        return implicitAccessType == AccessType.FIELD ? ClassAttributeAccessType.IMPLICIT_FIELD : ClassAttributeAccessType.IMPLICIT_PROPERTY;
    }

    public static AttributeMetadata.AttributeNature determineAttributeNature(ClassDetails declarer, MemberDetails backingMember) {
        boolean implicitlyAny;
        EnumSet<AttributeMetadata.AttributeNature> natures = EnumSet.noneOf(AttributeMetadata.AttributeNature.class);
        AnnotationUsage any = backingMember.getAnnotationUsage(HibernateAnnotations.ANY);
        AnnotationUsage basic = backingMember.getAnnotationUsage(JpaAnnotations.BASIC);
        AnnotationUsage elementCollection = backingMember.getAnnotationUsage(JpaAnnotations.ELEMENT_COLLECTION);
        AnnotationUsage embedded = backingMember.getAnnotationUsage(JpaAnnotations.EMBEDDED);
        AnnotationUsage embeddedId = backingMember.getAnnotationUsage(JpaAnnotations.EMBEDDED_ID);
        AnnotationUsage manyToAny = backingMember.getAnnotationUsage(HibernateAnnotations.MANY_TO_ANY);
        AnnotationUsage manyToMany = backingMember.getAnnotationUsage(JpaAnnotations.MANY_TO_MANY);
        AnnotationUsage manyToOne = backingMember.getAnnotationUsage(JpaAnnotations.MANY_TO_ONE);
        AnnotationUsage oneToMany = backingMember.getAnnotationUsage(JpaAnnotations.ONE_TO_MANY);
        AnnotationUsage oneToOne = backingMember.getAnnotationUsage(JpaAnnotations.ONE_TO_ONE);
        if (basic != null) {
            natures.add(AttributeMetadata.AttributeNature.BASIC);
        }
        if (embedded != null || embeddedId != null || backingMember.getType() != null && backingMember.getType().determineRawClass().getAnnotationUsage(JpaAnnotations.EMBEDDABLE) != null) {
            natures.add(AttributeMetadata.AttributeNature.EMBEDDED);
        }
        if (any != null) {
            natures.add(AttributeMetadata.AttributeNature.ANY);
        }
        if (oneToOne != null || manyToOne != null) {
            natures.add(AttributeMetadata.AttributeNature.TO_ONE);
        }
        if (elementCollection != null) {
            natures.add(AttributeMetadata.AttributeNature.ELEMENT_COLLECTION);
        }
        if (oneToMany != null) {
            natures.add(AttributeMetadata.AttributeNature.ONE_TO_MANY);
        }
        if (manyToMany != null) {
            natures.add(AttributeMetadata.AttributeNature.MANY_TO_MANY);
        }
        if (manyToAny != null) {
            natures.add(AttributeMetadata.AttributeNature.MANY_TO_ANY);
        }
        boolean plural = oneToMany != null || manyToMany != null || elementCollection != null || manyToAny != null;
        boolean implicitlyBasic = backingMember.getAnnotationUsage(JpaAnnotations.TEMPORAL) != null || backingMember.getAnnotationUsage(JpaAnnotations.LOB) != null || backingMember.getAnnotationUsage(JpaAnnotations.ENUMERATED) != null || backingMember.getAnnotationUsage(JpaAnnotations.VERSION) != null || backingMember.getAnnotationUsage(HibernateAnnotations.GENERATED) != null || backingMember.getAnnotationUsage(HibernateAnnotations.NATIONALIZED) != null || backingMember.getAnnotationUsage(HibernateAnnotations.TZ_COLUMN) != null || backingMember.getAnnotationUsage(HibernateAnnotations.TZ_STORAGE) != null || backingMember.getAnnotationUsage(HibernateAnnotations.TYPE) != null || backingMember.getAnnotationUsage(TenantId.class) != null || backingMember.getAnnotationUsage(HibernateAnnotations.JAVA_TYPE) != null || backingMember.getAnnotationUsage(HibernateAnnotations.JDBC_TYPE_CODE) != null || backingMember.getAnnotationUsage(HibernateAnnotations.JDBC_TYPE) != null;
        boolean implicitlyEmbedded = backingMember.getAnnotationUsage(HibernateAnnotations.EMBEDDABLE_INSTANTIATOR) != null || backingMember.getAnnotationUsage(HibernateAnnotations.COMPOSITE_TYPE) != null;
        boolean bl = implicitlyAny = backingMember.getAnnotationUsage(HibernateAnnotations.ANY_DISCRIMINATOR) != null || CollectionHelper.isNotEmpty(backingMember.getRepeatedAnnotationUsages(HibernateAnnotations.ANY_DISCRIMINATOR_VALUE)) || backingMember.getAnnotationUsage(HibernateAnnotations.ANY_DISCRIMINATOR_VALUES) != null || backingMember.getAnnotationUsage(HibernateAnnotations.ANY_KEY_JAVA_TYPE) != null || backingMember.getAnnotationUsage(HibernateAnnotations.ANY_KEY_JAVA_CLASS) != null || backingMember.getAnnotationUsage(HibernateAnnotations.ANY_KEY_JDBC_TYPE) != null || backingMember.getAnnotationUsage(HibernateAnnotations.ANY_KEY_JDBC_TYPE_CODE) != null;
        if (!plural) {
            if (implicitlyBasic) {
                natures.add(AttributeMetadata.AttributeNature.BASIC);
            }
            if (implicitlyEmbedded) {
                natures.add(AttributeMetadata.AttributeNature.EMBEDDED);
            }
            if (implicitlyAny) {
                natures.add(AttributeMetadata.AttributeNature.ANY);
            }
        } else if (elementCollection != null) {
            if (natures.contains((Object)AttributeMetadata.AttributeNature.BASIC)) {
                if (!natures.contains((Object)AttributeMetadata.AttributeNature.EMBEDDED)) {
                    ModelCategorizationLogging.MODEL_CATEGORIZATION_LOGGER.debugf("Ignoring @Basic on @ElementCollection - %s", (Object)backingMember.resolveAttributeName());
                    natures.remove((Object)AttributeMetadata.AttributeNature.BASIC);
                }
            } else if (natures.contains((Object)AttributeMetadata.AttributeNature.EMBEDDED)) {
                ModelCategorizationLogging.MODEL_CATEGORIZATION_LOGGER.debugf("Ignoring @Embedded on @ElementCollection - %s", (Object)backingMember.resolveAttributeName());
                natures.remove((Object)AttributeMetadata.AttributeNature.EMBEDDED);
            }
        }
        int size = natures.size();
        return switch (size) {
            case 0 -> {
                ModelCategorizationLogging.MODEL_CATEGORIZATION_LOGGER.debugf("Implicitly interpreting attribute `%s` as BASIC", (Object)backingMember.resolveAttributeName());
                yield AttributeMetadata.AttributeNature.BASIC;
            }
            case 1 -> (AttributeMetadata.AttributeNature)((Object)natures.iterator().next());
            default -> throw new MultipleAttributeNaturesException(declarer.getName() + "#" + backingMember.resolveAttributeName(), natures);
        };
    }
}

