/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import jakarta.persistence.AccessType;
import jakarta.persistence.Cacheable;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Entity;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.ResultCheckStyle;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLInsert;
import org.hibernate.annotations.SQLUpdate;
import org.hibernate.annotations.SelectBeforeUpdate;
import org.hibernate.annotations.Synchronize;
import org.hibernate.boot.model.CustomSql;
import org.hibernate.boot.model.naming.EntityNaming;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.categorize.internal.AbstractIdentifiableTypeMetadata;
import org.hibernate.boot.models.categorize.internal.HierarchyTypeConsumer;
import org.hibernate.boot.models.categorize.internal.LifecycleCallbackCollector;
import org.hibernate.boot.models.categorize.spi.AttributeMetadata;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.EntityTypeMetadata;
import org.hibernate.boot.models.categorize.spi.JpaEventListener;
import org.hibernate.boot.models.categorize.spi.ModelCategorizationContext;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;

public class EntityTypeMetadataImpl
extends AbstractIdentifiableTypeMetadata
implements EntityTypeMetadata,
EntityNaming {
    private final String entityName = this.getClassDetails().getName();
    private final String jpaEntityName;
    private final List<AttributeMetadata> attributeList;
    private final boolean mutable;
    private final boolean cacheable;
    private final boolean isLazy;
    private final String proxy;
    private final int batchSize;
    private final String discriminatorMatchValue;
    private final boolean isSelectBeforeUpdate;
    private final boolean isDynamicInsert;
    private final boolean isDynamicUpdate;
    private final Map<String, CustomSql> customInsertMap;
    private final Map<String, CustomSql> customUpdateMap;
    private final Map<String, CustomSql> customDeleteMap;
    private final String[] synchronizedTableNames;
    private List<JpaEventListener> hierarchyEventListeners;
    private List<JpaEventListener> completeEventListeners;

    public EntityTypeMetadataImpl(ClassDetails classDetails, EntityHierarchy hierarchy, AccessType defaultAccessType, HierarchyTypeConsumer typeConsumer, ModelCategorizationContext modelContext) {
        super(classDetails, hierarchy, null, defaultAccessType, modelContext);
        AnnotationUsage entityAnnotation = classDetails.getAnnotationUsage(JpaAnnotations.ENTITY);
        this.jpaEntityName = this.determineJpaEntityName((AnnotationUsage<Entity>)entityAnnotation, this.entityName);
        LifecycleCallbackCollector lifecycleCallbackCollector = new LifecycleCallbackCollector(classDetails, modelContext);
        this.attributeList = this.resolveAttributes(lifecycleCallbackCollector);
        this.hierarchyEventListeners = this.collectHierarchyEventListeners(lifecycleCallbackCollector.resolve());
        this.completeEventListeners = this.collectCompleteEventListeners(modelContext);
        this.mutable = this.determineMutability(classDetails, modelContext);
        this.cacheable = this.determineCacheability(classDetails, modelContext);
        this.synchronizedTableNames = this.determineSynchronizedTableNames();
        this.batchSize = this.determineBatchSize();
        this.isSelectBeforeUpdate = this.decodeSelectBeforeUpdate();
        this.isDynamicInsert = this.decodeDynamicInsert();
        this.isDynamicUpdate = this.decodeDynamicUpdate();
        this.customInsertMap = EntityTypeMetadataImpl.extractCustomSql(classDetails, SQLInsert.class);
        this.customUpdateMap = EntityTypeMetadataImpl.extractCustomSql(classDetails, SQLUpdate.class);
        this.customDeleteMap = EntityTypeMetadataImpl.extractCustomSql(classDetails, SQLDelete.class);
        AnnotationUsage proxyAnnotation = classDetails.getAnnotationUsage(Proxy.class);
        if (proxyAnnotation != null) {
            ClassDetails proxyClassDetails;
            Boolean lazyValue = (Boolean)proxyAnnotation.getAttributeValue("lazy");
            boolean bl = this.isLazy = lazyValue == null || lazyValue != false;
            this.proxy = this.isLazy ? ((proxyClassDetails = (ClassDetails)proxyAnnotation.getAttributeValue("proxyClass")) != null ? proxyClassDetails.getName() : null) : null;
        } else {
            this.isLazy = true;
            this.proxy = this.getEntityName();
        }
        AnnotationUsage discriminatorValueAnn = classDetails.getAnnotationUsage(DiscriminatorValue.class);
        this.discriminatorMatchValue = discriminatorValueAnn != null ? (String)discriminatorValueAnn.getAttributeValue("value") : null;
        this.postInstantiate(true, typeConsumer);
    }

    public EntityTypeMetadataImpl(ClassDetails classDetails, EntityHierarchy hierarchy, AbstractIdentifiableTypeMetadata superType, HierarchyTypeConsumer typeConsumer, ModelCategorizationContext modelContext) {
        super(classDetails, hierarchy, superType, modelContext);
        AnnotationUsage entityAnnotation = classDetails.getAnnotationUsage(JpaAnnotations.ENTITY);
        this.jpaEntityName = this.determineJpaEntityName((AnnotationUsage<Entity>)entityAnnotation, this.entityName);
        LifecycleCallbackCollector lifecycleCallbackCollector = new LifecycleCallbackCollector(classDetails, modelContext);
        this.attributeList = this.resolveAttributes(lifecycleCallbackCollector);
        this.hierarchyEventListeners = this.collectHierarchyEventListeners(lifecycleCallbackCollector.resolve());
        this.completeEventListeners = this.collectCompleteEventListeners(modelContext);
        this.mutable = this.determineMutability(classDetails, modelContext);
        this.cacheable = this.determineCacheability(classDetails, modelContext);
        this.synchronizedTableNames = this.determineSynchronizedTableNames();
        this.batchSize = this.determineBatchSize();
        this.isSelectBeforeUpdate = this.decodeSelectBeforeUpdate();
        this.isDynamicInsert = this.decodeDynamicInsert();
        this.isDynamicUpdate = this.decodeDynamicUpdate();
        this.customInsertMap = EntityTypeMetadataImpl.extractCustomSql(classDetails, SQLInsert.class);
        this.customUpdateMap = EntityTypeMetadataImpl.extractCustomSql(classDetails, SQLUpdate.class);
        this.customDeleteMap = EntityTypeMetadataImpl.extractCustomSql(classDetails, SQLDelete.class);
        AnnotationUsage proxyAnnotation = classDetails.getAnnotationUsage(Proxy.class);
        if (proxyAnnotation != null) {
            ClassDetails proxyClassDetails;
            Boolean lazyValue = (Boolean)proxyAnnotation.getAttributeValue("lazy");
            boolean bl = this.isLazy = lazyValue == null || lazyValue != false;
            this.proxy = this.isLazy ? ((proxyClassDetails = (ClassDetails)proxyAnnotation.getAttributeValue("proxyClass")) != null ? proxyClassDetails.getName() : null) : null;
        } else {
            this.isLazy = true;
            this.proxy = this.getEntityName();
        }
        AnnotationUsage discriminatorValueAnn = classDetails.getAnnotationUsage(DiscriminatorValue.class);
        this.discriminatorMatchValue = discriminatorValueAnn != null ? (String)discriminatorValueAnn.getAttributeValue("value") : null;
        this.postInstantiate(true, typeConsumer);
    }

    @Override
    protected List<AttributeMetadata> attributeList() {
        return this.attributeList;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public String getJpaEntityName() {
        return this.jpaEntityName;
    }

    @Override
    public String getClassName() {
        return this.getClassDetails().getClassName();
    }

    @Override
    public boolean isMutable() {
        return this.mutable;
    }

    @Override
    public boolean isCacheable() {
        return this.cacheable;
    }

    @Override
    public String[] getSynchronizedTableNames() {
        return this.synchronizedTableNames;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public boolean isSelectBeforeUpdate() {
        return this.isSelectBeforeUpdate;
    }

    @Override
    public boolean isDynamicInsert() {
        return this.isDynamicInsert;
    }

    @Override
    public boolean isDynamicUpdate() {
        return this.isDynamicUpdate;
    }

    @Override
    public Map<String, CustomSql> getCustomInserts() {
        return this.customInsertMap;
    }

    @Override
    public Map<String, CustomSql> getCustomUpdates() {
        return this.customUpdateMap;
    }

    @Override
    public Map<String, CustomSql> getCustomDeletes() {
        return this.customDeleteMap;
    }

    public String getDiscriminatorMatchValue() {
        return this.discriminatorMatchValue;
    }

    public boolean isLazy() {
        return this.isLazy;
    }

    public String getProxy() {
        return this.proxy;
    }

    @Override
    public List<JpaEventListener> getHierarchyJpaEventListeners() {
        return this.hierarchyEventListeners;
    }

    @Override
    public List<JpaEventListener> getCompleteJpaEventListeners() {
        return this.completeEventListeners;
    }

    private String determineJpaEntityName(AnnotationUsage<Entity> entityAnnotation, String entityName) {
        String name = (String)entityAnnotation.getAttributeValue("name");
        if (StringHelper.isNotEmpty(name)) {
            return name;
        }
        return StringHelper.unqualify(entityName);
    }

    private boolean determineMutability(ClassDetails classDetails, ModelCategorizationContext modelContext) {
        AnnotationUsage immutableAnn = classDetails.getAnnotationUsage(Immutable.class);
        return immutableAnn == null;
    }

    private boolean determineCacheability(ClassDetails classDetails, ModelCategorizationContext modelContext) {
        AnnotationUsage cacheableAnn = classDetails.getAnnotationUsage(Cacheable.class);
        switch (modelContext.getSharedCacheMode()) {
            case NONE: {
                return false;
            }
            case ALL: {
                return true;
            }
            case DISABLE_SELECTIVE: {
                return cacheableAnn == null || cacheableAnn.getBoolean("value") != false;
            }
        }
        return cacheableAnn != null && cacheableAnn.getBoolean("value") != false;
    }

    public static <A extends Annotation> Map<String, CustomSql> extractCustomSql(ClassDetails classDetails, Class<A> annotationType) {
        List annotationUsages = classDetails.getRepeatedAnnotationUsages(annotationType);
        if (CollectionHelper.isEmpty(annotationUsages)) {
            return Collections.emptyMap();
        }
        HashMap<String, CustomSql> result = new HashMap<String, CustomSql>();
        annotationUsages.forEach(customSqlAnnotation -> {
            String sql = (String)customSqlAnnotation.getAttributeValue("sql");
            boolean isCallable = (Boolean)customSqlAnnotation.getAttributeValue("callable");
            ResultCheckStyle checkValue = (ResultCheckStyle)((Object)((Object)customSqlAnnotation.getAttributeValue("check")));
            ExecuteUpdateResultCheckStyle checkStyle = checkValue == null ? (isCallable ? ExecuteUpdateResultCheckStyle.NONE : ExecuteUpdateResultCheckStyle.COUNT) : ExecuteUpdateResultCheckStyle.fromResultCheckStyle(checkValue);
            result.put(customSqlAnnotation.getString("table"), new CustomSql(sql, isCallable, checkStyle));
        });
        return result;
    }

    private String[] determineSynchronizedTableNames() {
        AnnotationUsage synchronizeAnnotation = this.getClassDetails().getAnnotationUsage(Synchronize.class);
        if (synchronizeAnnotation != null) {
            return synchronizeAnnotation.getList("value").toArray(new String[0]);
        }
        return StringHelper.EMPTY_STRINGS;
    }

    private int determineBatchSize() {
        AnnotationUsage batchSizeAnnotation = this.getClassDetails().getAnnotationUsage(BatchSize.class);
        if (batchSizeAnnotation != null) {
            return (Integer)batchSizeAnnotation.getAttributeValue("size");
        }
        return -1;
    }

    private boolean decodeSelectBeforeUpdate() {
        AnnotationUsage selectBeforeUpdateAnnotation = this.getClassDetails().getAnnotationUsage(SelectBeforeUpdate.class);
        if (selectBeforeUpdateAnnotation == null) {
            return false;
        }
        return selectBeforeUpdateAnnotation.getBoolean("value");
    }

    private boolean decodeDynamicInsert() {
        AnnotationUsage dynamicInsertAnnotation = this.getClassDetails().getAnnotationUsage(DynamicInsert.class);
        if (dynamicInsertAnnotation == null) {
            return false;
        }
        return dynamicInsertAnnotation.getBoolean("value");
    }

    private boolean decodeDynamicUpdate() {
        AnnotationUsage dynamicUpdateAnnotation = this.getClassDetails().getAnnotationUsage(DynamicUpdate.class);
        if (dynamicUpdateAnnotation == null) {
            return false;
        }
        return dynamicUpdateAnnotation.getBoolean("value");
    }
}

