/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import jakarta.persistence.EntityResult;
import jakarta.persistence.NamedNativeQuery;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.QueryHint;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.StoredProcedureParameter;
import jakarta.persistence.TableGenerator;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Imported;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionUserTypeRegistrationImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCompositeUserTypeRegistrationImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConfigurationParameterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConstructorResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConverterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConverterRegistrationImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableInstantiatorRegistrationImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityListenerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFieldResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFilterDefImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbGenericIdGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJavaTypeRegistrationImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJdbcTypeRegistrationImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedNativeQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedQueryBase;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedStoredProcedureQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbQueryHint;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSequenceGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSqlResultSetMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbStoredProcedureParameterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTableGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUserTypeRegistrationImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.categorize.spi.CollectionTypeRegistration;
import org.hibernate.boot.models.categorize.spi.CompositeUserTypeRegistration;
import org.hibernate.boot.models.categorize.spi.ConversionRegistration;
import org.hibernate.boot.models.categorize.spi.ConverterRegistration;
import org.hibernate.boot.models.categorize.spi.EmbeddableInstantiatorRegistration;
import org.hibernate.boot.models.categorize.spi.FilterDefRegistration;
import org.hibernate.boot.models.categorize.spi.GenericGeneratorRegistration;
import org.hibernate.boot.models.categorize.spi.GlobalRegistrations;
import org.hibernate.boot.models.categorize.spi.JavaTypeRegistration;
import org.hibernate.boot.models.categorize.spi.JdbcTypeRegistration;
import org.hibernate.boot.models.categorize.spi.JpaEventListener;
import org.hibernate.boot.models.categorize.spi.JpaEventListenerStyle;
import org.hibernate.boot.models.categorize.spi.NamedNativeQueryRegistration;
import org.hibernate.boot.models.categorize.spi.NamedQueryRegistration;
import org.hibernate.boot.models.categorize.spi.NamedStoredProcedureQueryRegistration;
import org.hibernate.boot.models.categorize.spi.SequenceGeneratorRegistration;
import org.hibernate.boot.models.categorize.spi.SqlResultSetMappingRegistration;
import org.hibernate.boot.models.categorize.spi.TableGeneratorRegistration;
import org.hibernate.boot.models.categorize.spi.UserTypeRegistration;
import org.hibernate.boot.models.internal.AnnotationUsageHelper;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class GlobalRegistrationsImpl
implements GlobalRegistrations {
    private final SourceModelBuildingContext sourceModelContext;
    private final BootstrapContext bootstrapContext;
    private List<JpaEventListener> jpaEventListeners;
    private List<ConversionRegistration> converterRegistrations;
    private List<JavaTypeRegistration> javaTypeRegistrations;
    private List<JdbcTypeRegistration> jdbcTypeRegistrations;
    private List<UserTypeRegistration> userTypeRegistrations;
    private List<CompositeUserTypeRegistration> compositeUserTypeRegistrations;
    private List<CollectionTypeRegistration> collectionTypeRegistrations;
    private List<EmbeddableInstantiatorRegistration> embeddableInstantiatorRegistrations;
    private Map<String, FilterDefRegistration> filterDefRegistrations;
    private Map<String, String> importedRenameMap;
    private Map<String, SequenceGeneratorRegistration> sequenceGeneratorRegistrations;
    private Map<String, TableGeneratorRegistration> tableGeneratorRegistrations;
    private Map<String, GenericGeneratorRegistration> genericGeneratorRegistrations;
    private Set<ConverterRegistration> jpaConverters;
    private Map<String, SqlResultSetMappingRegistration> sqlResultSetMappingRegistrations;
    private Map<String, NamedQueryRegistration> namedQueryRegistrations;
    private Map<String, NamedNativeQueryRegistration> namedNativeQueryRegistrations;
    private Map<String, NamedStoredProcedureQueryRegistration> namedStoredProcedureQueryRegistrations;

    public GlobalRegistrationsImpl(SourceModelBuildingContext sourceModelContext, BootstrapContext bootstrapContext) {
        this.sourceModelContext = sourceModelContext;
        this.bootstrapContext = bootstrapContext;
    }

    @Override
    public List<JpaEventListener> getEntityListenerRegistrations() {
        return this.jpaEventListeners == null ? Collections.emptyList() : this.jpaEventListeners;
    }

    @Override
    public List<ConversionRegistration> getConverterRegistrations() {
        return this.converterRegistrations == null ? Collections.emptyList() : this.converterRegistrations;
    }

    @Override
    public List<JavaTypeRegistration> getJavaTypeRegistrations() {
        return this.javaTypeRegistrations == null ? Collections.emptyList() : this.javaTypeRegistrations;
    }

    @Override
    public List<JdbcTypeRegistration> getJdbcTypeRegistrations() {
        return this.jdbcTypeRegistrations == null ? Collections.emptyList() : this.jdbcTypeRegistrations;
    }

    @Override
    public List<UserTypeRegistration> getUserTypeRegistrations() {
        return this.userTypeRegistrations == null ? Collections.emptyList() : this.userTypeRegistrations;
    }

    @Override
    public List<CompositeUserTypeRegistration> getCompositeUserTypeRegistrations() {
        return this.compositeUserTypeRegistrations == null ? Collections.emptyList() : this.compositeUserTypeRegistrations;
    }

    @Override
    public List<CollectionTypeRegistration> getCollectionTypeRegistrations() {
        return this.collectionTypeRegistrations == null ? Collections.emptyList() : this.collectionTypeRegistrations;
    }

    @Override
    public List<EmbeddableInstantiatorRegistration> getEmbeddableInstantiatorRegistrations() {
        return this.embeddableInstantiatorRegistrations == null ? Collections.emptyList() : this.embeddableInstantiatorRegistrations;
    }

    @Override
    public Map<String, FilterDefRegistration> getFilterDefRegistrations() {
        return this.filterDefRegistrations == null ? Collections.emptyMap() : this.filterDefRegistrations;
    }

    @Override
    public Map<String, String> getImportedRenames() {
        return this.importedRenameMap == null ? Collections.emptyMap() : this.importedRenameMap;
    }

    @Override
    public Map<String, SequenceGeneratorRegistration> getSequenceGeneratorRegistrations() {
        return this.sequenceGeneratorRegistrations == null ? Collections.emptyMap() : this.sequenceGeneratorRegistrations;
    }

    @Override
    public Map<String, TableGeneratorRegistration> getTableGeneratorRegistrations() {
        return this.tableGeneratorRegistrations == null ? Collections.emptyMap() : this.tableGeneratorRegistrations;
    }

    @Override
    public Map<String, GenericGeneratorRegistration> getGenericGeneratorRegistrations() {
        return this.genericGeneratorRegistrations == null ? Collections.emptyMap() : this.genericGeneratorRegistrations;
    }

    @Override
    public Set<ConverterRegistration> getJpaConverters() {
        return this.jpaConverters == null ? Collections.emptySet() : this.jpaConverters;
    }

    @Override
    public Map<String, SqlResultSetMappingRegistration> getSqlResultSetMappingRegistrations() {
        return this.sqlResultSetMappingRegistrations == null ? Collections.emptyMap() : this.sqlResultSetMappingRegistrations;
    }

    @Override
    public Map<String, NamedQueryRegistration> getNamedQueryRegistrations() {
        return this.namedQueryRegistrations == null ? Collections.emptyMap() : this.namedQueryRegistrations;
    }

    @Override
    public Map<String, NamedNativeQueryRegistration> getNamedNativeQueryRegistrations() {
        return this.namedNativeQueryRegistrations == null ? Collections.emptyMap() : this.namedNativeQueryRegistrations;
    }

    @Override
    public Map<String, NamedStoredProcedureQueryRegistration> getNamedStoredProcedureQueryRegistrations() {
        return this.namedStoredProcedureQueryRegistrations == null ? Collections.emptyMap() : this.namedStoredProcedureQueryRegistrations;
    }

    public void collectJavaTypeRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.JAVA_TYPE_REG, usage -> this.collectJavaTypeRegistration((ClassDetails)usage.getAttributeValue("javaType"), (ClassDetails)usage.getAttributeValue("descriptorClass")));
    }

    public void collectJavaTypeRegistrations(List<JaxbJavaTypeRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(reg -> this.collectJavaTypeRegistration(this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(reg.getClazz()), this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(reg.getDescriptor())));
    }

    public void collectJavaTypeRegistration(ClassDetails javaType, ClassDetails descriptor) {
        this.collectJavaTypeRegistration(new JavaTypeRegistration(javaType, descriptor));
    }

    public void collectJavaTypeRegistration(JavaTypeRegistration registration) {
        if (this.javaTypeRegistrations == null) {
            this.javaTypeRegistrations = new ArrayList<JavaTypeRegistration>();
        }
        this.javaTypeRegistrations.add(registration);
    }

    public void collectJdbcTypeRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.JDBC_TYPE_REG, usage -> this.collectJdbcTypeRegistration((Integer)usage.getAttributeValue("registrationCode"), (ClassDetails)usage.getAttributeValue("value")));
    }

    public void collectJdbcTypeRegistrations(List<JaxbJdbcTypeRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(reg -> this.collectJdbcTypeRegistration(reg.getCode(), this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(reg.getDescriptor())));
    }

    public void collectJdbcTypeRegistration(Integer registrationCode, ClassDetails descriptor) {
        if (this.jdbcTypeRegistrations == null) {
            this.jdbcTypeRegistrations = new ArrayList<JdbcTypeRegistration>();
        }
        this.jdbcTypeRegistrations.add(new JdbcTypeRegistration(registrationCode, descriptor));
    }

    public void collectConverterRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.CONVERTER_REG, usage -> {
            ClassDetails domainType = (ClassDetails)usage.getAttributeValue("domainType");
            ClassDetails converterType = (ClassDetails)usage.getAttributeValue("converter");
            boolean autoApply = (Boolean)usage.getAttributeValue("autoApply");
            this.collectConverterRegistration(new ConversionRegistration(domainType, converterType, autoApply, HibernateAnnotations.CONVERTER_REG));
        });
    }

    public void collectConverterRegistrations(List<JaxbConverterRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(registration -> {
            String explicitDomainTypeName = registration.getClazz();
            ClassDetails explicitDomainType = StringHelper.isNotEmpty(explicitDomainTypeName) ? this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(explicitDomainTypeName) : null;
            ClassDetails converterType = this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(registration.getConverter());
            boolean autoApply = registration.isAutoApply();
            this.collectConverterRegistration(new ConversionRegistration(explicitDomainType, converterType, autoApply, HibernateAnnotations.CONVERTER_REG));
        });
    }

    public void collectConverterRegistration(ConversionRegistration conversion) {
        if (this.converterRegistrations == null) {
            this.converterRegistrations = new ArrayList<ConversionRegistration>();
        }
        this.converterRegistrations.add(conversion);
    }

    public void collectUserTypeRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.TYPE_REG, usage -> this.collectUserTypeRegistration((ClassDetails)usage.getAttributeValue("basicClass"), (ClassDetails)usage.getAttributeValue("userType")));
    }

    public void collectUserTypeRegistrations(List<JaxbUserTypeRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(reg -> {
            ClassDetails domainTypeDetails = this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(reg.getClazz());
            ClassDetails descriptorDetails = this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(reg.getDescriptor());
            this.collectUserTypeRegistration(domainTypeDetails, descriptorDetails);
        });
    }

    public void collectUserTypeRegistration(ClassDetails domainClass, ClassDetails userTypeClass) {
        if (this.userTypeRegistrations == null) {
            this.userTypeRegistrations = new ArrayList<UserTypeRegistration>();
        }
        this.userTypeRegistrations.add(new UserTypeRegistration(domainClass, userTypeClass));
    }

    public void collectCompositeUserTypeRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.COMPOSITE_TYPE_REG, usage -> this.collectCompositeUserTypeRegistration((ClassDetails)usage.getAttributeValue("embeddableClass"), (ClassDetails)usage.getAttributeValue("userType")));
    }

    public void collectCompositeUserTypeRegistrations(List<JaxbCompositeUserTypeRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(reg -> this.collectCompositeUserTypeRegistration(this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(reg.getClazz()), this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(reg.getDescriptor())));
    }

    public void collectCompositeUserTypeRegistration(ClassDetails domainClass, ClassDetails userTypeClass) {
        if (this.compositeUserTypeRegistrations == null) {
            this.compositeUserTypeRegistrations = new ArrayList<CompositeUserTypeRegistration>();
        }
        this.compositeUserTypeRegistrations.add(new CompositeUserTypeRegistration(domainClass, userTypeClass));
    }

    public void collectCollectionTypeRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.COLLECTION_TYPE_REG, usage -> this.collectCollectionTypeRegistration((CollectionClassification)((Object)((Object)usage.getAttributeValue("classification"))), (ClassDetails)usage.getAttributeValue("type"), this.extractParameterMap((AnnotationUsage<? extends Annotation>)usage)));
    }

    private Map<String, String> extractParameterMap(AnnotationUsage<? extends Annotation> source) {
        List parameters = (List)source.getAttributeValue("parameters");
        HashMap<String, String> result = new HashMap<String, String>();
        for (AnnotationUsage parameter : parameters) {
            result.put((String)parameter.getAttributeValue("name"), (String)parameter.getAttributeValue("value"));
        }
        return result;
    }

    public void collectCollectionTypeRegistrations(List<JaxbCollectionUserTypeRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(reg -> this.collectCollectionTypeRegistration(reg.getClassification(), this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(reg.getDescriptor()), this.extractParameterMap(reg.getParameters())));
    }

    private Map<String, String> extractParameterMap(List<JaxbConfigurationParameterImpl> parameters) {
        if (CollectionHelper.isEmpty(parameters)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        parameters.forEach(parameter -> result.put(parameter.getName(), parameter.getValue()));
        return result;
    }

    public void collectCollectionTypeRegistration(CollectionClassification classification, ClassDetails userTypeClass, Map<String, String> parameters) {
        if (this.collectionTypeRegistrations == null) {
            this.collectionTypeRegistrations = new ArrayList<CollectionTypeRegistration>();
        }
        this.collectionTypeRegistrations.add(new CollectionTypeRegistration(classification, userTypeClass, parameters));
    }

    public void collectEmbeddableInstantiatorRegistrations(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.EMBEDDABLE_INSTANTIATOR_REG, usage -> this.collectEmbeddableInstantiatorRegistration((ClassDetails)usage.getAttributeValue("embeddableClass"), (ClassDetails)usage.getAttributeValue("instantiator")));
    }

    public void collectEmbeddableInstantiatorRegistrations(List<JaxbEmbeddableInstantiatorRegistrationImpl> registrations) {
        if (CollectionHelper.isEmpty(registrations)) {
            return;
        }
        registrations.forEach(reg -> this.collectEmbeddableInstantiatorRegistration(this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(reg.getEmbeddableClass()), this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(reg.getInstantiator())));
    }

    public void collectEmbeddableInstantiatorRegistration(ClassDetails embeddableClass, ClassDetails instantiator) {
        if (this.embeddableInstantiatorRegistrations == null) {
            this.embeddableInstantiatorRegistrations = new ArrayList<EmbeddableInstantiatorRegistration>();
        }
        this.embeddableInstantiatorRegistrations.add(new EmbeddableInstantiatorRegistration(embeddableClass, instantiator));
    }

    public void collectFilterDefinitions(AnnotationTarget annotationTarget) {
        annotationTarget.forEachAnnotationUsage(HibernateAnnotations.FILTER_DEF, usage -> {
            Map<String, ClassDetails> parameterResolvers;
            Map<String, ClassDetails> paramJdbcMappings;
            List parameters = usage.getList("parameters");
            if (CollectionHelper.isEmpty(parameters)) {
                paramJdbcMappings = Collections.emptyMap();
                parameterResolvers = Collections.emptyMap();
            } else {
                paramJdbcMappings = new HashMap();
                parameterResolvers = new HashMap();
                for (AnnotationUsage parameter : parameters) {
                    paramJdbcMappings.put(parameter.getString("name"), parameter.getClassDetails("type"));
                    ClassDetails resolverClassDetails = parameter.getClassDetails("resolver");
                    if (resolverClassDetails.getName().equals(Supplier.class.getName())) continue;
                    parameterResolvers.put(parameter.getString("name"), resolverClassDetails);
                }
            }
            this.collectFilterDefinition(usage.getString("name"), usage.getString("defaultCondition"), usage.getBoolean("autoEnabled"), paramJdbcMappings, parameterResolvers);
        });
    }

    private Map<String, ClassDetails> extractFilterParameters(AnnotationUsage<FilterDef> source) {
        List parameters = (List)source.getAttributeValue("parameters");
        if (CollectionHelper.isEmpty(parameters)) {
            return null;
        }
        HashMap<String, ClassDetails> result = new HashMap<String, ClassDetails>(parameters.size());
        for (AnnotationUsage parameter : parameters) {
            result.put((String)parameter.getAttributeValue("name"), (ClassDetails)parameter.getAttributeValue("type"));
        }
        return result;
    }

    public void collectFilterDefinitions(List<JaxbFilterDefImpl> filterDefinitions) {
        if (CollectionHelper.isEmpty(filterDefinitions)) {
            return;
        }
        filterDefinitions.forEach(filterDefinition -> {
            Map<String, ClassDetails> parameterResolvers;
            Map<String, ClassDetails> paramJdbcMappings;
            List<JaxbFilterDefImpl.JaxbFilterParamImpl> jaxbParameters = filterDefinition.getFilterParams();
            if (jaxbParameters.isEmpty()) {
                paramJdbcMappings = Collections.emptyMap();
                parameterResolvers = Collections.emptyMap();
            } else {
                paramJdbcMappings = new HashMap();
                parameterResolvers = new HashMap();
                for (JaxbFilterDefImpl.JaxbFilterParamImpl jaxbParameter : jaxbParameters) {
                    ClassDetails targetClassDetails = XmlAnnotationHelper.resolveJavaType(jaxbParameter.getType(), this.sourceModelContext.getClassDetailsRegistry());
                    paramJdbcMappings.put(jaxbParameter.getName(), targetClassDetails);
                    if (!StringHelper.isNotEmpty(jaxbParameter.getResolver())) continue;
                    ClassDetails resolverClassDetails = XmlAnnotationHelper.resolveJavaType(jaxbParameter.getType(), this.sourceModelContext.getClassDetailsRegistry());
                    parameterResolvers.put(jaxbParameter.getName(), resolverClassDetails);
                }
            }
            this.collectFilterDefinition(filterDefinition.getName(), filterDefinition.getDefaultCondition(), filterDefinition.isAutoEnabled(), paramJdbcMappings, parameterResolvers);
        });
    }

    public void collectFilterDefinition(String name, String defaultCondition, boolean autoEnabled, Map<String, ClassDetails> parameterTypes, Map<String, ClassDetails> parameterResolvers) {
        FilterDefRegistration previousEntry;
        if (this.filterDefRegistrations == null) {
            this.filterDefRegistrations = new HashMap<String, FilterDefRegistration>();
        }
        if ((previousEntry = this.filterDefRegistrations.put(name, new FilterDefRegistration(name, defaultCondition, autoEnabled, parameterTypes, parameterResolvers))) != null) {
            // empty if block
        }
    }

    public void collectImportRename(ClassDetails classDetails) {
        AnnotationUsage importedUsage = classDetails.getAnnotationUsage(Imported.class);
        if (importedUsage == null) {
            return;
        }
        String explicitRename = importedUsage.getString("rename");
        String rename = StringHelper.isNotEmpty(explicitRename) ? explicitRename : StringHelper.unqualify(classDetails.getName());
        this.collectImportRename(rename, classDetails.getName());
    }

    public void collectImportRename(String rename, String name) {
        if (this.importedRenameMap == null) {
            this.importedRenameMap = new HashMap<String, String>();
        }
        this.importedRenameMap.put(rename, name);
    }

    public void collectEntityListenerRegistrations(List<JaxbEntityListenerImpl> listeners, SourceModelBuildingContext modelsContext) {
        if (CollectionHelper.isEmpty(listeners)) {
            return;
        }
        listeners.forEach(jaxbEntityListener -> {
            ClassDetails classDetails = this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(jaxbEntityListener.getClazz());
            JpaEventListener listener = JpaEventListener.from(JpaEventListenerStyle.LISTENER, classDetails, jaxbEntityListener, modelsContext);
            this.addJpaEventListener(listener);
        });
    }

    public void addJpaEventListener(JpaEventListener listener) {
        if (this.jpaEventListeners == null) {
            this.jpaEventListeners = new ArrayList<JpaEventListener>();
        }
        this.jpaEventListeners.add(listener);
    }

    public void collectIdGenerators(JaxbEntityMappingsImpl jaxbRoot) {
        this.collectSequenceGenerators(jaxbRoot.getSequenceGenerators());
        this.collectTableGenerators(jaxbRoot.getTableGenerators());
        this.collectGenericGenerators(jaxbRoot.getGenericGenerators());
    }

    public void collectIdGenerators(ClassDetails classDetails) {
        classDetails.forEachAnnotationUsage(SequenceGenerator.class, this::collectSequenceGenerator);
        classDetails.forEachAnnotationUsage(TableGenerator.class, this::collectTableGenerator);
        classDetails.forEachAnnotationUsage(GenericGenerator.class, this::collectGenericGenerator);
    }

    public void collectSequenceGenerators(List<JaxbSequenceGeneratorImpl> sequenceGenerators) {
        if (CollectionHelper.isEmpty(sequenceGenerators)) {
            return;
        }
        sequenceGenerators.forEach(generator -> {
            MutableAnnotationUsage<SequenceGenerator> annotationUsage = this.makeAnnotation(JpaAnnotations.SEQUENCE_GENERATOR);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("name", generator.getName(), annotationUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("sequenceName", generator.getSequenceName(), annotationUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("catalog", generator.getCatalog(), annotationUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("schema", generator.getSchema(), annotationUsage);
            AnnotationUsageHelper.applyAttributeIfSpecified("initialValue", generator.getInitialValue(), annotationUsage);
            AnnotationUsageHelper.applyAttributeIfSpecified("allocationSize", generator.getAllocationSize(), annotationUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("options", generator.getOptions(), annotationUsage);
            this.collectSequenceGenerator(new SequenceGeneratorRegistration(generator.getName(), (AnnotationUsage<SequenceGenerator>)annotationUsage));
        });
    }

    private <A extends Annotation> MutableAnnotationUsage<A> makeAnnotation(AnnotationDescriptor<A> annotationDescriptor) {
        return annotationDescriptor.createUsage(this.sourceModelContext);
    }

    public void collectSequenceGenerator(AnnotationUsage<SequenceGenerator> usage) {
        this.collectSequenceGenerator(new SequenceGeneratorRegistration((String)usage.getAttributeValue("name"), usage));
    }

    public void collectSequenceGenerator(SequenceGeneratorRegistration generatorRegistration) {
        this.checkGeneratorName(generatorRegistration.name());
        if (this.sequenceGeneratorRegistrations == null) {
            this.sequenceGeneratorRegistrations = new HashMap<String, SequenceGeneratorRegistration>();
        }
        this.sequenceGeneratorRegistrations.put(generatorRegistration.name(), generatorRegistration);
    }

    private void checkGeneratorName(String name) {
        this.checkGeneratorName(name, this.sequenceGeneratorRegistrations);
        this.checkGeneratorName(name, this.tableGeneratorRegistrations);
        this.checkGeneratorName(name, this.genericGeneratorRegistrations);
    }

    private void checkGeneratorName(String name, Map<String, ?> generatorMap) {
        if (generatorMap == null) {
            return;
        }
        if (generatorMap.containsKey(name)) {
            if (this.bootstrapContext.getJpaCompliance().isGlobalGeneratorScopeEnabled()) {
                throw new IllegalArgumentException("Duplicate generator name " + name + "; you will likely want to set the property hibernate.jpa.compliance.global_id_generators to false ");
            }
            CoreLogging.messageLogger(GlobalRegistrationsImpl.class).duplicateGeneratorName(name);
        }
    }

    public void collectTableGenerators(List<JaxbTableGeneratorImpl> tableGenerators) {
        if (CollectionHelper.isEmpty(tableGenerators)) {
            return;
        }
        tableGenerators.forEach(generator -> {
            MutableAnnotationUsage<TableGenerator> annotationUsage = this.makeAnnotation(JpaAnnotations.TABLE_GENERATOR);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("name", generator.getName(), annotationUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("table", generator.getTable(), annotationUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("catalog", generator.getCatalog(), annotationUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("schema", generator.getSchema(), annotationUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("pkColumnName", generator.getPkColumnName(), annotationUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("valueColumnName", generator.getValueColumnName(), annotationUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("pkColumnValue", generator.getPkColumnValue(), annotationUsage);
            AnnotationUsageHelper.applyAttributeIfSpecified("initialValue", generator.getInitialValue(), annotationUsage);
            AnnotationUsageHelper.applyAttributeIfSpecified("allocationSize", generator.getAllocationSize(), annotationUsage);
            AnnotationUsageHelper.applyAttributeIfSpecified("uniqueConstraints", generator.getUniqueConstraints(), annotationUsage);
            AnnotationUsageHelper.applyAttributeIfSpecified("indexes", generator.getIndexes(), annotationUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("options", generator.getOptions(), annotationUsage);
            this.collectTableGenerator(new TableGeneratorRegistration(generator.getName(), (AnnotationUsage<TableGenerator>)annotationUsage));
        });
    }

    public void collectTableGenerator(AnnotationUsage<TableGenerator> usage) {
        this.collectTableGenerator(new TableGeneratorRegistration((String)usage.getAttributeValue("name"), usage));
    }

    public void collectTableGenerator(TableGeneratorRegistration generatorRegistration) {
        this.checkGeneratorName(generatorRegistration.name());
        if (this.tableGeneratorRegistrations == null) {
            this.tableGeneratorRegistrations = new HashMap<String, TableGeneratorRegistration>();
        }
        this.tableGeneratorRegistrations.put(generatorRegistration.name(), generatorRegistration);
    }

    private void collectGenericGenerators(List<JaxbGenericIdGeneratorImpl> genericGenerators) {
        if (CollectionHelper.isEmpty(genericGenerators)) {
            return;
        }
        genericGenerators.forEach(generator -> {
            MutableAnnotationUsage<GenericGenerator> annotationUsage = this.makeAnnotation(HibernateAnnotations.GENERIC_GENERATOR);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("name", generator.getName(), annotationUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("strategy", generator.getClazz(), annotationUsage);
            AnnotationUsageHelper.applyAttributeIfSpecified("parameters", generator.getParameters(), annotationUsage);
            this.collectGenericGenerator(new GenericGeneratorRegistration(generator.getName(), (AnnotationUsage<GenericGenerator>)annotationUsage));
        });
    }

    public void collectGenericGenerator(AnnotationUsage<GenericGenerator> usage) {
        this.collectGenericGenerator(new GenericGeneratorRegistration((String)usage.getAttributeValue("name"), usage));
    }

    public void collectGenericGenerator(GenericGeneratorRegistration generatorRegistration) {
        this.checkGeneratorName(generatorRegistration.name());
        if (this.genericGeneratorRegistrations == null) {
            this.genericGeneratorRegistrations = new HashMap<String, GenericGeneratorRegistration>();
        }
        this.genericGeneratorRegistrations.put(generatorRegistration.name(), generatorRegistration);
    }

    public void collectConverter(ClassDetails converterClassDetails) {
        if (this.jpaConverters == null) {
            this.jpaConverters = new HashSet<ConverterRegistration>();
        }
        this.jpaConverters.add(new ConverterRegistration(converterClassDetails, null));
    }

    public void collectConverters(List<JaxbConverterImpl> converters) {
        if (CollectionHelper.isEmpty(converters)) {
            return;
        }
        if (this.jpaConverters == null) {
            this.jpaConverters = CollectionHelper.setOfSize(converters.size());
        }
        converters.forEach(jaxbConverter -> {
            String converterClassName = jaxbConverter.getClazz();
            assert (converterClassName != null);
            ClassDetails converterType = this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(converterClassName);
            boolean autoApply = jaxbConverter.isAutoApply();
            this.jpaConverters.add(new ConverterRegistration(converterType, autoApply));
        });
    }

    public void collectQueryReferences(JaxbEntityMappingsImpl jaxbRoot) {
        this.collectNamedSqlResultSetMappings(jaxbRoot.getSqlResultSetMappings());
        this.collectNamedQueries(jaxbRoot.getNamedQueries());
        this.collectNamedNativeQueries(jaxbRoot.getNamedNativeQueries());
        this.collectStoredProcedureQueries(jaxbRoot.getNamedProcedureQueries());
    }

    private void collectNamedSqlResultSetMappings(List<JaxbSqlResultSetMappingImpl> jaxbSqlResultSetMappings) {
        if (CollectionHelper.isEmpty(jaxbSqlResultSetMappings)) {
            return;
        }
        if (this.sqlResultSetMappingRegistrations == null) {
            this.sqlResultSetMappingRegistrations = new HashMap<String, SqlResultSetMappingRegistration>();
        }
        jaxbSqlResultSetMappings.forEach(jaxbMapping -> {
            MutableAnnotationUsage mappingAnnotation = JpaAnnotations.SQL_RESULT_SET_MAPPING.createUsage(this.sourceModelContext);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("name", jaxbMapping.getName(), mappingAnnotation);
            this.sqlResultSetMappingRegistrations.put(jaxbMapping.getName(), new SqlResultSetMappingRegistration(jaxbMapping.getName(), (AnnotationUsage<SqlResultSetMapping>)mappingAnnotation));
            this.applyEntityResults(jaxbMapping.getEntityResult(), results -> AnnotationUsageHelper.applyAttributeIfSpecified("entities", results, mappingAnnotation));
            this.applyConstructorResults(jaxbMapping.getConstructorResult(), results -> AnnotationUsageHelper.applyAttributeIfSpecified("classes", results, mappingAnnotation));
            this.applyColumnResults(jaxbMapping.getColumnResult(), columnResults -> AnnotationUsageHelper.applyAttributeIfSpecified("columns", columnResults, mappingAnnotation));
        });
    }

    private void applyEntityResults(List<JaxbEntityResultImpl> jaxbEntityResults, Consumer<List<AnnotationUsage<EntityResult>>> annotationListConsumer) {
        if (jaxbEntityResults.isEmpty()) {
            return;
        }
        ArrayList entityResults = CollectionHelper.arrayList(jaxbEntityResults.size());
        for (JaxbEntityResultImpl jaxbEntityResult : jaxbEntityResults) {
            MutableAnnotationUsage<EntityResult> entityResultAnnotation = this.makeAnnotation(JpaAnnotations.ENTITY_RESULT);
            entityResults.add(entityResultAnnotation);
            entityResultAnnotation.setAttributeValue("entityClass", (Object)this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(jaxbEntityResult.getEntityClass()));
            AnnotationUsageHelper.applyAttributeIfSpecified("lockMode", jaxbEntityResult.getLockMode(), entityResultAnnotation);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("discriminatorColumn", jaxbEntityResult.getDiscriminatorColumn(), entityResultAnnotation);
            if (jaxbEntityResult.getFieldResult().isEmpty()) continue;
            ArrayList fieldResults = CollectionHelper.arrayList(jaxbEntityResult.getFieldResult().size());
            entityResultAnnotation.setAttributeValue("fields", fieldResults);
            for (JaxbFieldResultImpl jaxbFieldResult : jaxbEntityResult.getFieldResult()) {
                MutableAnnotationUsage fieldResultAnnotation = JpaAnnotations.FIELD_RESULT.createUsage(this.sourceModelContext);
                fieldResults.add(fieldResultAnnotation);
                fieldResultAnnotation.setAttributeValue("name", (Object)jaxbFieldResult.getName());
                fieldResultAnnotation.setAttributeValue("column", (Object)jaxbFieldResult.getColumn());
            }
        }
        annotationListConsumer.accept(entityResults);
    }

    private void applyConstructorResults(List<JaxbConstructorResultImpl> jaxbConstructorResults, Consumer<List<AnnotationUsage<ConstructorResult>>> annotationListConsumer) {
        if (CollectionHelper.isEmpty(jaxbConstructorResults)) {
            return;
        }
        ArrayList results = CollectionHelper.arrayList(jaxbConstructorResults.size());
        for (JaxbConstructorResultImpl jaxbConstructorResult : jaxbConstructorResults) {
            MutableAnnotationUsage<ConstructorResult> result = this.makeAnnotation(JpaAnnotations.CONSTRUCTOR_RESULT);
            results.add(result);
            result.setAttributeValue("targetClass", (Object)this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(jaxbConstructorResult.getTargetClass()));
            if (jaxbConstructorResult.getColumns().isEmpty()) continue;
            this.applyColumnResults(jaxbConstructorResult.getColumns(), columnResults -> result.setAttributeValue("columns", columnResults));
        }
        annotationListConsumer.accept(results);
    }

    private void applyColumnResults(List<JaxbColumnResultImpl> jaxbColumnResults, Consumer<List<AnnotationUsage<ColumnResult>>> annotationListConsumer) {
        if (CollectionHelper.isEmpty(jaxbColumnResults)) {
            return;
        }
        ArrayList columnResults = CollectionHelper.arrayList(jaxbColumnResults.size());
        for (JaxbColumnResultImpl jaxbColumn : jaxbColumnResults) {
            MutableAnnotationUsage<ColumnResult> columnResultAnnotation = this.makeAnnotation(JpaAnnotations.COLUMN_RESULT);
            columnResults.add(columnResultAnnotation);
            columnResultAnnotation.setAttributeValue("name", (Object)jaxbColumn.getName());
            AnnotationUsageHelper.applyAttributeIfSpecified("type", this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(jaxbColumn.getClazz()), columnResultAnnotation);
        }
        annotationListConsumer.accept(columnResults);
    }

    private void collectNamedQueries(List<JaxbNamedQueryImpl> jaxbNamedQueries) {
        if (CollectionHelper.isEmpty(jaxbNamedQueries)) {
            return;
        }
        if (this.namedQueryRegistrations == null) {
            this.namedQueryRegistrations = new HashMap<String, NamedQueryRegistration>();
        }
        for (JaxbNamedQueryImpl jaxbNamedQuery : jaxbNamedQueries) {
            MutableAnnotationUsage<QueryHint> hint;
            MutableAnnotationUsage<NamedQuery> queryAnnotation = this.makeAnnotation(JpaAnnotations.NAMED_QUERY);
            this.namedQueryRegistrations.put(jaxbNamedQuery.getName(), new NamedQueryRegistration(jaxbNamedQuery.getName(), (AnnotationUsage<NamedQuery>)queryAnnotation));
            AnnotationUsageHelper.applyStringAttributeIfSpecified("name", jaxbNamedQuery.getName(), queryAnnotation);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("query", jaxbNamedQuery.getQuery(), queryAnnotation);
            AnnotationUsageHelper.applyAttributeIfSpecified("lockMode", jaxbNamedQuery.getLockMode(), queryAnnotation);
            List<AnnotationUsage<QueryHint>> hints = this.extractQueryHints(jaxbNamedQuery);
            AnnotationUsageHelper.applyAttributeIfSpecified("hints", hints, queryAnnotation);
            if (jaxbNamedQuery.isCacheable() == Boolean.TRUE) {
                MutableAnnotationUsage<QueryHint> hint2;
                MutableAnnotationUsage<QueryHint> cacheableHint = this.makeAnnotation(JpaAnnotations.QUERY_HINT);
                cacheableHint.setAttributeValue("name", (Object)"org.hibernate.cacheable");
                cacheableHint.setAttributeValue("value", (Object)Boolean.TRUE.toString());
                hints.add((AnnotationUsage<QueryHint>)cacheableHint);
                if (jaxbNamedQuery.getCacheMode() != null) {
                    hint2 = this.makeAnnotation(JpaAnnotations.QUERY_HINT);
                    hint2.setAttributeValue("name", (Object)"org.hibernate.cacheMode");
                    hint2.setAttributeValue("value", (Object)jaxbNamedQuery.getCacheMode().name());
                    hints.add((AnnotationUsage<QueryHint>)hint2);
                }
                if (StringHelper.isNotEmpty(jaxbNamedQuery.getCacheRegion())) {
                    hint2 = this.makeAnnotation(JpaAnnotations.QUERY_HINT);
                    hint2.setAttributeValue("name", (Object)"org.hibernate.cacheRegion");
                    hint2.setAttributeValue("value", (Object)jaxbNamedQuery.getCacheRegion());
                    hints.add((AnnotationUsage<QueryHint>)hint2);
                }
            }
            if (StringHelper.isNotEmpty(jaxbNamedQuery.getComment())) {
                hint = this.makeAnnotation(JpaAnnotations.QUERY_HINT);
                hint.setAttributeValue("name", (Object)"org.hibernate.comment");
                hint.setAttributeValue("value", (Object)jaxbNamedQuery.getComment());
                hints.add((AnnotationUsage<QueryHint>)hint);
            }
            if (jaxbNamedQuery.getFetchSize() != null) {
                hint = this.makeAnnotation(JpaAnnotations.QUERY_HINT);
                hint.setAttributeValue("name", (Object)"org.hibernate.fetchSize");
                hint.setAttributeValue("value", (Object)jaxbNamedQuery.getFetchSize().toString());
                hints.add((AnnotationUsage<QueryHint>)hint);
            }
            if (jaxbNamedQuery.isReadOnly() == Boolean.TRUE) {
                hint = this.makeAnnotation(JpaAnnotations.QUERY_HINT);
                hint.setAttributeValue("name", (Object)"org.hibernate.readOnly");
                hint.setAttributeValue("value", (Object)Boolean.TRUE.toString());
                hints.add((AnnotationUsage<QueryHint>)hint);
            }
            if (jaxbNamedQuery.getFlushMode() == null) continue;
            hint = this.makeAnnotation(JpaAnnotations.QUERY_HINT);
            hint.setAttributeValue("name", (Object)"org.hibernate.flushMode");
            hint.setAttributeValue("value", (Object)jaxbNamedQuery.getFlushMode().name());
            hints.add((AnnotationUsage<QueryHint>)hint);
        }
    }

    private void collectNamedNativeQueries(List<JaxbNamedNativeQueryImpl> namedNativeQueries) {
        if (CollectionHelper.isEmpty(namedNativeQueries)) {
            return;
        }
        if (this.namedNativeQueryRegistrations == null) {
            this.namedNativeQueryRegistrations = new HashMap<String, NamedNativeQueryRegistration>();
        }
        for (JaxbNamedNativeQueryImpl jaxbNamedQuery : namedNativeQueries) {
            MutableAnnotationUsage<QueryHint> hint;
            MutableAnnotationUsage<NamedNativeQuery> queryAnnotation = this.makeAnnotation(JpaAnnotations.NAMED_NATIVE_QUERY);
            this.namedNativeQueryRegistrations.put(jaxbNamedQuery.getName(), new NamedNativeQueryRegistration(jaxbNamedQuery.getName(), (AnnotationUsage<NamedNativeQuery>)queryAnnotation));
            queryAnnotation.setAttributeValue("name", (Object)jaxbNamedQuery.getName());
            queryAnnotation.setAttributeValue("query", (Object)jaxbNamedQuery.getQuery());
            if (StringHelper.isNotEmpty(jaxbNamedQuery.getResultClass())) {
                queryAnnotation.setAttributeValue("resultClass", (Object)this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(jaxbNamedQuery.getResultClass()));
            }
            AnnotationUsageHelper.applyStringAttributeIfSpecified("resultSetMapping", jaxbNamedQuery.getResultSetMapping(), queryAnnotation);
            this.applyEntityResults(jaxbNamedQuery.getEntityResult(), results -> queryAnnotation.setAttributeValue("entities", results));
            this.applyConstructorResults(jaxbNamedQuery.getConstructorResult(), results -> queryAnnotation.setAttributeValue("classes", results));
            this.applyColumnResults(jaxbNamedQuery.getColumnResult(), columnResults -> queryAnnotation.setAttributeValue("columns", columnResults));
            List<AnnotationUsage<QueryHint>> hints = this.extractQueryHints(jaxbNamedQuery);
            queryAnnotation.setAttributeValue("hints", hints);
            if (jaxbNamedQuery.isCacheable() == Boolean.TRUE) {
                MutableAnnotationUsage<QueryHint> hint2;
                MutableAnnotationUsage<QueryHint> cacheableHint = this.makeAnnotation(JpaAnnotations.QUERY_HINT);
                cacheableHint.setAttributeValue("name", (Object)"org.hibernate.cacheable");
                cacheableHint.setAttributeValue("value", (Object)Boolean.TRUE.toString());
                if (jaxbNamedQuery.getCacheMode() != null) {
                    hint2 = this.makeAnnotation(JpaAnnotations.QUERY_HINT);
                    hint2.setAttributeValue("name", (Object)"org.hibernate.cacheMode");
                    hint2.setAttributeValue("value", (Object)jaxbNamedQuery.getCacheMode().name());
                }
                if (StringHelper.isNotEmpty(jaxbNamedQuery.getCacheRegion())) {
                    hint2 = this.makeAnnotation(JpaAnnotations.QUERY_HINT);
                    hint2.setAttributeValue("name", (Object)"org.hibernate.cacheRegion");
                    hint2.setAttributeValue("value", (Object)jaxbNamedQuery.getCacheRegion());
                }
            }
            if (jaxbNamedQuery.isReadOnly() == Boolean.TRUE) {
                hint = this.makeAnnotation(JpaAnnotations.QUERY_HINT);
                hint.setAttributeValue("name", (Object)"org.hibernate.readOnly");
                hint.setAttributeValue("value", (Object)Boolean.TRUE.toString());
            }
            if (!StringHelper.isNotEmpty(jaxbNamedQuery.getComment())) continue;
            hint = this.makeAnnotation(JpaAnnotations.QUERY_HINT);
            hint.setAttributeValue("name", (Object)"org.hibernate.comment");
            hint.setAttributeValue("value", (Object)jaxbNamedQuery.getComment());
        }
    }

    private void collectStoredProcedureQueries(List<JaxbNamedStoredProcedureQueryImpl> namedProcedureQueries) {
        if (CollectionHelper.isEmpty(namedProcedureQueries)) {
            return;
        }
        if (this.namedStoredProcedureQueryRegistrations == null) {
            this.namedStoredProcedureQueryRegistrations = new HashMap<String, NamedStoredProcedureQueryRegistration>();
        }
        for (JaxbNamedStoredProcedureQueryImpl jaxbQuery : namedProcedureQueries) {
            MutableAnnotationUsage<NamedStoredProcedureQuery> queryAnnotation = this.makeAnnotation(JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY);
            this.namedStoredProcedureQueryRegistrations.put(jaxbQuery.getName(), new NamedStoredProcedureQueryRegistration(jaxbQuery.getName(), (AnnotationUsage<NamedStoredProcedureQuery>)queryAnnotation));
            queryAnnotation.setAttributeValue("name", (Object)jaxbQuery.getName());
            queryAnnotation.setAttributeValue("procedureName", (Object)jaxbQuery.getProcedureName());
            ArrayList resultClasses = CollectionHelper.arrayList(jaxbQuery.getResultClasses().size());
            AnnotationUsageHelper.applyAttributeIfSpecified("resultClasses", resultClasses, queryAnnotation);
            for (String resultClassName : jaxbQuery.getResultClasses()) {
                resultClasses.add(this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(resultClassName));
            }
            AnnotationUsageHelper.applyAttributeIfSpecified("resultSetMappings", jaxbQuery.getResultSetMappings(), queryAnnotation);
            AnnotationUsageHelper.applyAttributeIfSpecified("hints", this.extractQueryHints(jaxbQuery), queryAnnotation);
            ArrayList parameters = CollectionHelper.arrayList(jaxbQuery.getProcedureParameters().size());
            AnnotationUsageHelper.applyAttributeIfSpecified("parameters", parameters, queryAnnotation);
            for (JaxbStoredProcedureParameterImpl jaxbProcedureParameter : jaxbQuery.getProcedureParameters()) {
                MutableAnnotationUsage<StoredProcedureParameter> parameterAnnotation = this.makeAnnotation(JpaAnnotations.STORED_PROCEDURE_PARAMETER);
                parameters.add(parameterAnnotation);
                AnnotationUsageHelper.applyStringAttributeIfSpecified("name", jaxbProcedureParameter.getName(), parameterAnnotation);
                AnnotationUsageHelper.applyAttributeIfSpecified("mode", jaxbProcedureParameter.getMode(), parameterAnnotation);
                AnnotationUsageHelper.applyAttributeIfSpecified("type", this.sourceModelContext.getClassDetailsRegistry().resolveClassDetails(jaxbProcedureParameter.getClazz()), parameterAnnotation);
            }
        }
    }

    private List<AnnotationUsage<QueryHint>> extractQueryHints(JaxbNamedQueryBase jaxbQuery) {
        ArrayList<AnnotationUsage<QueryHint>> hints = new ArrayList<AnnotationUsage<QueryHint>>();
        for (JaxbQueryHint jaxbQueryHint : jaxbQuery.getHints()) {
            MutableAnnotationUsage<QueryHint> hint = this.makeAnnotation(JpaAnnotations.QUERY_HINT);
            hint.setAttributeValue("name", (Object)jaxbQueryHint.getName());
            hint.setAttributeValue("value", (Object)jaxbQueryHint.getValue());
        }
        return hints;
    }
}

