/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostRemove;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import java.lang.annotation.Annotation;
import java.util.Locale;
import org.hibernate.boot.models.categorize.spi.AllMemberConsumer;
import org.hibernate.boot.models.categorize.spi.JpaEventListener;
import org.hibernate.boot.models.categorize.spi.JpaEventListenerStyle;
import org.hibernate.boot.models.categorize.spi.ModelCategorizationContext;
import org.hibernate.models.ModelsException;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;

public class LifecycleCallbackCollector
implements AllMemberConsumer {
    private final ClassDetails managedTypeDetails;
    private final ModelCategorizationContext modelContext;
    private MethodDetails prePersist;
    private MethodDetails postPersist;
    private MethodDetails preUpdate;
    private MethodDetails postUpdate;
    private MethodDetails preRemove;
    private MethodDetails postRemove;
    private MethodDetails postLoad;

    public LifecycleCallbackCollector(ClassDetails managedTypeDetails, ModelCategorizationContext modelContext) {
        this.managedTypeDetails = managedTypeDetails;
        this.modelContext = modelContext;
    }

    @Override
    public void acceptMember(MemberDetails memberDetails) {
        if (memberDetails.isField()) {
            return;
        }
        MethodDetails methodDetails = (MethodDetails)memberDetails;
        if (methodDetails.getAnnotationUsage(PrePersist.class) != null && JpaEventListener.matchesSignature(JpaEventListenerStyle.CALLBACK, methodDetails)) {
            this.prePersist = LifecycleCallbackCollector.apply(methodDetails, PrePersist.class, this.managedTypeDetails, this.prePersist);
        } else if (methodDetails.getAnnotationUsage(PostPersist.class) != null && JpaEventListener.matchesSignature(JpaEventListenerStyle.CALLBACK, methodDetails)) {
            this.postPersist = LifecycleCallbackCollector.apply(methodDetails, PostPersist.class, this.managedTypeDetails, this.postPersist);
        } else if (methodDetails.getAnnotationUsage(PreRemove.class) != null && JpaEventListener.matchesSignature(JpaEventListenerStyle.CALLBACK, methodDetails)) {
            this.preRemove = LifecycleCallbackCollector.apply(methodDetails, PreRemove.class, this.managedTypeDetails, this.preRemove);
        } else if (methodDetails.getAnnotationUsage(PostRemove.class) != null && JpaEventListener.matchesSignature(JpaEventListenerStyle.CALLBACK, methodDetails)) {
            this.postRemove = LifecycleCallbackCollector.apply(methodDetails, PostRemove.class, this.managedTypeDetails, this.postRemove);
        } else if (methodDetails.getAnnotationUsage(PreUpdate.class) != null && JpaEventListener.matchesSignature(JpaEventListenerStyle.CALLBACK, methodDetails)) {
            this.preUpdate = LifecycleCallbackCollector.apply(methodDetails, PreUpdate.class, this.managedTypeDetails, this.preUpdate);
        } else if (methodDetails.getAnnotationUsage(PostUpdate.class) != null && JpaEventListener.matchesSignature(JpaEventListenerStyle.CALLBACK, methodDetails)) {
            this.postUpdate = LifecycleCallbackCollector.apply(methodDetails, PostUpdate.class, this.managedTypeDetails, this.postUpdate);
        } else if (methodDetails.getAnnotationUsage(PostLoad.class) != null && JpaEventListener.matchesSignature(JpaEventListenerStyle.CALLBACK, methodDetails)) {
            this.postLoad = LifecycleCallbackCollector.apply(methodDetails, PostLoad.class, this.managedTypeDetails, this.postLoad);
        }
    }

    private static <A extends Annotation> MethodDetails apply(MethodDetails incomingValue, Class<A> annotationType, ClassDetails managedTypeDetails, MethodDetails currentValue) {
        if (currentValue != null) {
            throw new ModelsException(String.format(Locale.ROOT, "Encountered multiple @%s methods [%s] - %s, %s", annotationType.getSimpleName(), managedTypeDetails.getClassName(), currentValue.getName(), incomingValue.getName()));
        }
        return incomingValue;
    }

    public JpaEventListener resolve() {
        if (this.prePersist != null || this.postPersist != null || this.preUpdate != null || this.postUpdate != null || this.preRemove != null || this.postRemove != null || this.postLoad != null) {
            return new JpaEventListener(JpaEventListenerStyle.CALLBACK, this.managedTypeDetails, this.prePersist, this.postPersist, this.preRemove, this.postRemove, this.preUpdate, this.postUpdate, this.postLoad);
        }
        return null;
    }
}

