/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.internal;

import jakarta.annotation.Generated;
import jakarta.persistence.AccessType;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.Lob;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Temporal;
import jakarta.persistence.Version;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.AnyDiscriminator;
import org.hibernate.annotations.AnyDiscriminatorValue;
import org.hibernate.annotations.AnyDiscriminatorValues;
import org.hibernate.annotations.AnyKeyJavaClass;
import org.hibernate.annotations.AnyKeyJavaType;
import org.hibernate.annotations.AnyKeyJdbcType;
import org.hibernate.annotations.AnyKeyJdbcTypeCode;
import org.hibernate.annotations.JavaType;
import org.hibernate.annotations.JdbcType;
import org.hibernate.annotations.JdbcTypeCode;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.Nationalized;
import org.hibernate.annotations.TenantId;
import org.hibernate.annotations.TimeZoneColumn;
import org.hibernate.annotations.TimeZoneStorage;
import org.hibernate.annotations.Type;
import org.hibernate.boot.internal.AnyKeyType;
import org.hibernate.boot.models.AccessTypePlacementException;
import org.hibernate.boot.models.AnnotationPlacementException;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.categorize.internal.AbstractPersistentAttributeMemberResolver;
import org.hibernate.boot.models.categorize.spi.ClassAttributeAccessType;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.MethodDetails;

public class StandardPersistentAttributeMemberResolver
extends AbstractPersistentAttributeMemberResolver {
    public static final StandardPersistentAttributeMemberResolver INSTANCE = new StandardPersistentAttributeMemberResolver();

    @Override
    protected List<MemberDetails> resolveAttributesMembers(Function<FieldDetails, Boolean> transientFieldChecker, Function<MethodDetails, Boolean> transientMethodChecker, ClassDetails classDetails, ClassAttributeAccessType classLevelAccessType) {
        LinkedHashMap results = new LinkedHashMap();
        this.processAttributeLevelAccess(results::put, transientFieldChecker, transientMethodChecker, classDetails, classLevelAccessType);
        this.processClassLevelAccess(results::containsKey, results::put, transientFieldChecker, transientMethodChecker, classDetails, classLevelAccessType);
        return new ArrayList<MemberDetails>(results.values());
    }

    private <M extends MemberDetails> void processAttributeLevelAccess(BiConsumer<String, MemberDetails> memberConsumer, Function<FieldDetails, Boolean> transientFieldChecker, Function<MethodDetails, Boolean> transientMethodChecker, ClassDetails classDetails, ClassAttributeAccessType classLevelAccessType) {
        List fields = classDetails.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            FieldDetails fieldDetails = (FieldDetails)fields.get(i);
            this.processAttributeLevelAccessMember(fieldDetails, memberConsumer, transientFieldChecker, classDetails, classLevelAccessType);
        }
        List methods = classDetails.getMethods();
        for (int i = 0; i < methods.size(); ++i) {
            MethodDetails methodDetails = (MethodDetails)methods.get(i);
            this.processAttributeLevelAccessMember(methodDetails, memberConsumer, transientMethodChecker, classDetails, classLevelAccessType);
        }
    }

    private <M extends MemberDetails> void processAttributeLevelAccessMember(M memberDetails, BiConsumer<String, MemberDetails> memberConsumer, Function<M, Boolean> transiencyChecker, ClassDetails classDetails, ClassAttributeAccessType classLevelAccessType) {
        if (transiencyChecker.apply(memberDetails).booleanValue()) {
            return;
        }
        AnnotationUsage access = memberDetails.getAnnotationUsage(JpaAnnotations.ACCESS);
        if (access == null) {
            this.checkForMisplacedAnnotations(classDetails, memberDetails, classLevelAccessType);
            return;
        }
        AccessType attributeAccessType = (AccessType)access.getAttributeValue("value");
        this.validateAttributeLevelAccess(memberDetails, attributeAccessType, classDetails);
        memberConsumer.accept(memberDetails.resolveAttributeName(), memberDetails);
    }

    private <M extends MemberDetails> void checkForMisplacedAnnotations(ClassDetails classDetails, M memberDetails, ClassAttributeAccessType classLevelAccessType) {
        if (classLevelAccessType == null) {
            return;
        }
        if (!this.matchesAccessType(memberDetails, classLevelAccessType) && this.containsMappingAnnotations(memberDetails)) {
            if (memberDetails.getKind() == AnnotationTarget.Kind.FIELD) {
                throw new AnnotationPlacementException(String.format(Locale.ROOT, "Field `%s#%s` declared mapping annotations even though it is not a persistent attribute", classDetails.getName(), memberDetails.getName()));
            }
            assert (memberDetails.getKind() == AnnotationTarget.Kind.METHOD);
            throw new AnnotationPlacementException(String.format(Locale.ROOT, "Method `%s#%s` declared mapping annotations even though it is not a persistent attribute", classDetails.getName(), memberDetails.getName()));
        }
    }

    private <M extends MemberDetails> boolean matchesAccessType(M memberDetails, ClassAttributeAccessType classLevelAccessType) {
        assert (classLevelAccessType != null);
        if (classLevelAccessType.getJpaAccessType() == AccessType.FIELD) {
            return memberDetails.getKind() == AnnotationTarget.Kind.FIELD;
        }
        return memberDetails.getKind() == AnnotationTarget.Kind.METHOD && ((MethodDetails)memberDetails).getMethodKind() == MethodDetails.MethodKind.GETTER;
    }

    private <M extends MemberDetails> boolean containsMappingAnnotations(M memberDetails) {
        return memberDetails.hasAnnotationUsage(Id.class) || memberDetails.hasAnnotationUsage(EmbeddedId.class) || memberDetails.hasAnnotationUsage(Version.class) || memberDetails.hasAnnotationUsage(Basic.class) || memberDetails.hasAnnotationUsage(Embedded.class) || memberDetails.hasAnnotationUsage(ManyToOne.class) || memberDetails.hasAnnotationUsage(OneToOne.class) || memberDetails.hasAnnotationUsage(ElementCollection.class) || memberDetails.hasAnnotationUsage(ManyToMany.class) || memberDetails.hasAnnotationUsage(OneToMany.class) || memberDetails.hasAnnotationUsage(Any.class) || memberDetails.hasAnnotationUsage(ManyToAny.class) || memberDetails.hasAnnotationUsage(AnyKeyJavaClass.class) || memberDetails.hasAnnotationUsage(AnyKeyJavaType.class) || memberDetails.hasAnnotationUsage(AnyKeyJdbcType.class) || memberDetails.hasAnnotationUsage(AnyKeyJdbcTypeCode.class) || memberDetails.hasAnnotationUsage(AnyKeyType.class) || memberDetails.hasAnnotationUsage(AnyDiscriminator.class) || memberDetails.hasAnnotationUsage(AnyDiscriminatorValue.class) || memberDetails.hasAnnotationUsage(AnyDiscriminatorValues.class) || memberDetails.hasAnnotationUsage(Column.class) || memberDetails.hasAnnotationUsage(Enumerated.class) || memberDetails.hasAnnotationUsage(Lob.class) || memberDetails.hasAnnotationUsage(Temporal.class) || memberDetails.hasAnnotationUsage(Nationalized.class) || memberDetails.hasAnnotationUsage(TenantId.class) || memberDetails.hasAnnotationUsage(Generated.class) || memberDetails.hasAnnotationUsage(TimeZoneColumn.class) || memberDetails.hasAnnotationUsage(TimeZoneStorage.class) || memberDetails.hasAnnotationUsage(Type.class) || memberDetails.hasAnnotationUsage(JavaType.class) || memberDetails.hasAnnotationUsage(JdbcType.class) || memberDetails.hasAnnotationUsage(JdbcTypeCode.class);
    }

    private void validateAttributeLevelAccess(MemberDetails annotationTarget, AccessType attributeAccessType, ClassDetails classDetails) {
        if (!this.isAnnotationPlacementComplianceEnabled()) {
            return;
        }
        if (attributeAccessType == AccessType.FIELD && !annotationTarget.isField() || attributeAccessType == AccessType.PROPERTY && annotationTarget.isField()) {
            throw new AccessTypePlacementException(classDetails, annotationTarget);
        }
    }

    private boolean isAnnotationPlacementComplianceEnabled() {
        return false;
    }

    private void processClassLevelAccess(Function<String, Boolean> alreadyProcessedChecker, BiConsumer<String, MemberDetails> memberConsumer, Function<FieldDetails, Boolean> transientFieldChecker, Function<MethodDetails, Boolean> transientMethodChecker, ClassDetails classDetails, ClassAttributeAccessType classLevelAccessType) {
        if (classLevelAccessType == null) {
            return;
        }
        if (classLevelAccessType.getJpaAccessType() == AccessType.FIELD) {
            List fields = classDetails.getFields();
            for (int i = 0; i < fields.size(); ++i) {
                String attributeName;
                FieldDetails fieldDetails = (FieldDetails)fields.get(i);
                if (!fieldDetails.isPersistable() || alreadyProcessedChecker.apply(attributeName = fieldDetails.resolveAttributeName()).booleanValue() || transientFieldChecker.apply(fieldDetails).booleanValue()) continue;
                memberConsumer.accept(attributeName, (MemberDetails)fieldDetails);
            }
        } else {
            assert (classLevelAccessType.getJpaAccessType() == AccessType.PROPERTY);
            List methods = classDetails.getMethods();
            for (int i = 0; i < methods.size(); ++i) {
                String attributeName;
                MethodDetails methodDetails = (MethodDetails)methods.get(i);
                if (!methodDetails.isPersistable() || alreadyProcessedChecker.apply(attributeName = methodDetails.resolveAttributeName()).booleanValue() || transientMethodChecker.apply(methodDetails).booleanValue()) continue;
                memberConsumer.accept(attributeName, (MemberDetails)methodDetails);
            }
        }
    }
}

