/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.spi;

import java.util.Map;
import java.util.Set;
import org.hibernate.boot.models.categorize.spi.EntityHierarchy;
import org.hibernate.boot.models.categorize.spi.GlobalRegistrations;
import org.hibernate.boot.models.xml.spi.PersistenceUnitMetadata;
import org.hibernate.internal.util.IndexedConsumer;
import org.hibernate.internal.util.KeyedConsumer;
import org.hibernate.models.spi.AnnotationDescriptorRegistry;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.jboss.jandex.IndexView;

public interface CategorizedDomainModel {
    public ClassDetailsRegistry getClassDetailsRegistry();

    public AnnotationDescriptorRegistry getAnnotationDescriptorRegistry();

    public IndexView getJandexIndex();

    public PersistenceUnitMetadata getPersistenceUnitMetadata();

    public GlobalRegistrations getGlobalRegistrations();

    public Set<EntityHierarchy> getEntityHierarchies();

    default public void forEachEntityHierarchy(IndexedConsumer<EntityHierarchy> hierarchyConsumer) {
        Set<EntityHierarchy> entityHierarchies = this.getEntityHierarchies();
        if (entityHierarchies.isEmpty()) {
            return;
        }
        int pos = 0;
        for (EntityHierarchy entityHierarchy : entityHierarchies) {
            hierarchyConsumer.accept(pos, entityHierarchy);
            ++pos;
        }
    }

    public Map<String, ClassDetails> getMappedSuperclasses();

    default public void forEachMappedSuperclass(KeyedConsumer<String, ClassDetails> consumer) {
        Map<String, ClassDetails> mappedSuperclasses = this.getMappedSuperclasses();
        if (mappedSuperclasses.isEmpty()) {
            return;
        }
        mappedSuperclasses.forEach(consumer::accept);
    }

    public Map<String, ClassDetails> getEmbeddables();

    default public void forEachEmbeddable(KeyedConsumer<String, ClassDetails> consumer) {
        Map<String, ClassDetails> embeddables = this.getEmbeddables();
        if (embeddables.isEmpty()) {
            return;
        }
        embeddables.forEach(consumer::accept);
    }
}

