/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.spi;

import jakarta.persistence.NamedNativeQuery;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;

public record NamedNativeQueryRegistration(String name, AnnotationUsage<NamedNativeQuery> configuration) {
    public String getQueryString() {
        return this.configuration.getString("query");
    }

    public ClassDetails getResultClass() {
        return this.configuration.getClassDetails("resultClass");
    }

    public String getResultSetMapping() {
        return this.configuration.getString("resultSetMapping");
    }

    public Map<String, String> getQueryHints() {
        List hints = this.configuration.getList("hints");
        if (CollectionHelper.isEmpty(hints)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = CollectionHelper.linkedMapOfSize(hints.size());
        for (AnnotationUsage hint : hints) {
            result.put(hint.getString("name"), hint.getString("value"));
        }
        return result;
    }
}

