/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.categorize.spi;

import jakarta.persistence.LockModeType;
import jakarta.persistence.NamedQuery;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationUsage;

public record NamedQueryRegistration(String name, AnnotationUsage<NamedQuery> configuration) {
    public String getQueryString() {
        return this.configuration.getString("query");
    }

    public LockModeType getLockModeType() {
        return (LockModeType)this.configuration.getEnum("lockMode");
    }

    public Map<String, String> getQueryHints() {
        List hints = this.configuration.getList("hints");
        if (CollectionHelper.isEmpty(hints)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> result = CollectionHelper.linkedMapOfSize(hints.size());
        for (AnnotationUsage hint : hints) {
            result.put(hint.getString("name"), hint.getString("value"));
        }
        return result;
    }
}

