/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Id;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributesContainer;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributesContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCachingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityOrMappedSuperclass;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManagedType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMappedSuperclassImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistentAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTenantIdImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.AttributeProcessor;
import org.hibernate.boot.models.xml.internal.EntityGraphProcessing;
import org.hibernate.boot.models.xml.internal.QueryProcessing;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.BasicAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.BasicIdAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.EmbeddedIdAttributeProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.boot.models.xml.spi.XmlProcessingResult;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.ModelsException;
import org.hibernate.models.internal.ClassTypeDetailsImpl;
import org.hibernate.models.internal.ModelsClassLogging;
import org.hibernate.models.internal.dynamic.DynamicClassDetails;
import org.hibernate.models.internal.dynamic.DynamicFieldDetails;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;

public class ManagedTypeProcessor {
    private static final int MEMBER_MODIFIERS = ManagedTypeProcessor.buildMemberModifiers();

    public static void processCompleteEntity(JaxbEntityMappingsImpl jaxbRoot, JaxbEntityImpl jaxbEntity, XmlDocumentContext xmlDocumentContext) {
        MutableClassDetails classDetails;
        AccessType classAccessType;
        AttributeProcessor.MemberAdjuster memberAdjuster;
        ClassDetailsRegistry classDetailsRegistry = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry();
        if (StringHelper.isEmpty(jaxbEntity.getClazz())) {
            if (StringHelper.isEmpty(jaxbEntity.getName())) {
                throw new ModelsException("Assumed dynamic entity did not define entity-name");
            }
            memberAdjuster = ManagedTypeProcessor::adjustDynamicTypeMember;
            classAccessType = AccessType.FIELD;
            classDetails = (MutableClassDetails)classDetailsRegistry.resolveClassDetails(jaxbEntity.getName(), name -> new DynamicClassDetails(jaxbEntity.getName(), null, false, null, null, xmlDocumentContext.getModelBuildingContext()));
            ManagedTypeProcessor.prepareDynamicClass(classDetails, jaxbEntity, xmlDocumentContext);
        } else {
            memberAdjuster = ManagedTypeProcessor::adjustNonDynamicTypeMember;
            String className = XmlProcessingHelper.determineClassName(jaxbRoot, jaxbEntity);
            classDetails = (MutableClassDetails)classDetailsRegistry.resolveClassDetails(className);
            classAccessType = NullnessHelper.coalesce(jaxbEntity.getAccess(), jaxbRoot.getAccess(), xmlDocumentContext.getEffectiveDefaults().getDefaultPropertyAccessType(), AccessType.PROPERTY);
        }
        classDetails.clearMemberAnnotationUsages();
        classDetails.clearAnnotationUsages();
        ManagedTypeProcessor.processEntityMetadata(classDetails, jaxbEntity, classAccessType, memberAdjuster, jaxbRoot, xmlDocumentContext);
    }

    private static void prepareDynamicClass(MutableClassDetails classDetails, JaxbManagedType jaxbManagedType, XmlDocumentContext xmlDocumentContext) {
        JaxbMappedSuperclassImpl jaxbMappedSuperclass;
        JaxbAttributesContainerImpl attributes;
        if (jaxbManagedType instanceof JaxbEntityImpl) {
            JaxbTenantIdImpl tenantId;
            DynamicFieldDetails member;
            TypeDetails attributeJavaType;
            JaxbEntityImpl jaxbDynamicEntity = (JaxbEntityImpl)jaxbManagedType;
            JaxbAttributesContainerImpl attributes2 = jaxbDynamicEntity.getAttributes();
            if (attributes2 != null) {
                if (CollectionHelper.isNotEmpty(attributes2.getIdAttributes())) {
                    attributes2.getIdAttributes().forEach(jaxbId -> {
                        TypeDetails attributeJavaType = ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbId, xmlDocumentContext);
                        DynamicFieldDetails member = new DynamicFieldDetails(jaxbId.getName(), attributeJavaType, (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                        classDetails.addField((FieldDetails)member);
                    });
                } else {
                    JaxbEmbeddedIdImpl embeddedId = attributes2.getEmbeddedIdAttribute();
                    attributeJavaType = ManagedTypeProcessor.determineDynamicAttributeJavaType(embeddedId, xmlDocumentContext);
                    member = new DynamicFieldDetails(embeddedId.getName(), attributeJavaType, (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                    classDetails.addField((FieldDetails)member);
                }
                if (attributes2.getNaturalId() != null) {
                    attributes2.getNaturalId().getBasicAttributes().forEach(jaxbBasic -> {
                        TypeDetails attributeJavaType = ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbBasic, xmlDocumentContext);
                        DynamicFieldDetails member = new DynamicFieldDetails(jaxbBasic.getName(), attributeJavaType, (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                        classDetails.addField((FieldDetails)member);
                    });
                    attributes2.getNaturalId().getEmbeddedAttributes().forEach(jaxbEmbedded -> {
                        TypeDetails attributeJavaType = ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbEmbedded, xmlDocumentContext);
                        DynamicFieldDetails member = new DynamicFieldDetails(jaxbEmbedded.getName(), attributeJavaType, (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                        classDetails.addField((FieldDetails)member);
                    });
                    attributes2.getNaturalId().getManyToOneAttributes().forEach(jaxbManyToOne -> {
                        TypeDetails attributeJavaType = ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbManyToOne, xmlDocumentContext);
                        DynamicFieldDetails member = new DynamicFieldDetails(jaxbManyToOne.getName(), attributeJavaType, (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                        classDetails.addField((FieldDetails)member);
                    });
                    attributes2.getNaturalId().getAnyMappingAttributes().forEach(jaxbAnyMapping -> {
                        TypeDetails attributeJavaType = ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbAnyMapping, xmlDocumentContext);
                        DynamicFieldDetails member = new DynamicFieldDetails(jaxbAnyMapping.getName(), attributeJavaType, (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                        classDetails.addField((FieldDetails)member);
                    });
                }
            }
            if ((tenantId = jaxbDynamicEntity.getTenantId()) != null) {
                attributeJavaType = ManagedTypeProcessor.determineDynamicAttributeJavaType(tenantId, xmlDocumentContext);
                member = new DynamicFieldDetails(tenantId.getName(), attributeJavaType, (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            }
        } else if (jaxbManagedType instanceof JaxbMappedSuperclassImpl && (attributes = (jaxbMappedSuperclass = (JaxbMappedSuperclassImpl)jaxbManagedType).getAttributes()) != null) {
            if (CollectionHelper.isNotEmpty(attributes.getIdAttributes())) {
                attributes.getIdAttributes().forEach(jaxbId -> {
                    TypeDetails attributeJavaType = ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbId, xmlDocumentContext);
                    DynamicFieldDetails member = new DynamicFieldDetails(jaxbId.getName(), attributeJavaType, (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                    classDetails.addField((FieldDetails)member);
                });
            } else {
                JaxbEmbeddedIdImpl embeddedId = attributes.getEmbeddedIdAttribute();
                TypeDetails attributeJavaType = ManagedTypeProcessor.determineDynamicAttributeJavaType(embeddedId, xmlDocumentContext);
                DynamicFieldDetails member = new DynamicFieldDetails(embeddedId.getName(), attributeJavaType, (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            }
        }
        JaxbAttributesContainer attributes3 = jaxbManagedType.getAttributes();
        if (attributes3 != null) {
            attributes3.getBasicAttributes().forEach(jaxbBasic -> {
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbBasic.getName(), ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbBasic, xmlDocumentContext), (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getEmbeddedAttributes().forEach(jaxbEmbedded -> {
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbEmbedded.getName(), ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbEmbedded, xmlDocumentContext), (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getOneToOneAttributes().forEach(jaxbOneToOne -> {
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbOneToOne.getName(), ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbOneToOne, xmlDocumentContext), (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getManyToOneAttributes().forEach(jaxbManyToOne -> {
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbManyToOne.getName(), ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbManyToOne, xmlDocumentContext), (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getAnyMappingAttributes().forEach(jaxbAnyMapping -> {
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbAnyMapping.getName(), ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbAnyMapping, xmlDocumentContext), (ClassDetails)classDetails, MEMBER_MODIFIERS, false, false, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getElementCollectionAttributes().forEach(jaxbElementCollection -> {
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbElementCollection.getName(), ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbElementCollection, xmlDocumentContext), (ClassDetails)classDetails, MEMBER_MODIFIERS, false, true, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getOneToManyAttributes().forEach(jaxbOneToMany -> {
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbOneToMany.getName(), ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbOneToMany, xmlDocumentContext), (ClassDetails)classDetails, MEMBER_MODIFIERS, false, true, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getManyToManyAttributes().forEach(jaxbManyToMany -> {
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbManyToMany.getName(), ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbManyToMany, xmlDocumentContext), (ClassDetails)classDetails, MEMBER_MODIFIERS, false, true, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
            attributes3.getPluralAnyMappingAttributes().forEach(jaxbPluralAnyMapping -> {
                TypeDetails attributeType = ManagedTypeProcessor.determineDynamicAttributeJavaType(jaxbPluralAnyMapping, xmlDocumentContext);
                DynamicFieldDetails member = new DynamicFieldDetails(jaxbPluralAnyMapping.getName(), attributeType, (ClassDetails)classDetails, MEMBER_MODIFIERS, false, true, xmlDocumentContext.getModelBuildingContext());
                classDetails.addField((FieldDetails)member);
            });
        }
    }

    private static TypeDetails determineDynamicAttributeJavaType(JaxbPersistentAttribute jaxbPersistentAttribute, XmlDocumentContext xmlDocumentContext) {
        MutableClassDetails classDetails = xmlDocumentContext.resolveDynamicJavaType(jaxbPersistentAttribute);
        return new ClassTypeDetailsImpl((ClassDetails)classDetails, TypeDetails.Kind.CLASS);
    }

    private static void adjustDynamicTypeMember(MutableMemberDetails memberDetails, JaxbPersistentAttribute jaxbAttribute, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage annotationUsage = memberDetails.applyAnnotationUsage(HibernateAnnotations.ATTRIBUTE_ACCESSOR, xmlDocumentContext.getModelBuildingContext());
        annotationUsage.setAttributeValue("value", (Object)BuiltInPropertyAccessStrategies.MAP.getExternalName());
    }

    private static void processEntityMetadata(MutableClassDetails classDetails, JaxbEntityImpl jaxbEntity, AccessType classAccessType, AttributeProcessor.MemberAdjuster memberAdjuster, JaxbEntityMappingsImpl jaxbRoot, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyEntity(jaxbEntity, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyInheritance(jaxbEntity, classDetails, xmlDocumentContext);
        ManagedTypeProcessor.applyAccessAnnotation(classAccessType, classDetails, xmlDocumentContext);
        ManagedTypeProcessor.applyCaching(jaxbEntity, classDetails, xmlDocumentContext);
        if (jaxbEntity.isAbstract() != null) {
            classDetails.applyAnnotationUsage(HibernateAnnotations.ABSTRACT, xmlDocumentContext.getModelBuildingContext());
        }
        if (StringHelper.isNotEmpty(jaxbEntity.getExtends())) {
            MutableAnnotationUsage extendsAnn = HibernateAnnotations.EXTENDS.createUsage(xmlDocumentContext.getModelBuildingContext());
            extendsAnn.setAttributeValue("superType", (Object)jaxbEntity.getExtends());
        }
        XmlAnnotationHelper.applyTable(jaxbEntity.getTable(), (MutableAnnotationTarget)classDetails, xmlDocumentContext);
        JaxbAttributesContainerImpl attributes = jaxbEntity.getAttributes();
        if (attributes != null) {
            ManagedTypeProcessor.processIdMappings(attributes, classAccessType, classDetails, memberAdjuster, xmlDocumentContext);
            AttributeProcessor.processNaturalId(attributes.getNaturalId(), classDetails, classAccessType, memberAdjuster, xmlDocumentContext);
            AttributeProcessor.processAttributes(attributes, classDetails, classAccessType, memberAdjuster, xmlDocumentContext);
        }
        AttributeProcessor.processAttributeOverrides(jaxbEntity.getAttributeOverrides(), classDetails, xmlDocumentContext);
        AttributeProcessor.processAssociationOverrides(jaxbEntity.getAssociationOverrides(), classDetails, xmlDocumentContext);
        QueryProcessing.applyNamedQueries(jaxbEntity, classDetails, xmlDocumentContext);
        QueryProcessing.applyNamedNativeQueries(jaxbEntity, classDetails, jaxbRoot, xmlDocumentContext);
        QueryProcessing.applyNamedProcedureQueries(jaxbEntity, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyFilters(jaxbEntity.getFilters(), (MutableAnnotationTarget)classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applySqlRestriction(jaxbEntity.getSqlRestriction(), (MutableAnnotationTarget)classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbEntity.getSqlInsert(), (MutableAnnotationTarget)classDetails, HibernateAnnotations.SQL_INSERT, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbEntity.getSqlUpdate(), (MutableAnnotationTarget)classDetails, HibernateAnnotations.SQL_UPDATE, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbEntity.getSqlDelete(), (MutableAnnotationTarget)classDetails, HibernateAnnotations.SQL_DELETE, xmlDocumentContext);
        ManagedTypeProcessor.processEntityOrMappedSuperclass(jaxbEntity, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyRowId(jaxbEntity.getRowid(), classDetails, xmlDocumentContext);
        ManagedTypeProcessor.applyTenantId(classDetails, jaxbEntity, classAccessType, xmlDocumentContext);
        EntityGraphProcessing.applyEntityGraphs(jaxbEntity, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyDiscriminatorValue(jaxbEntity.getDiscriminatorValue(), classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyDiscriminatorColumn(jaxbEntity.getDiscriminatorColumn(), classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyDiscriminatorFormula(jaxbEntity.getDiscriminatorFormula(), classDetails, xmlDocumentContext);
    }

    private static void applyAccessAnnotation(AccessType accessType, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage annotationUsage = target.applyAnnotationUsage(JpaAnnotations.ACCESS, xmlDocumentContext.getModelBuildingContext());
        annotationUsage.setAttributeValue("value", (Object)accessType);
        target.addAnnotationUsage((AnnotationUsage)annotationUsage);
    }

    private static void applyCaching(JaxbEntityImpl jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        JaxbCachingImpl jaxbCaching;
        if (jaxbEntity.isCacheable() != null) {
            MutableAnnotationUsage cacheableUsage = classDetails.applyAnnotationUsage(JpaAnnotations.CACHEABLE, xmlDocumentContext.getModelBuildingContext());
            cacheableUsage.setAttributeValue("value", (Object)jaxbEntity.isCacheable());
            classDetails.addAnnotationUsage((AnnotationUsage)cacheableUsage);
        }
        if ((jaxbCaching = jaxbEntity.getCaching()) != null) {
            MutableAnnotationUsage cacheUsage = classDetails.applyAnnotationUsage(HibernateAnnotations.CACHE, xmlDocumentContext.getModelBuildingContext());
            classDetails.addAnnotationUsage((AnnotationUsage)cacheUsage);
            XmlProcessingHelper.applyAttributeIfSpecified("region", jaxbCaching.getRegion(), cacheUsage);
            XmlProcessingHelper.applyAttributeIfSpecified("usage", (Object)ManagedTypeProcessor.convertCacheAccessType(jaxbCaching.getAccess()), cacheUsage);
        }
    }

    private static CacheConcurrencyStrategy convertCacheAccessType(org.hibernate.cache.spi.access.AccessType accessType) {
        if (accessType == null) {
            return null;
        }
        return CacheConcurrencyStrategy.fromAccessType(accessType);
    }

    private static void applyTenantId(MutableClassDetails classDetails, JaxbEntityImpl jaxbEntity, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        JaxbTenantIdImpl jaxbTenantId = jaxbEntity.getTenantId();
        if (jaxbTenantId != null) {
            MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbTenantId.getName(), NullnessHelper.coalesce(jaxbTenantId.getAccess(), classAccessType), classDetails);
            memberDetails.applyAnnotationUsage(HibernateAnnotations.TENANT_ID, xmlDocumentContext.getModelBuildingContext());
            BasicAttributeProcessing.processBasicAttribute(jaxbTenantId, classDetails, classAccessType, xmlDocumentContext);
        }
    }

    private static void adjustNonDynamicTypeMember(MutableMemberDetails memberDetails, JaxbPersistentAttribute jaxbAttribute, XmlDocumentContext xmlDocumentContext) {
        CommonAttributeProcessing.applyAttributeAccessor(jaxbAttribute, memberDetails, xmlDocumentContext);
    }

    public static void processOverrideEntity(List<XmlProcessingResult.OverrideTuple<JaxbEntityImpl>> entityOverrides) {
        entityOverrides.forEach(overrideTuple -> {
            XmlDocumentContext xmlDocumentContext = overrideTuple.getXmlDocumentContext();
            JaxbEntityMappingsImpl jaxbRoot = overrideTuple.getJaxbRoot();
            JaxbEntityImpl jaxbEntity = (JaxbEntityImpl)overrideTuple.getManagedType();
            String className = XmlProcessingHelper.determineClassName(jaxbRoot, jaxbEntity);
            MutableClassDetails classDetails = (MutableClassDetails)xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(className);
            Supplier[] supplierArray = new Supplier[6];
            supplierArray[0] = jaxbEntity::getAccess;
            supplierArray[1] = jaxbRoot::getAccess;
            supplierArray[2] = () -> ManagedTypeProcessor.determineAccessTypeFromClassAnnotations((ClassDetails)classDetails);
            supplierArray[3] = xmlDocumentContext.getEffectiveDefaults()::getDefaultPropertyAccessType;
            supplierArray[4] = () -> ManagedTypeProcessor.determineAccessTypeFromClassMembers((ClassDetails)classDetails);
            supplierArray[5] = () -> AccessType.PROPERTY;
            AccessType classAccessType = (AccessType)NullnessHelper.coalesceSuppliedValues(supplierArray);
            ManagedTypeProcessor.processEntityMetadata(classDetails, jaxbEntity, classAccessType, ManagedTypeProcessor::adjustNonDynamicTypeMember, jaxbRoot, xmlDocumentContext);
        });
    }

    private static AccessType determineAccessTypeFromClassAnnotations(ClassDetails classDetails) {
        AnnotationUsage accessUsage = classDetails.getAnnotationUsage(Access.class);
        if (accessUsage != null) {
            return (AccessType)accessUsage.getAttributeValue("value");
        }
        return null;
    }

    private static AccessType determineAccessTypeFromClassMembers(ClassDetails classDetails) {
        for (FieldDetails field : classDetails.getFields()) {
            if (field.getAnnotationUsage(Id.class) == null && field.getAnnotationUsage(EmbeddedId.class) == null) continue;
            return AccessType.FIELD;
        }
        for (MethodDetails method : classDetails.getMethods()) {
            if (method.getAnnotationUsage(Id.class) == null && method.getAnnotationUsage(EmbeddedId.class) == null) continue;
            assert (method.getMethodKind() == MethodDetails.MethodKind.GETTER);
            return AccessType.PROPERTY;
        }
        return null;
    }

    private static Supplier<AccessType> determineAccessTypeFromClassAndXml(JaxbEntityImpl jaxbEntity, MutableClassDetails classDetails) {
        return null;
    }

    private static void processIdMappings(JaxbAttributesContainerImpl attributes, AccessType classAccessType, MutableClassDetails classDetails, AttributeProcessor.MemberAdjuster memberAdjuster, XmlDocumentContext xmlDocumentContext) {
        List<JaxbIdImpl> jaxbIds = attributes.getIdAttributes();
        JaxbEmbeddedIdImpl jaxbEmbeddedId = attributes.getEmbeddedIdAttribute();
        if (CollectionHelper.isNotEmpty(jaxbIds)) {
            for (int i = 0; i < jaxbIds.size(); ++i) {
                JaxbIdImpl jaxbId = jaxbIds.get(i);
                MutableMemberDetails memberDetails = BasicIdAttributeProcessing.processBasicIdAttribute(jaxbId, classDetails, classAccessType, xmlDocumentContext);
                memberAdjuster.adjust(memberDetails, jaxbId, xmlDocumentContext);
            }
        } else if (jaxbEmbeddedId != null) {
            MutableMemberDetails memberDetails = EmbeddedIdAttributeProcessing.processEmbeddedIdAttribute(jaxbEmbeddedId, classDetails, classAccessType, xmlDocumentContext);
            memberAdjuster.adjust(memberDetails, jaxbEmbeddedId, xmlDocumentContext);
        } else {
            ModelsClassLogging.MODELS_CLASS_LOGGER.debugf("Identifiable type [%s] contained no <id/> nor <embedded-id/>", (Object)classDetails.getName());
        }
    }

    public static void processCompleteMappedSuperclass(JaxbEntityMappingsImpl jaxbRoot, JaxbMappedSuperclassImpl jaxbMappedSuperclass, XmlDocumentContext xmlDocumentContext) {
        String className = XmlProcessingHelper.determineClassName(jaxbRoot, jaxbMappedSuperclass);
        MutableClassDetails classDetails = (MutableClassDetails)xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(className);
        classDetails.clearMemberAnnotationUsages();
        classDetails.clearAnnotationUsages();
        ManagedTypeProcessor.processMappedSuperclassMetadata(jaxbMappedSuperclass, classDetails, xmlDocumentContext);
    }

    private static void processMappedSuperclassMetadata(JaxbMappedSuperclassImpl jaxbMappedSuperclass, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        JaxbAttributesContainerImpl attributes;
        SourceModelBuildingContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        classDetails.applyAnnotationUsage(JpaAnnotations.MAPPED_SUPERCLASS, modelBuildingContext);
        AccessType classAccessType = NullnessHelper.coalesce(jaxbMappedSuperclass.getAccess(), xmlDocumentContext.getEffectiveDefaults().getDefaultPropertyAccessType());
        if (classAccessType != null) {
            MutableAnnotationUsage accessUsage = classDetails.applyAnnotationUsage(JpaAnnotations.ACCESS, modelBuildingContext);
            accessUsage.setAttributeValue("value", (Object)classAccessType);
        }
        if ((attributes = jaxbMappedSuperclass.getAttributes()) != null) {
            ManagedTypeProcessor.processIdMappings(attributes, classAccessType, classDetails, ManagedTypeProcessor::adjustNonDynamicTypeMember, xmlDocumentContext);
            AttributeProcessor.processAttributes(attributes, classDetails, classAccessType, xmlDocumentContext);
        }
        ManagedTypeProcessor.processEntityOrMappedSuperclass(jaxbMappedSuperclass, classDetails, xmlDocumentContext);
    }

    public static void processOverrideMappedSuperclass(List<XmlProcessingResult.OverrideTuple<JaxbMappedSuperclassImpl>> mappedSuperclassesOverrides) {
        mappedSuperclassesOverrides.forEach(overrideTuple -> {
            XmlDocumentContext xmlDocumentContext = overrideTuple.getXmlDocumentContext();
            JaxbEntityMappingsImpl jaxbRoot = overrideTuple.getJaxbRoot();
            JaxbMappedSuperclassImpl jaxbMappedSuperclass = (JaxbMappedSuperclassImpl)overrideTuple.getManagedType();
            String className = XmlProcessingHelper.determineClassName(jaxbRoot, jaxbMappedSuperclass);
            MutableClassDetails classDetails = (MutableClassDetails)xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(className);
            ManagedTypeProcessor.processMappedSuperclassMetadata(jaxbMappedSuperclass, classDetails, xmlDocumentContext);
        });
    }

    private static void processEntityOrMappedSuperclass(JaxbEntityOrMappedSuperclass jaxbClass, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyIdClass(jaxbClass.getIdClass(), classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallbacks(jaxbClass, classDetails, xmlDocumentContext);
    }

    public static void processCompleteEmbeddable(JaxbEntityMappingsImpl jaxbRoot, JaxbEmbeddableImpl jaxbEmbeddable, XmlDocumentContext xmlDocumentContext) {
        AttributeProcessor.MemberAdjuster memberAdjuster;
        AccessType classAccessType;
        MutableClassDetails classDetails;
        ClassDetailsRegistry classDetailsRegistry = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry();
        if (StringHelper.isEmpty(jaxbEmbeddable.getClazz())) {
            if (StringHelper.isEmpty(jaxbEmbeddable.getName())) {
                throw new ModelsException("Embeddable did not define class nor name");
            }
            classDetails = (MutableClassDetails)classDetailsRegistry.resolveClassDetails(jaxbEmbeddable.getName(), DynamicClassDetails::new);
            classAccessType = AccessType.FIELD;
            memberAdjuster = ManagedTypeProcessor::adjustDynamicTypeMember;
            ManagedTypeProcessor.prepareDynamicClass(classDetails, jaxbEmbeddable, xmlDocumentContext);
        } else {
            String className = XmlProcessingHelper.determineClassName(jaxbRoot, jaxbEmbeddable);
            classDetails = (MutableClassDetails)classDetailsRegistry.resolveClassDetails(className);
            classAccessType = NullnessHelper.coalesce(jaxbEmbeddable.getAccess(), xmlDocumentContext.getEffectiveDefaults().getDefaultPropertyAccessType());
            memberAdjuster = ManagedTypeProcessor::adjustNonDynamicTypeMember;
        }
        classDetails.clearMemberAnnotationUsages();
        classDetails.clearAnnotationUsages();
        ManagedTypeProcessor.processEmbeddableMetadata(jaxbEmbeddable, classDetails, classAccessType, memberAdjuster, xmlDocumentContext);
    }

    private static void processEmbeddableMetadata(JaxbEmbeddableImpl jaxbEmbeddable, MutableClassDetails classDetails, AccessType classAccessType, AttributeProcessor.MemberAdjuster memberAdjuster, XmlDocumentContext xmlDocumentContext) {
        classDetails.applyAnnotationUsage(JpaAnnotations.EMBEDDABLE, xmlDocumentContext.getModelBuildingContext());
        if (classAccessType != null) {
            MutableAnnotationUsage accessUsage = classDetails.applyAnnotationUsage(JpaAnnotations.ACCESS, xmlDocumentContext.getModelBuildingContext());
            accessUsage.setAttributeValue("value", (Object)classAccessType);
        }
        if (jaxbEmbeddable.getAttributes() != null) {
            AttributeProcessor.processAttributes(jaxbEmbeddable.getAttributes(), classDetails, AccessType.FIELD, memberAdjuster, xmlDocumentContext);
        }
    }

    public static void processOverrideEmbeddable(List<XmlProcessingResult.OverrideTuple<JaxbEmbeddableImpl>> embeddableOverrides) {
        embeddableOverrides.forEach(overrideTuple -> {
            XmlDocumentContext xmlDocumentContext = overrideTuple.getXmlDocumentContext();
            JaxbEntityMappingsImpl jaxbRoot = overrideTuple.getJaxbRoot();
            JaxbEmbeddableImpl jaxbEmbeddable = (JaxbEmbeddableImpl)overrideTuple.getManagedType();
            String className = XmlProcessingHelper.determineClassName(jaxbRoot, jaxbEmbeddable);
            MutableClassDetails classDetails = (MutableClassDetails)xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(className);
            classDetails.applyAnnotationUsage(JpaAnnotations.EMBEDDABLE, xmlDocumentContext.getModelBuildingContext());
            if (jaxbEmbeddable.getAttributes() != null) {
                AttributeProcessor.processAttributes(jaxbEmbeddable.getAttributes(), classDetails, AccessType.FIELD, ManagedTypeProcessor::adjustNonDynamicTypeMember, xmlDocumentContext);
            }
        });
    }

    private static int buildMemberModifiers() {
        return Modifier.fieldModifiers();
    }
}

