/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import jakarta.persistence.EntityResult;
import jakarta.persistence.FieldResult;
import jakarta.persistence.NamedStoredProcedureQuery;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.CacheMode;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConstructorResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFieldResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedNativeQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedQueryBase;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedStoredProcedureQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbQueryHint;
import org.hibernate.boot.jaxb.mapping.spi.JaxbStoredProcedureParameterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSynchronizedTableImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.internal.AnnotationUsageHelper;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class QueryProcessing {
    public static void applyNamedQueries(JaxbEntityImpl jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbEntity.getNamedQueries())) {
            return;
        }
        SourceModelBuildingContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        ArrayList namedHqlQueryList = null;
        ArrayList namedJpqlQueryList = null;
        for (int i = 0; i < jaxbEntity.getNamedQueries().size(); ++i) {
            JaxbNamedQueryImpl jaxbNamedQuery = jaxbEntity.getNamedQueries().get(i);
            if (CollectionHelper.isNotEmpty(jaxbNamedQuery.getHints())) {
                if (namedJpqlQueryList == null) {
                    MutableAnnotationUsage namedJpqlQueriesUsage = classDetails.replaceAnnotationUsage(JpaAnnotations.NAMED_QUERY, JpaAnnotations.NAMED_QUERIES, modelBuildingContext);
                    classDetails.addAnnotationUsage((AnnotationUsage)namedJpqlQueriesUsage);
                    namedJpqlQueryList = new ArrayList();
                    namedJpqlQueriesUsage.setAttributeValue("value", namedJpqlQueryList);
                }
                QueryProcessing.applyNamedJpqlQuery(jaxbNamedQuery, (ClassDetails)classDetails, namedJpqlQueryList, modelBuildingContext);
                continue;
            }
            if (namedHqlQueryList == null) {
                MutableAnnotationUsage namedHqlQueriesUsage = classDetails.replaceAnnotationUsage(HibernateAnnotations.NAMED_QUERY, HibernateAnnotations.NAMED_QUERIES, modelBuildingContext);
                classDetails.addAnnotationUsage((AnnotationUsage)namedHqlQueriesUsage);
                namedHqlQueryList = new ArrayList();
                namedHqlQueriesUsage.setAttributeValue("value", namedHqlQueryList);
            }
            QueryProcessing.applyNamedHqlQuery(jaxbNamedQuery, classDetails, namedHqlQueryList, modelBuildingContext);
        }
    }

    public static void applyNamedHqlQuery(JaxbNamedQueryImpl jaxbNamedQuery, MutableClassDetails classDetails, List<MutableAnnotationUsage<NamedQuery>> namedQueryList, SourceModelBuildingContext modelBuildingContext) {
        MutableAnnotationUsage namedQueryUsage = HibernateAnnotations.NAMED_QUERY.createUsage(modelBuildingContext);
        namedQueryList.add((MutableAnnotationUsage<NamedQuery>)namedQueryUsage);
        namedQueryUsage.setAttributeValue("name", (Object)jaxbNamedQuery.getName());
        namedQueryUsage.setAttributeValue("query", (Object)jaxbNamedQuery.getQuery());
        AnnotationUsageHelper.applyAttributeIfSpecified("comment", jaxbNamedQuery.getComment(), namedQueryUsage);
        AnnotationUsageHelper.applyAttributeIfSpecified("readOnly", jaxbNamedQuery.isReadOnly(), namedQueryUsage);
        AnnotationUsageHelper.applyAttributeIfSpecified("flushMode", (Object)jaxbNamedQuery.getFlushMode(), namedQueryUsage);
        if (jaxbNamedQuery.isCacheable() == Boolean.TRUE) {
            namedQueryUsage.setAttributeValue("cacheable", (Object)true);
            AnnotationUsageHelper.applyAttributeIfSpecified("cacheRegion", jaxbNamedQuery.getCacheRegion(), namedQueryUsage);
            AnnotationUsageHelper.applyAttributeIfSpecified("cacheMode", (Object)jaxbNamedQuery.getCacheMode(), namedQueryUsage);
            CacheMode cacheMode = jaxbNamedQuery.getCacheMode();
            if (cacheMode != null && cacheMode != CacheMode.IGNORE) {
                if (cacheMode == CacheMode.GET) {
                    AnnotationUsageHelper.applyAttributeIfSpecified("cacheRegion", (Object)cacheMode, namedQueryUsage);
                    AnnotationUsageHelper.applyAttributeIfSpecified("cacheRegion", (Object)cacheMode, namedQueryUsage);
                }
                AnnotationUsageHelper.applyAttributeIfSpecified("cacheRegion", (Object)cacheMode, namedQueryUsage);
                AnnotationUsageHelper.applyAttributeIfSpecified("cacheRegion", (Object)cacheMode, namedQueryUsage);
            }
        }
        AnnotationUsageHelper.applyAttributeIfSpecified("fetchSize", jaxbNamedQuery.getFetchSize(), namedQueryUsage);
        AnnotationUsageHelper.applyAttributeIfSpecified("timeout", jaxbNamedQuery.getTimeout(), namedQueryUsage);
        AnnotationUsageHelper.applyAttributeIfSpecified("timeout", jaxbNamedQuery.getTimeout(), namedQueryUsage);
    }

    private static void applyNamedJpqlQuery(JaxbNamedQueryImpl jaxbNamedQuery, ClassDetails classDetails, List<MutableAnnotationUsage<jakarta.persistence.NamedQuery>> namedQueryList, SourceModelBuildingContext modelBuildingContext) {
        MutableAnnotationUsage namedQueryUsage = JpaAnnotations.NAMED_QUERY.createUsage(modelBuildingContext);
        namedQueryList.add((MutableAnnotationUsage<jakarta.persistence.NamedQuery>)namedQueryUsage);
        namedQueryUsage.setAttributeValue("name", (Object)jaxbNamedQuery.getName());
        namedQueryUsage.setAttributeValue("query", (Object)jaxbNamedQuery.getQuery());
        QueryProcessing.applyQueryHints(jaxbNamedQuery, classDetails, namedQueryUsage, modelBuildingContext);
    }

    private static void applyQueryHints(JaxbNamedQueryBase jaxbNamedQuery, ClassDetails classDetails, MutableAnnotationUsage<?> namedQueryUsage, SourceModelBuildingContext modelBuildingContext) {
        if (CollectionHelper.isNotEmpty(jaxbNamedQuery.getHints())) {
            ArrayList hints = CollectionHelper.arrayList(jaxbNamedQuery.getHints().size());
            namedQueryUsage.setAttributeValue("hints", hints);
            for (JaxbQueryHint jaxbQueryHint : jaxbNamedQuery.getHints()) {
                MutableAnnotationUsage queryHintUsage = JpaAnnotations.QUERY_HINT.createUsage(modelBuildingContext);
                queryHintUsage.setAttributeValue("name", (Object)jaxbQueryHint.getName());
                queryHintUsage.setAttributeValue("value", (Object)jaxbQueryHint.getValue());
            }
        }
    }

    public static void applyNamedNativeQueries(JaxbEntityImpl jaxbEntity, MutableClassDetails classDetails, JaxbEntityMappingsImpl jaxbRoot, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbEntity.getNamedNativeQueries())) {
            return;
        }
        SourceModelBuildingContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        ArrayList namedHibernateQueryList = null;
        ArrayList namedJpaQueryList = null;
        for (int i = 0; i < jaxbEntity.getNamedNativeQueries().size(); ++i) {
            MutableAnnotationUsage namedQueriesUsage;
            JaxbNamedNativeQueryImpl jaxbNamedQuery = jaxbEntity.getNamedNativeQueries().get(i);
            if (QueryProcessing.needsJpaNativeQuery(jaxbNamedQuery)) {
                if (namedJpaQueryList == null) {
                    namedQueriesUsage = classDetails.replaceAnnotationUsage(JpaAnnotations.NAMED_NATIVE_QUERY, JpaAnnotations.NAMED_NATIVE_QUERIES, modelBuildingContext);
                    classDetails.addAnnotationUsage((AnnotationUsage)namedQueriesUsage);
                    namedJpaQueryList = new ArrayList();
                    namedQueriesUsage.setAttributeValue("value", (Object)namedQueriesUsage);
                }
                QueryProcessing.applyJpaNativeQuery(jaxbNamedQuery, classDetails, namedJpaQueryList, modelBuildingContext, xmlDocumentContext);
                continue;
            }
            if (namedHibernateQueryList == null) {
                namedQueriesUsage = classDetails.replaceAnnotationUsage(HibernateAnnotations.NAMED_NATIVE_QUERY, HibernateAnnotations.NAMED_NATIVE_QUERIES, modelBuildingContext);
                classDetails.addAnnotationUsage((AnnotationUsage)namedQueriesUsage);
                namedHibernateQueryList = new ArrayList();
                namedQueriesUsage.setAttributeValue("value", namedHibernateQueryList);
            }
            QueryProcessing.applyHibernateNativeQuery(jaxbNamedQuery, classDetails, namedHibernateQueryList, modelBuildingContext, xmlDocumentContext);
        }
    }

    private static boolean needsJpaNativeQuery(JaxbNamedNativeQueryImpl jaxbNamedQuery) {
        return CollectionHelper.isNotEmpty(jaxbNamedQuery.getHints()) || CollectionHelper.isNotEmpty(jaxbNamedQuery.getColumnResult()) || CollectionHelper.isNotEmpty(jaxbNamedQuery.getConstructorResult()) || CollectionHelper.isNotEmpty(jaxbNamedQuery.getEntityResult());
    }

    private static void applyJpaNativeQuery(JaxbNamedNativeQueryImpl jaxbNamedQuery, MutableClassDetails classDetails, List<MutableAnnotationUsage<jakarta.persistence.NamedNativeQuery>> namedQueryUsageList, SourceModelBuildingContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage namedQueryUsage = JpaAnnotations.NAMED_NATIVE_QUERY.createUsage(modelBuildingContext);
        namedQueryUsageList.add((MutableAnnotationUsage<jakarta.persistence.NamedNativeQuery>)namedQueryUsage);
        namedQueryUsage.setAttributeValue("name", (Object)jaxbNamedQuery.getName());
        namedQueryUsage.setAttributeValue("query", (Object)jaxbNamedQuery.getQuery());
        QueryProcessing.applyQueryHints(jaxbNamedQuery, (ClassDetails)classDetails, namedQueryUsage, modelBuildingContext);
        QueryProcessing.applyResultClassAndSynchronizations(jaxbNamedQuery, namedQueryUsage, modelBuildingContext, xmlDocumentContext);
        QueryProcessing.applyResultSetMappings(jaxbNamedQuery, namedQueryUsage, xmlDocumentContext);
        QueryProcessing.applyResults(jaxbNamedQuery, (MutableAnnotationUsage<jakarta.persistence.NamedNativeQuery>)namedQueryUsage, (AnnotationTarget)classDetails, modelBuildingContext, xmlDocumentContext);
    }

    private static void applyResultClassAndSynchronizations(JaxbNamedNativeQueryImpl jaxbNamedQuery, MutableAnnotationUsage<?> namedQueryUsage, SourceModelBuildingContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        ArrayList<String> syncSpaces = new ArrayList<String>();
        if (jaxbNamedQuery.getResultClass() != null) {
            String resultClassName = xmlDocumentContext.resolveClassName(jaxbNamedQuery.getResultClass());
            syncSpaces.add(resultClassName);
            namedQueryUsage.setAttributeValue("resultClass", (Object)modelBuildingContext.getClassDetailsRegistry().getClassDetails(resultClassName));
        }
        for (JaxbSynchronizedTableImpl synchronization : jaxbNamedQuery.getSynchronizations()) {
            syncSpaces.add(synchronization.getTable());
        }
        if (CollectionHelper.isNotEmpty(syncSpaces)) {
            namedQueryUsage.setAttributeValue("querySpaces", syncSpaces);
        }
    }

    private static void applyResultSetMappings(JaxbNamedNativeQueryImpl jaxbNamedQuery, MutableAnnotationUsage<?> namedQueryUsage, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isEmpty(jaxbNamedQuery.getResultSetMapping())) {
            return;
        }
        namedQueryUsage.setAttributeValue("resultSetMapping", (Object)jaxbNamedQuery.getResultSetMapping());
    }

    private static void applyResults(JaxbNamedNativeQueryImpl jaxbNamedQuery, MutableAnnotationUsage<jakarta.persistence.NamedNativeQuery> namedQueryUsage, AnnotationTarget annotationTarget, SourceModelBuildingContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isNotEmpty(jaxbNamedQuery.getColumnResult())) {
            ArrayList<MutableAnnotationUsage<ColumnResult>> columnResultList = QueryProcessing.extractColumnResults(jaxbNamedQuery.getColumnResult(), annotationTarget, modelBuildingContext, xmlDocumentContext);
            namedQueryUsage.setAttributeValue("columns", columnResultList);
        }
        if (CollectionHelper.isNotEmpty(jaxbNamedQuery.getConstructorResult())) {
            ArrayList<MutableAnnotationUsage<ConstructorResult>> constructorResultList = QueryProcessing.extractConstructorResults(jaxbNamedQuery.getConstructorResult(), annotationTarget, modelBuildingContext, xmlDocumentContext);
            namedQueryUsage.setAttributeValue("classes", constructorResultList);
        }
        if (CollectionHelper.isNotEmpty(jaxbNamedQuery.getEntityResult())) {
            ArrayList<MutableAnnotationUsage<EntityResult>> entityResultList = QueryProcessing.extractEntityResults(jaxbNamedQuery.getEntityResult(), annotationTarget, modelBuildingContext, xmlDocumentContext);
            namedQueryUsage.setAttributeValue("entities", entityResultList);
        }
    }

    private static ArrayList<MutableAnnotationUsage<ColumnResult>> extractColumnResults(List<JaxbColumnResultImpl> jaxbColumnResultList, AnnotationTarget annotationTarget, SourceModelBuildingContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        assert (CollectionHelper.isNotEmpty(jaxbColumnResultList));
        ArrayList<MutableAnnotationUsage<ColumnResult>> columnResultList = CollectionHelper.arrayList(jaxbColumnResultList.size());
        for (JaxbColumnResultImpl jaxbColumnResult : jaxbColumnResultList) {
            MutableAnnotationUsage columnResultUsage = JpaAnnotations.COLUMN_RESULT.createUsage(modelBuildingContext);
            columnResultList.add((MutableAnnotationUsage<ColumnResult>)columnResultUsage);
            columnResultUsage.setAttributeValue("name", (Object)jaxbColumnResult.getName());
            if (!StringHelper.isNotEmpty(jaxbColumnResult.getClazz())) continue;
            columnResultUsage.setAttributeValue("type", (Object)xmlDocumentContext.resolveJavaType(jaxbColumnResult.getClazz()));
        }
        return columnResultList;
    }

    private static ArrayList<MutableAnnotationUsage<ConstructorResult>> extractConstructorResults(List<JaxbConstructorResultImpl> jaxbConstructorResultList, AnnotationTarget annotationTarget, SourceModelBuildingContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        assert (CollectionHelper.isNotEmpty(jaxbConstructorResultList));
        ArrayList<MutableAnnotationUsage<ConstructorResult>> constructorResultList = CollectionHelper.arrayList(jaxbConstructorResultList.size());
        for (JaxbConstructorResultImpl jaxbConstructorResult : jaxbConstructorResultList) {
            MutableAnnotationUsage constructorResultUsage = JpaAnnotations.CONSTRUCTOR_RESULT.createUsage(modelBuildingContext);
            constructorResultList.add((MutableAnnotationUsage<ConstructorResult>)constructorResultUsage);
            constructorResultUsage.setAttributeValue("targetClass", (Object)xmlDocumentContext.resolveJavaType(jaxbConstructorResult.getTargetClass()));
            if (!CollectionHelper.isNotEmpty(jaxbConstructorResult.getColumns())) continue;
            ArrayList<MutableAnnotationUsage<ColumnResult>> columnResultList = QueryProcessing.extractColumnResults(jaxbConstructorResult.getColumns(), annotationTarget, modelBuildingContext, xmlDocumentContext);
            constructorResultUsage.setAttributeValue("columns", columnResultList);
        }
        return constructorResultList;
    }

    private static ArrayList<MutableAnnotationUsage<EntityResult>> extractEntityResults(List<JaxbEntityResultImpl> jaxbEntityResults, AnnotationTarget annotationTarget, SourceModelBuildingContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        assert (CollectionHelper.isNotEmpty(jaxbEntityResults));
        ArrayList<MutableAnnotationUsage<EntityResult>> entityResultList = CollectionHelper.arrayList(jaxbEntityResults.size());
        for (JaxbEntityResultImpl jaxbEntityResult : jaxbEntityResults) {
            MutableAnnotationUsage entityResultUsage = JpaAnnotations.ENTITY_RESULT.createUsage(modelBuildingContext);
            entityResultList.add((MutableAnnotationUsage<EntityResult>)entityResultUsage);
            entityResultUsage.setAttributeValue("entityClass", (Object)xmlDocumentContext.resolveJavaType(jaxbEntityResult.getEntityClass()));
            AnnotationUsageHelper.applyAttributeIfSpecified("lockMode", jaxbEntityResult.getLockMode(), entityResultUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("discriminatorColumn", jaxbEntityResult.getDiscriminatorColumn(), entityResultUsage);
            if (!CollectionHelper.isNotEmpty(jaxbEntityResult.getFieldResult())) continue;
            ArrayList<MutableAnnotationUsage<FieldResult>> fieldResultList = QueryProcessing.extractFieldResults(jaxbEntityResult.getFieldResult(), annotationTarget, modelBuildingContext, xmlDocumentContext);
            entityResultUsage.setAttributeValue("fields", fieldResultList);
        }
        return entityResultList;
    }

    private static ArrayList<MutableAnnotationUsage<FieldResult>> extractFieldResults(List<JaxbFieldResultImpl> jaxbFieldResults, AnnotationTarget annotationTarget, SourceModelBuildingContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        assert (CollectionHelper.isNotEmpty(jaxbFieldResults));
        ArrayList<MutableAnnotationUsage<FieldResult>> fieldResultList = CollectionHelper.arrayList(jaxbFieldResults.size());
        for (JaxbFieldResultImpl jaxbFieldResult : jaxbFieldResults) {
            MutableAnnotationUsage fieldResultUsage = JpaAnnotations.FIELD_RESULT.createUsage(modelBuildingContext);
            fieldResultList.add((MutableAnnotationUsage<FieldResult>)fieldResultUsage);
            fieldResultUsage.setAttributeValue("name", (Object)jaxbFieldResult.getName());
            fieldResultUsage.setAttributeValue("column", (Object)jaxbFieldResult.getColumn());
        }
        return fieldResultList;
    }

    private static void applyHibernateNativeQuery(JaxbNamedNativeQueryImpl jaxbNamedQuery, MutableClassDetails classDetails, List<MutableAnnotationUsage<NamedNativeQuery>> namedQueryUsageList, SourceModelBuildingContext modelBuildingContext, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage namedQueryUsage = HibernateAnnotations.NAMED_NATIVE_QUERY.createUsage(modelBuildingContext);
        namedQueryUsageList.add((MutableAnnotationUsage<NamedNativeQuery>)namedQueryUsage);
        namedQueryUsage.setAttributeValue("name", (Object)jaxbNamedQuery.getName());
        namedQueryUsage.setAttributeValue("query", (Object)jaxbNamedQuery.getQuery());
        QueryProcessing.applyResultClassAndSynchronizations(jaxbNamedQuery, namedQueryUsage, modelBuildingContext, xmlDocumentContext);
        QueryProcessing.applyResultSetMappings(jaxbNamedQuery, namedQueryUsage, xmlDocumentContext);
    }

    public static void applyNamedProcedureQueries(JaxbEntityImpl jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbEntity.getNamedStoredProcedureQueries())) {
            return;
        }
        SourceModelBuildingContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        MutableAnnotationUsage namedQueriesUsage = classDetails.replaceAnnotationUsage(JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY, JpaAnnotations.NAMED_STORED_PROCEDURE_QUERIES, modelBuildingContext);
        ArrayList namedQueryList = CollectionHelper.arrayList(jaxbEntity.getNamedStoredProcedureQueries().size());
        namedQueriesUsage.setAttributeValue("value", namedQueryList);
        for (JaxbNamedStoredProcedureQueryImpl jaxbQuery : jaxbEntity.getNamedStoredProcedureQueries()) {
            MutableAnnotationUsage namedQueryUsage = JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY.createUsage(modelBuildingContext);
            namedQueryList.add(namedQueryUsage);
            namedQueryUsage.setAttributeValue("name", (Object)jaxbQuery.getName());
            namedQueryUsage.setAttributeValue("procedureName", (Object)jaxbQuery.getProcedureName());
            QueryProcessing.applyQueryHints(jaxbQuery, (ClassDetails)classDetails, namedQueryUsage, modelBuildingContext);
            QueryProcessing.applyQueryParameters(jaxbQuery, classDetails, (MutableAnnotationUsage<NamedStoredProcedureQuery>)namedQueryUsage, xmlDocumentContext);
            QueryProcessing.applyResultSetMappings(jaxbQuery, (MutableAnnotationUsage<NamedStoredProcedureQuery>)namedQueryUsage, xmlDocumentContext);
            QueryProcessing.applyResultClasses(jaxbQuery, (MutableAnnotationUsage<NamedStoredProcedureQuery>)namedQueryUsage, xmlDocumentContext);
        }
    }

    private static void applyQueryParameters(JaxbNamedStoredProcedureQueryImpl jaxbQuery, MutableClassDetails classDetails, MutableAnnotationUsage<NamedStoredProcedureQuery> queryUsage, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbQuery.getProcedureParameters())) {
            return;
        }
        SourceModelBuildingContext sourceModelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        ArrayList parameterList = CollectionHelper.arrayList(jaxbQuery.getProcedureParameters().size());
        queryUsage.setAttributeValue("parameters", parameterList);
        for (JaxbStoredProcedureParameterImpl jaxbParameter : jaxbQuery.getProcedureParameters()) {
            MutableAnnotationUsage parameterUsage = JpaAnnotations.STORED_PROCEDURE_PARAMETER.createUsage(sourceModelBuildingContext);
            parameterList.add(parameterUsage);
            AnnotationUsageHelper.applyStringAttributeIfSpecified("name", jaxbParameter.getName(), parameterUsage);
            AnnotationUsageHelper.applyAttributeIfSpecified("mode", jaxbParameter.getMode(), parameterUsage);
            parameterUsage.setAttributeValue("type", (Object)xmlDocumentContext.resolveJavaType(jaxbParameter.getClazz()));
        }
    }

    private static void applyResultSetMappings(JaxbNamedStoredProcedureQueryImpl jaxbQuery, MutableAnnotationUsage<NamedStoredProcedureQuery> namedQueryUsage, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbQuery.getResultSetMappings())) {
            return;
        }
        namedQueryUsage.setAttributeValue("resultSetMappings", jaxbQuery.getResultSetMappings());
    }

    private static void applyResultClasses(JaxbNamedStoredProcedureQueryImpl jaxbQuery, MutableAnnotationUsage<NamedStoredProcedureQuery> namedQueryUsage, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbQuery.getResultClasses())) {
            return;
        }
        ArrayList resultClasses = CollectionHelper.arrayList(jaxbQuery.getResultClasses().size());
        namedQueryUsage.setAttributeValue("resultClasses", resultClasses);
        for (String resultClass : jaxbQuery.getResultClasses()) {
            MutableClassDetails resultClassDetails = xmlDocumentContext.resolveJavaType(resultClass);
            resultClasses.add(resultClassDetails);
        }
    }
}

