/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.AssociationOverride;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.Column;
import jakarta.persistence.EnumType;
import jakarta.persistence.TemporalType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.ResultCheckStyle;
import org.hibernate.annotations.SqlFragmentAlias;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAssociationOverrideImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAttributeOverrideImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBasicMapping;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCachingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCascadeTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCheckConstraintImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionIdImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionUserTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConfigurationParameterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConvertImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCustomSqlImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDiscriminatorColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbDiscriminatorFormulaImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbElementCollectionImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntity;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityListenerContainerImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityOrMappedSuperclass;
import org.hibernate.boot.jaxb.mapping.spi.JaxbGeneratedValueImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbHbmFilterImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIdClassImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIndexImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbLifecycleCallback;
import org.hibernate.boot.jaxb.mapping.spi.JaxbLifecycleCallbackContainer;
import org.hibernate.boot.jaxb.mapping.spi.JaxbLobImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNationalizedImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNaturalId;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSchemaAware;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSequenceGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTableGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUniqueConstraintImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUserTypeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbUuidGeneratorImpl;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbCheckable;
import org.hibernate.boot.jaxb.mapping.spi.db.JaxbTableMapping;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.categorize.spi.JpaEventListener;
import org.hibernate.boot.models.categorize.spi.JpaEventListenerStyle;
import org.hibernate.boot.models.internal.AnnotationUsageHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.db.ColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.TableProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocument;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.internal.util.KeyedConsumer;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.ModelsException;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AnnotationUsage;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;
import org.hibernate.type.SqlTypes;

public class XmlAnnotationHelper {
    public static void applyOptionalAttribute(MutableAnnotationUsage<? extends Annotation> annotationUsage, String attributeName, Object value) {
        if (value != null) {
            annotationUsage.setAttributeValue(attributeName, value);
        }
    }

    public static void applyOptionalAttribute(MutableAnnotationUsage<? extends Annotation> annotationUsage, String attributeName, String value) {
        if (StringHelper.isNotEmpty(value)) {
            annotationUsage.setAttributeValue(attributeName, (Object)value);
        }
    }

    public static void applyEntity(JaxbEntity jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage entityAnn = classDetails.applyAnnotationUsage(JpaAnnotations.ENTITY, xmlDocumentContext.getModelBuildingContext());
        XmlProcessingHelper.applyAttributeIfSpecified("name", jaxbEntity.getName(), entityAnn);
    }

    public static void applyColumn(JaxbColumnImpl jaxbColumn, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbColumn == null) {
            return;
        }
        XmlAnnotationHelper.createColumnAnnotation(jaxbColumn, (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
    }

    private static MutableAnnotationUsage<Column> createColumnAnnotation(JaxbColumnImpl jaxbColumn, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage columnAnnotationUsage = target.applyAnnotationUsage(JpaAnnotations.COLUMN, xmlDocumentContext.getModelBuildingContext());
        ColumnProcessing.applyColumnDetails(jaxbColumn, (AnnotationTarget)target, columnAnnotationUsage, xmlDocumentContext);
        return columnAnnotationUsage;
    }

    public static <T, N> void applyOr(N jaxbNode, Function<N, T> jaxbValueAccess, String name, KeyedConsumer<String, T> valueConsumer, Supplier<T> defaultValueProvider) {
        T value;
        if (jaxbNode != null && (value = jaxbValueAccess.apply(jaxbNode)) != null) {
            valueConsumer.accept(name, value);
            return;
        }
        valueConsumer.accept(name, defaultValueProvider.get());
    }

    public static <T, N, A extends Annotation> void applyOr(N jaxbNode, Function<N, T> jaxbValueAccess, String name, MutableAnnotationUsage<A> annotationUsage, AnnotationDescriptor<A> annotationDescriptor) {
        XmlAnnotationHelper.applyOr(jaxbNode, jaxbValueAccess, name, (String key, T value) -> annotationUsage.setAttributeValue(name, value), () -> annotationDescriptor.getAttribute(name).getAttributeMethod().getDefaultValue());
    }

    public static void applyUserType(JaxbUserTypeImpl jaxbType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbType == null) {
            return;
        }
        MutableAnnotationUsage typeAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.TYPE, xmlDocumentContext.getModelBuildingContext());
        ClassDetails userTypeImpl = XmlAnnotationHelper.resolveJavaType(jaxbType.getValue(), xmlDocumentContext);
        typeAnn.setAttributeValue("value", (Object)userTypeImpl);
        typeAnn.setAttributeValue("parameters", XmlAnnotationHelper.collectParameters(jaxbType.getParameters(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext));
    }

    public static List<AnnotationUsage<Parameter>> collectParameters(List<JaxbConfigurationParameterImpl> jaxbParameters, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbParameters)) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationUsage<Parameter>> parameterAnnList = new ArrayList<AnnotationUsage<Parameter>>(jaxbParameters.size());
        jaxbParameters.forEach(jaxbParam -> {
            MutableAnnotationUsage parameterUsage = HibernateAnnotations.PARAMETER.createUsage(xmlDocumentContext.getModelBuildingContext());
            parameterAnnList.add((AnnotationUsage<Parameter>)parameterUsage);
            parameterUsage.setAttributeValue("name", (Object)jaxbParam.getName());
            parameterUsage.setAttributeValue("value", (Object)jaxbParam.getValue());
        });
        return parameterAnnList;
    }

    public static void applyCollectionUserType(JaxbCollectionUserTypeImpl jaxbType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbType == null) {
            return;
        }
        MutableAnnotationUsage typeAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.COLLECTION_TYPE, xmlDocumentContext.getModelBuildingContext());
        ClassDetails userTypeImpl = XmlAnnotationHelper.resolveJavaType(jaxbType.getType(), xmlDocumentContext);
        typeAnn.setAttributeValue("type", (Object)userTypeImpl);
        typeAnn.setAttributeValue("parameters", XmlAnnotationHelper.collectParameters(jaxbType.getParameters(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext));
    }

    public static void applyCollectionId(JaxbCollectionIdImpl jaxbCollectionId, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        JaxbGeneratedValueImpl generator;
        if (jaxbCollectionId == null) {
            return;
        }
        MutableAnnotationUsage collectionIdAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.COLLECTION_ID, xmlDocumentContext.getModelBuildingContext());
        JaxbColumnImpl jaxbColumn = jaxbCollectionId.getColumn();
        if (jaxbColumn != null) {
            collectionIdAnn.setAttributeValue("column", XmlAnnotationHelper.createColumnAnnotation(jaxbColumn, (MutableAnnotationTarget)memberDetails, xmlDocumentContext));
        }
        if ((generator = jaxbCollectionId.getGenerator()) != null && StringHelper.isNotEmpty(generator.getGenerator())) {
            collectionIdAnn.setAttributeValue("generator", (Object)generator.getGenerator());
        }
    }

    public static void applyCascading(JaxbCascadeTypeImpl jaxbCascadeType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbCascadeType == null) {
            return;
        }
        ArrayList<CascadeType> cascadeTypes = new ArrayList<CascadeType>(xmlDocumentContext.getEffectiveDefaults().getDefaultCascadeTypes());
        if (jaxbCascadeType.getCascadeAll() != null) {
            cascadeTypes.add(CascadeType.ALL);
        }
        if (jaxbCascadeType.getCascadePersist() != null) {
            cascadeTypes.add(CascadeType.PERSIST);
        }
        if (jaxbCascadeType.getCascadeMerge() != null) {
            cascadeTypes.add(CascadeType.MERGE);
        }
        if (jaxbCascadeType.getCascadeRemove() != null) {
            cascadeTypes.add(CascadeType.REMOVE);
        }
        if (jaxbCascadeType.getCascadeRefresh() != null) {
            cascadeTypes.add(CascadeType.REFRESH);
        }
        if (jaxbCascadeType.getCascadeDetach() != null) {
            cascadeTypes.add(CascadeType.DETACH);
        }
        if (jaxbCascadeType.getCascadeReplicate() != null) {
            cascadeTypes.add(CascadeType.REPLICATE);
        }
        if (jaxbCascadeType.getCascadeLock() != null) {
            cascadeTypes.add(CascadeType.LOCK);
        }
        if (!cascadeTypes.isEmpty()) {
            MutableAnnotationUsage cascadeAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.CASCADE, xmlDocumentContext.getModelBuildingContext());
            cascadeAnn.setAttributeValue("value", cascadeTypes);
        }
    }

    public static <A extends Annotation> void applyUniqueConstraints(List<JaxbUniqueConstraintImpl> jaxbUniqueConstraints, AnnotationTarget target, MutableAnnotationUsage<A> annotationUsage, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbUniqueConstraints)) {
            return;
        }
        ArrayList uniqueConstraintUsages = new ArrayList(jaxbUniqueConstraints.size());
        annotationUsage.setAttributeValue("uniqueConstraints", uniqueConstraintUsages);
        jaxbUniqueConstraints.forEach(jaxbUniqueConstraint -> {
            MutableAnnotationUsage ucUsage = JpaAnnotations.UNIQUE_CONSTRAINT.createUsage(xmlDocumentContext.getModelBuildingContext());
            XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)ucUsage, "name", jaxbUniqueConstraint.getName());
            XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)ucUsage, "options", jaxbUniqueConstraint.getOptions());
            ucUsage.setAttributeValue("columnNames", jaxbUniqueConstraint.getColumnName());
            uniqueConstraintUsages.add(ucUsage);
        });
    }

    public static <A extends Annotation> void applyIndexes(List<JaxbIndexImpl> jaxbIndexes, AnnotationTarget target, MutableAnnotationUsage<A> annotationUsage, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbIndexes)) {
            return;
        }
        ArrayList indexes = new ArrayList(jaxbIndexes.size());
        jaxbIndexes.forEach(jaxbIndex -> {
            MutableAnnotationUsage indexAnn = JpaAnnotations.INDEX.createUsage(xmlDocumentContext.getModelBuildingContext());
            XmlAnnotationHelper.applyOr(jaxbIndex, JaxbIndexImpl::getName, "name", indexAnn, JpaAnnotations.INDEX);
            XmlAnnotationHelper.applyOr(jaxbIndex, JaxbIndexImpl::getColumnList, "columnList", indexAnn, JpaAnnotations.INDEX);
            XmlAnnotationHelper.applyOr(jaxbIndex, JaxbIndexImpl::isUnique, "unique", indexAnn, JpaAnnotations.INDEX);
            indexes.add(indexAnn);
        });
        annotationUsage.setAttributeValue("indexes", indexes);
    }

    public static <A extends Annotation> void applyCheckConstraints(JaxbCheckable jaxbCheckable, AnnotationTarget target, MutableAnnotationUsage<A> annotationUsage, XmlDocumentContext xmlDocumentContext) {
        if (jaxbCheckable != null && CollectionHelper.isNotEmpty(jaxbCheckable.getCheckConstraints())) {
            ArrayList<MutableAnnotationUsage> checks = new ArrayList<MutableAnnotationUsage>(jaxbCheckable.getCheckConstraints().size());
            for (JaxbCheckConstraintImpl jaxbCheck : jaxbCheckable.getCheckConstraints()) {
                MutableAnnotationUsage checkAnn = JpaAnnotations.CHECK_CONSTRAINT.createUsage(xmlDocumentContext.getModelBuildingContext());
                checkAnn.setAttributeValue("constraint", (Object)jaxbCheck.getConstraint());
                XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)checkAnn, "name", jaxbCheck.getName());
                XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)checkAnn, "options", jaxbCheck.getOptions());
                checks.add(checkAnn);
            }
            annotationUsage.setAttributeValue("check", checks);
        }
    }

    public static void applyTargetClass(String name, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        ClassDetails classDetails = XmlAnnotationHelper.resolveJavaType(name, xmlDocumentContext);
        MutableAnnotationUsage targetAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
        targetAnn.setAttributeValue("value", (Object)classDetails);
    }

    public static void applyTemporal(TemporalType temporalType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (temporalType == null) {
            return;
        }
        MutableAnnotationUsage temporalAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.TEMPORAL, xmlDocumentContext.getModelBuildingContext());
        temporalAnn.setAttributeValue("value", (Object)temporalType);
    }

    public static void applyLob(JaxbLobImpl jaxbLob, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbLob == null) {
            return;
        }
        memberDetails.applyAnnotationUsage(JpaAnnotations.LOB, xmlDocumentContext.getModelBuildingContext());
    }

    public static void applyEnumerated(EnumType enumType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (enumType == null) {
            return;
        }
        MutableAnnotationUsage annotationUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.ENUMERATED, xmlDocumentContext.getModelBuildingContext());
        annotationUsage.setAttributeValue("value", (Object)enumType);
    }

    public static void applyNationalized(JaxbNationalizedImpl jaxbNationalized, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbNationalized == null) {
            return;
        }
        memberDetails.applyAnnotationUsage(HibernateAnnotations.NATIONALIZED, xmlDocumentContext.getModelBuildingContext());
    }

    public static void applyGeneratedValue(JaxbGeneratedValueImpl jaxbGeneratedValue, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbGeneratedValue == null) {
            return;
        }
        MutableAnnotationUsage generatedValueAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.GENERATED_VALUE, xmlDocumentContext.getModelBuildingContext());
        memberDetails.addAnnotationUsage((AnnotationUsage)generatedValueAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("strategy", jaxbGeneratedValue.getStrategy(), generatedValueAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("generator", jaxbGeneratedValue.getGenerator(), generatedValueAnn);
    }

    public static void applySequenceGenerator(JaxbSequenceGeneratorImpl jaxbGenerator, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbGenerator == null) {
            return;
        }
        MutableAnnotationUsage sequenceAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.SEQUENCE_GENERATOR, xmlDocumentContext.getModelBuildingContext());
        XmlProcessingHelper.applyAttributeIfSpecified("sequenceName", jaxbGenerator.getSequenceName(), sequenceAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("catalog", jaxbGenerator.getCatalog(), sequenceAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("schema", jaxbGenerator.getSchema(), sequenceAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("initialValue", jaxbGenerator.getInitialValue(), sequenceAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("allocationSize", jaxbGenerator.getInitialValue(), sequenceAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("options", jaxbGenerator.getOptions(), sequenceAnn);
    }

    public static void applyTableGenerator(JaxbTableGeneratorImpl jaxbGenerator, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbGenerator == null) {
            return;
        }
        MutableAnnotationUsage tableAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.TABLE_GENERATOR, xmlDocumentContext.getModelBuildingContext());
        XmlProcessingHelper.applyAttributeIfSpecified("name", jaxbGenerator.getName(), tableAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("table", jaxbGenerator.getTable(), tableAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("catalog", jaxbGenerator.getCatalog(), tableAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("schema", jaxbGenerator.getSchema(), tableAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("pkColumnName", jaxbGenerator.getPkColumnName(), tableAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("valueColumnName", jaxbGenerator.getValueColumnName(), tableAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("pkColumnValue", jaxbGenerator.getPkColumnValue(), tableAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("initialValue", jaxbGenerator.getInitialValue(), tableAnn);
        XmlProcessingHelper.applyAttributeIfSpecified("allocationSize", jaxbGenerator.getInitialValue(), tableAnn);
        XmlAnnotationHelper.applyUniqueConstraints(jaxbGenerator.getUniqueConstraints(), (AnnotationTarget)memberDetails, tableAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyIndexes(jaxbGenerator.getIndexes(), (AnnotationTarget)memberDetails, tableAnn, xmlDocumentContext);
    }

    public static void applyUuidGenerator(JaxbUuidGeneratorImpl jaxbGenerator, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbGenerator == null) {
            return;
        }
        MutableAnnotationUsage uuidGenAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.UUID_GENERATOR, xmlDocumentContext.getModelBuildingContext());
        uuidGenAnn.setAttributeValue("style", (Object)jaxbGenerator.getStyle());
    }

    public static void applyAttributeOverrides(JaxbPluralAttribute pluralAttribute, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        List<JaxbAttributeOverrideImpl> jaxbElementOverrides;
        List<JaxbAttributeOverrideImpl> jaxbMapKeyOverrides = pluralAttribute.getMapKeyAttributeOverrides();
        List<JaxbAttributeOverrideImpl> list = jaxbElementOverrides = pluralAttribute instanceof JaxbElementCollectionImpl ? ((JaxbElementCollectionImpl)pluralAttribute).getAttributeOverrides() : Collections.emptyList();
        if (CollectionHelper.isEmpty(jaxbMapKeyOverrides) && CollectionHelper.isEmpty(jaxbElementOverrides)) {
            return;
        }
        MutableAnnotationUsage overridesUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.ATTRIBUTE_OVERRIDES, xmlDocumentContext.getModelBuildingContext());
        int numberOfOverrides = jaxbMapKeyOverrides.size() + jaxbElementOverrides.size();
        ArrayList overrideUsages = CollectionHelper.arrayList(numberOfOverrides);
        overridesUsage.setAttributeValue("value", overrideUsages);
        if (memberDetails.getMapKeyType() != null) {
            jaxbMapKeyOverrides.forEach(jaxbOverride -> overrideUsages.add(XmlAnnotationHelper.createAttributeOverrideUsage(jaxbOverride, "key", (MutableAnnotationTarget)memberDetails, xmlDocumentContext)));
            jaxbElementOverrides.forEach(jaxbOverride -> overrideUsages.add(XmlAnnotationHelper.createAttributeOverrideUsage(jaxbOverride, "value", (MutableAnnotationTarget)memberDetails, xmlDocumentContext)));
        } else {
            assert (CollectionHelper.isEmpty(jaxbMapKeyOverrides));
            jaxbElementOverrides.forEach(jaxbOverride -> overrideUsages.add(XmlAnnotationHelper.createAttributeOverrideUsage(jaxbOverride, null, (MutableAnnotationTarget)memberDetails, xmlDocumentContext)));
        }
    }

    private static MutableAnnotationUsage<AttributeOverride> createAttributeOverrideUsage(JaxbAttributeOverrideImpl jaxbOverride, String namePrefix, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        SourceModelBuildingContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        MutableAnnotationUsage overrideUsage = JpaAnnotations.ATTRIBUTE_OVERRIDE.createUsage(modelBuildingContext);
        String name = StringHelper.qualifyConditionally(namePrefix, jaxbOverride.getName());
        overrideUsage.setAttributeValue("name", (Object)name);
        MutableAnnotationUsage columnAnn = JpaAnnotations.COLUMN.createUsage(modelBuildingContext);
        overrideUsage.setAttributeValue("column", (Object)columnAnn);
        ColumnProcessing.applyColumnDetails(jaxbOverride.getColumn(), (AnnotationTarget)target, columnAnn, xmlDocumentContext);
        return overrideUsage;
    }

    public static void applyAttributeOverrides(List<JaxbAttributeOverrideImpl> jaxbOverrides, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyAttributeOverrides(jaxbOverrides, (MutableAnnotationTarget)memberDetails, null, xmlDocumentContext);
    }

    public static void applyAttributeOverrides(List<JaxbAttributeOverrideImpl> jaxbOverrides, MutableAnnotationTarget target, String namePrefix, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbOverrides)) {
            return;
        }
        MutableAnnotationUsage overridesUsage = target.replaceAnnotationUsage(JpaAnnotations.ATTRIBUTE_OVERRIDE, JpaAnnotations.ATTRIBUTE_OVERRIDES, xmlDocumentContext.getModelBuildingContext());
        ArrayList overrideUsages = CollectionHelper.arrayList(jaxbOverrides.size());
        overridesUsage.setAttributeValue("value", overrideUsages);
        jaxbOverrides.forEach(jaxbOverride -> overrideUsages.add(XmlAnnotationHelper.createAttributeOverrideUsage(jaxbOverride, namePrefix, target, xmlDocumentContext)));
    }

    public static void applyAssociationOverrides(List<JaxbAssociationOverrideImpl> jaxbOverrides, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbOverrides)) {
            return;
        }
        MutableAnnotationUsage overridesUsage = target.replaceAnnotationUsage(JpaAnnotations.ASSOCIATION_OVERRIDE, JpaAnnotations.ASSOCIATION_OVERRIDES, xmlDocumentContext.getModelBuildingContext());
        ArrayList overrideUsages = CollectionHelper.arrayList(jaxbOverrides.size());
        overridesUsage.setAttributeValue("value", overrideUsages);
        jaxbOverrides.forEach(jaxbOverride -> {
            MutableAnnotationUsage overrideUsage = JpaAnnotations.ASSOCIATION_OVERRIDE.createUsage(xmlDocumentContext.getModelBuildingContext());
            XmlAnnotationHelper.transferAssociationOverride(jaxbOverride, (MutableAnnotationUsage<AssociationOverride>)overrideUsage, target, xmlDocumentContext);
            overrideUsages.add(overrideUsage);
        });
    }

    private static void transferAssociationOverride(JaxbAssociationOverrideImpl jaxbOverride, MutableAnnotationUsage<AssociationOverride> overrideUsage, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        overrideUsage.setAttributeValue("name", (Object)jaxbOverride.getName());
        List<JaxbJoinColumnImpl> joinColumns = jaxbOverride.getJoinColumns();
        if (CollectionHelper.isNotEmpty(joinColumns)) {
            overrideUsage.setAttributeValue("joinColumns", JoinColumnProcessing.transformJoinColumnList(joinColumns, (AnnotationTarget)target, xmlDocumentContext));
        }
        if (jaxbOverride.getJoinTable() != null) {
            overrideUsage.setAttributeValue("joinTable", TableProcessing.transformJoinTable(jaxbOverride.getJoinTable(), target, xmlDocumentContext));
        }
        if (jaxbOverride.getForeignKeys() != null) {
            overrideUsage.setAttributeValue("foreignKey", ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbOverride.getForeignKeys(), (AnnotationTarget)target, xmlDocumentContext));
        }
    }

    public static void applyConverts(List<JaxbConvertImpl> jaxbConverts, String namePrefix, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbConverts)) {
            return;
        }
        MutableAnnotationUsage convertsUsage = memberDetails.replaceAnnotationUsage(JpaAnnotations.CONVERT, JpaAnnotations.CONVERTS, xmlDocumentContext.getModelBuildingContext());
        ArrayList convertUsages = CollectionHelper.arrayList(jaxbConverts.size());
        convertsUsage.setAttributeValue("value", convertUsages);
        for (JaxbConvertImpl jaxbConvert : jaxbConverts) {
            MutableAnnotationUsage convertUsage = JpaAnnotations.CONVERT.createUsage(xmlDocumentContext.getModelBuildingContext());
            convertUsages.add(convertUsage);
            ClassDetailsRegistry classDetailsRegistry = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry();
            if (StringHelper.isNotEmpty(jaxbConvert.getConverter())) {
                ClassDetails converter = classDetailsRegistry.resolveClassDetails(jaxbConvert.getConverter());
                convertUsage.setAttributeValue("converter", (Object)converter);
            }
            XmlProcessingHelper.applyAttributeIfSpecified("attributeName", XmlAnnotationHelper.prefixIfNotAlready(jaxbConvert.getAttributeName(), namePrefix), convertUsage);
            XmlProcessingHelper.applyAttributeIfSpecified("disableConversion", jaxbConvert.isDisableConversion(), convertUsage);
        }
    }

    public static void applyConvert(JaxbConvertImpl jaxbConvert, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyConvert(jaxbConvert, memberDetails, null, xmlDocumentContext);
    }

    public static void applyConvert(JaxbConvertImpl jaxbConvert, MutableMemberDetails memberDetails, String namePrefix, XmlDocumentContext xmlDocumentContext) {
        if (jaxbConvert == null) {
            return;
        }
        MutableAnnotationUsage convertUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.CONVERT, xmlDocumentContext.getModelBuildingContext());
        ClassDetailsRegistry classDetailsRegistry = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry();
        if (StringHelper.isNotEmpty(jaxbConvert.getConverter())) {
            ClassDetails converter = classDetailsRegistry.resolveClassDetails(jaxbConvert.getConverter());
            convertUsage.setAttributeValue("converter", (Object)converter);
        }
        XmlProcessingHelper.applyAttributeIfSpecified("attributeName", XmlAnnotationHelper.prefixIfNotAlready(jaxbConvert.getAttributeName(), namePrefix), convertUsage);
        XmlProcessingHelper.applyAttributeIfSpecified("disableConversion", jaxbConvert.isDisableConversion(), convertUsage);
    }

    public static void applyTable(JaxbTableImpl jaxbTable, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbTable == null) {
            XmlDocument.Defaults defaults = xmlDocumentContext.getXmlDocument().getDefaults();
            String catalog = defaults.getCatalog();
            String schema = defaults.getSchema();
            if (StringHelper.isNotEmpty(catalog) || StringHelper.isNotEmpty(schema)) {
                MutableAnnotationUsage tableAnn = target.applyAnnotationUsage(JpaAnnotations.TABLE, xmlDocumentContext.getModelBuildingContext());
                if (StringHelper.isNotEmpty(catalog)) {
                    tableAnn.setAttributeValue("catalog", (Object)catalog);
                }
                if (StringHelper.isNotEmpty(schema)) {
                    tableAnn.setAttributeValue("schema", (Object)schema);
                }
            }
        } else {
            MutableAnnotationUsage tableAnn = target.applyAnnotationUsage(JpaAnnotations.TABLE, xmlDocumentContext.getModelBuildingContext());
            XmlAnnotationHelper.applyOr(jaxbTable, JaxbTableImpl::getName, "name", tableAnn, JpaAnnotations.TABLE);
            XmlAnnotationHelper.applyTableAttributes(jaxbTable, (AnnotationTarget)target, tableAnn, JpaAnnotations.TABLE, xmlDocumentContext);
        }
    }

    public static <A extends Annotation> void applyTableAttributes(JaxbTableMapping jaxbTable, AnnotationTarget target, MutableAnnotationUsage<A> tableAnn, AnnotationDescriptor<A> annotationDescriptor, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyOrCatalog(jaxbTable, tableAnn, annotationDescriptor, xmlDocumentContext);
        XmlAnnotationHelper.applyOrSchema(jaxbTable, tableAnn, annotationDescriptor, xmlDocumentContext);
        XmlAnnotationHelper.applyOr(jaxbTable, JaxbTableMapping::getOptions, "options", tableAnn, annotationDescriptor);
        XmlAnnotationHelper.applyOr(jaxbTable, JaxbTableMapping::getComment, "comment", tableAnn, annotationDescriptor);
        XmlAnnotationHelper.applyCheckConstraints(jaxbTable, target, tableAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyUniqueConstraints(jaxbTable.getUniqueConstraints(), target, tableAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyIndexes(jaxbTable.getIndexes(), target, tableAnn, xmlDocumentContext);
    }

    public static void applyNaturalIdCache(JaxbNaturalId jaxbNaturalId, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbNaturalId == null || jaxbNaturalId.getCaching() == null) {
            return;
        }
        MutableAnnotationUsage naturalIdCacheUsage = classDetails.applyAnnotationUsage(HibernateAnnotations.NATURAL_ID_CACHE, xmlDocumentContext.getModelBuildingContext());
        JaxbCachingImpl jaxbCaching = jaxbNaturalId.getCaching();
        XmlProcessingHelper.applyAttributeIfSpecified("region", jaxbCaching.getRegion(), naturalIdCacheUsage);
    }

    static void applyInheritance(JaxbEntity jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbEntity.getInheritance() == null) {
            return;
        }
        MutableAnnotationUsage inheritanceUsage = classDetails.applyAnnotationUsage(JpaAnnotations.INHERITANCE, xmlDocumentContext.getModelBuildingContext());
        XmlProcessingHelper.applyAttributeIfSpecified("strategy", jaxbEntity.getInheritance().getStrategy(), inheritanceUsage);
    }

    public static ClassDetails resolveJavaType(String value, XmlDocumentContext xmlDocumentContext) {
        return XmlAnnotationHelper.resolveJavaType(xmlDocumentContext.getXmlDocument().getDefaults().getPackage(), value, xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry());
    }

    public static ClassDetails resolveJavaType(String value, ClassDetailsRegistry classDetailsRegistry) {
        return XmlAnnotationHelper.resolveJavaType(null, value, classDetailsRegistry);
    }

    public static ClassDetails resolveJavaType(String packageName, String name, ClassDetailsRegistry classDetailsRegistry) {
        if (StringHelper.isEmpty(name)) {
            name = Object.class.getName();
        } else if (!(Byte.TYPE.getName().equals(name) || Boolean.TYPE.getName().equals(name) || Short.TYPE.getName().equals(name) || Integer.TYPE.getName().equals(name) || Long.TYPE.getName().equals(name) || Double.TYPE.getName().equals(name) || Float.TYPE.getName().equals(name))) {
            name = Byte.class.getSimpleName().equalsIgnoreCase(name) ? Byte.class.getName() : (Boolean.class.getSimpleName().equalsIgnoreCase(name) ? Boolean.class.getName() : (Short.class.getSimpleName().equalsIgnoreCase(name) ? Short.class.getName() : (Integer.class.getSimpleName().equalsIgnoreCase(name) ? Integer.class.getName() : (Long.class.getSimpleName().equalsIgnoreCase(name) ? Long.class.getName() : (Double.class.getSimpleName().equalsIgnoreCase(name) ? Double.class.getName() : (Float.class.getSimpleName().equalsIgnoreCase(name) ? Float.class.getName() : (BigInteger.class.getSimpleName().equalsIgnoreCase(name) ? BigInteger.class.getName() : (BigDecimal.class.getSimpleName().equalsIgnoreCase(name) ? BigDecimal.class.getName() : (String.class.getSimpleName().equalsIgnoreCase(name) ? String.class.getName() : (Character.class.getSimpleName().equalsIgnoreCase(name) ? Character.class.getName() : (UUID.class.getSimpleName().equalsIgnoreCase(name) ? Character.class.getName() : StringHelper.qualifyConditionallyIfNot(packageName, name))))))))))));
        }
        return classDetailsRegistry.resolveClassDetails(name);
    }

    public static void applyBasicTypeComposition(JaxbBasicMapping jaxbBasicMapping, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbBasicMapping.getType() != null) {
            XmlAnnotationHelper.applyUserType(jaxbBasicMapping.getType(), memberDetails, xmlDocumentContext);
        } else if (jaxbBasicMapping.getJavaType() != null) {
            XmlAnnotationHelper.applyJavaTypeDescriptor(jaxbBasicMapping.getJavaType(), memberDetails, xmlDocumentContext);
        } else if (StringHelper.isNotEmpty(jaxbBasicMapping.getTarget())) {
            XmlAnnotationHelper.applyTargetClass(jaxbBasicMapping.getTarget(), memberDetails, xmlDocumentContext);
        }
        if (StringHelper.isNotEmpty(jaxbBasicMapping.getJdbcType())) {
            XmlAnnotationHelper.applyJdbcTypeDescriptor(jaxbBasicMapping.getJdbcType(), memberDetails, xmlDocumentContext);
        } else if (jaxbBasicMapping.getJdbcTypeCode() != null) {
            XmlAnnotationHelper.applyJdbcTypeCode(jaxbBasicMapping.getJdbcTypeCode(), memberDetails, xmlDocumentContext);
        } else if (StringHelper.isNotEmpty(jaxbBasicMapping.getJdbcTypeName())) {
            XmlAnnotationHelper.applyJdbcTypeCode(XmlAnnotationHelper.resolveJdbcTypeName(jaxbBasicMapping.getJdbcTypeName()), memberDetails, xmlDocumentContext);
        }
    }

    private static int resolveJdbcTypeName(String name) {
        try {
            Field matchingField = SqlTypes.class.getDeclaredField(name);
            return matchingField.getInt(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ModelsException("Could not resolve <jdbc-type-name>" + name + "</jdbc-type-name>", (Throwable)e);
        }
    }

    public static void applyJavaTypeDescriptor(String descriptorClassName, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage typeAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.JAVA_TYPE, xmlDocumentContext.getModelBuildingContext());
        ClassDetails descriptorClass = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(descriptorClassName);
        typeAnn.setAttributeValue("value", (Object)descriptorClass);
    }

    private static void applyJdbcTypeDescriptor(String descriptorClassName, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        ClassDetails descriptorClassDetails = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(descriptorClassName);
        MutableAnnotationUsage jdbcTypeAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.JDBC_TYPE, xmlDocumentContext.getModelBuildingContext());
        jdbcTypeAnn.setAttributeValue("value", (Object)descriptorClassDetails);
    }

    public static void applyJdbcTypeCode(Integer jdbcTypeCode, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jdbcTypeCode == null) {
            return;
        }
        MutableAnnotationUsage typeCodeAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.JDBC_TYPE_CODE, xmlDocumentContext.getModelBuildingContext());
        typeCodeAnn.setAttributeValue("value", (Object)jdbcTypeCode);
    }

    public static void applyFilters(List<JaxbHbmFilterImpl> filters, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyFilters(filters, target, HibernateAnnotations.FILTER, xmlDocumentContext);
    }

    public static void applyJoinTableFilters(List<JaxbHbmFilterImpl> filters, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyFilters(filters, target, HibernateAnnotations.FILTER_JOIN_TABLE, xmlDocumentContext);
    }

    public static <F extends Annotation> void applyFilters(List<JaxbHbmFilterImpl> filters, MutableAnnotationTarget target, AnnotationDescriptor<F> filterAnnotationDescriptor, XmlDocumentContext xmlDocumentContext) {
        assert (filterAnnotationDescriptor.getRepeatableContainer() != null);
        if (filters.isEmpty()) {
            return;
        }
        MutableAnnotationUsage containerUsage = target.replaceAnnotationUsage(filterAnnotationDescriptor, filterAnnotationDescriptor.getRepeatableContainer(), xmlDocumentContext.getModelBuildingContext());
        ArrayList filterUsages = CollectionHelper.arrayList(filters.size());
        containerUsage.setAttributeValue("value", filterUsages);
        filters.forEach(jaxbFilter -> {
            MutableAnnotationUsage filterUsage = filterAnnotationDescriptor.createUsage(xmlDocumentContext.getModelBuildingContext());
            filterUsages.add(filterUsage);
            filterUsage.setAttributeValue("name", (Object)jaxbFilter.getName());
            XmlProcessingHelper.applyAttributeIfSpecified("condition", jaxbFilter.getCondition(), filterUsage);
            XmlProcessingHelper.applyAttributeIfSpecified("deduceAliasInjectionPoints", jaxbFilter.isAutoAliasInjection(), filterUsage);
            List<JaxbHbmFilterImpl.JaxbAliasesImpl> aliases = jaxbFilter.getAliases();
            if (!CollectionHelper.isEmpty(aliases)) {
                filterUsage.setAttributeValue("aliases", XmlAnnotationHelper.getSqlFragmentAliases(aliases, target, xmlDocumentContext));
            }
        });
    }

    private static List<AnnotationUsage<SqlFragmentAlias>> getSqlFragmentAliases(List<JaxbHbmFilterImpl.JaxbAliasesImpl> aliases, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        ArrayList<AnnotationUsage<SqlFragmentAlias>> sqlFragmentAliases = new ArrayList<AnnotationUsage<SqlFragmentAlias>>(aliases.size());
        for (JaxbHbmFilterImpl.JaxbAliasesImpl alias : aliases) {
            MutableAnnotationUsage aliasAnn = HibernateAnnotations.SQL_FRAGMENT_ALIAS.createUsage(xmlDocumentContext.getModelBuildingContext());
            aliasAnn.setAttributeValue("alias", (Object)alias.getAlias());
            XmlProcessingHelper.applyAttributeIfSpecified("table", alias.getTable(), aliasAnn);
            if (StringHelper.isNotEmpty(alias.getEntity())) {
                aliasAnn.setAttributeValue("entity", (Object)xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(alias.getEntity()));
            }
            sqlFragmentAliases.add((AnnotationUsage<SqlFragmentAlias>)aliasAnn);
        }
        return sqlFragmentAliases;
    }

    public static void applySqlRestriction(String sqlRestriction, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applySqlRestriction(sqlRestriction, target, HibernateAnnotations.SQL_RESTRICTION, xmlDocumentContext);
    }

    public static void applySqlJoinTableRestriction(String sqlJoinTableRestriction, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applySqlRestriction(sqlJoinTableRestriction, target, HibernateAnnotations.SQL_RESTRICTION_JOIN_TABLE, xmlDocumentContext);
    }

    private static <A extends Annotation> void applySqlRestriction(String sqlRestriction, MutableAnnotationTarget target, AnnotationDescriptor<A> annotationDescriptor, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(sqlRestriction)) {
            MutableAnnotationUsage restrictionUsage = target.applyAnnotationUsage(annotationDescriptor, xmlDocumentContext.getModelBuildingContext());
            restrictionUsage.setAttributeValue("value", (Object)sqlRestriction);
        }
    }

    public static <A extends Annotation> void applyCustomSql(JaxbCustomSqlImpl jaxbCustomSql, MutableAnnotationTarget target, AnnotationDescriptor<A> annotationDescriptor, XmlDocumentContext xmlDocumentContext) {
        if (jaxbCustomSql == null) {
            return;
        }
        MutableAnnotationUsage annotationUsage = target.applyAnnotationUsage(annotationDescriptor, xmlDocumentContext.getModelBuildingContext());
        annotationUsage.setAttributeValue("sql", (Object)jaxbCustomSql.getValue());
        annotationUsage.setAttributeValue("callable", (Object)jaxbCustomSql.isCallable());
        XmlProcessingHelper.applyAttributeIfSpecified("table", jaxbCustomSql.getTable(), annotationUsage);
        if (jaxbCustomSql.getResultCheck() != null) {
            annotationUsage.setAttributeValue("check", (Object)XmlAnnotationHelper.getResultCheckStyle(jaxbCustomSql.getResultCheck()));
        }
    }

    private static ResultCheckStyle getResultCheckStyle(ExecuteUpdateResultCheckStyle style) {
        switch (style) {
            case NONE: {
                return ResultCheckStyle.NONE;
            }
            case COUNT: {
                return ResultCheckStyle.COUNT;
            }
            case PARAM: {
                return ResultCheckStyle.PARAM;
            }
        }
        return null;
    }

    static void applyIdClass(JaxbIdClassImpl jaxbIdClass, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbIdClass == null) {
            return;
        }
        MutableAnnotationUsage idClassAnn = target.applyAnnotationUsage(JpaAnnotations.ID_CLASS, xmlDocumentContext.getModelBuildingContext());
        ClassDetails idClassImpl = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(jaxbIdClass.getClazz());
        idClassAnn.setAttributeValue("value", (Object)idClassImpl);
    }

    public static void applyLifecycleCallbacks(JaxbEntityOrMappedSuperclass jaxbClass, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        SourceModelBuildingContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        if (jaxbClass.getExcludeDefaultListeners() != null) {
            classDetails.applyAnnotationUsage(JpaAnnotations.EXCLUDE_DEFAULT_LISTENERS, modelBuildingContext);
        }
        if (jaxbClass.getExcludeSuperclassListeners() != null) {
            classDetails.applyAnnotationUsage(JpaAnnotations.EXCLUDE_SUPERCLASS_LISTENERS, modelBuildingContext);
        }
        XmlAnnotationHelper.applyLifecycleCallbacks(jaxbClass, JpaEventListenerStyle.CALLBACK, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyEntityListeners(jaxbClass.getEntityListenerContainer(), classDetails, xmlDocumentContext);
    }

    public static void applyEntityListeners(JaxbEntityListenerContainerImpl entityListenerContainer, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (entityListenerContainer == null || entityListenerContainer.getEntityListeners().isEmpty()) {
            return;
        }
        MutableAnnotationUsage listenersUsage = classDetails.replaceAnnotationUsage(JpaAnnotations.ENTITY_LISTENERS, xmlDocumentContext.getModelBuildingContext());
        ArrayList values = CollectionHelper.arrayList(entityListenerContainer.getEntityListeners().size());
        listenersUsage.setAttributeValue("value", values);
        entityListenerContainer.getEntityListeners().forEach(jaxbEntityListener -> {
            MutableClassDetails entityListenerClass = xmlDocumentContext.resolveJavaType(jaxbEntityListener.getClazz());
            XmlAnnotationHelper.applyLifecycleCallbacks(jaxbEntityListener, JpaEventListenerStyle.LISTENER, entityListenerClass, xmlDocumentContext);
            values.add(entityListenerClass);
        });
    }

    static void applyLifecycleCallbacks(JaxbLifecycleCallbackContainer lifecycleCallbackContainer, JpaEventListenerStyle callbackType, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPrePersist(), callbackType, JpaAnnotations.PRE_PERSIST, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPostPersist(), callbackType, JpaAnnotations.POST_PERSIST, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPreRemove(), callbackType, JpaAnnotations.PRE_REMOVE, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPostRemove(), callbackType, JpaAnnotations.POST_REMOVE, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPreUpdate(), callbackType, JpaAnnotations.PRE_UPDATE, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPostUpdate(), callbackType, JpaAnnotations.POST_UPDATE, classDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLifecycleCallback(lifecycleCallbackContainer.getPostLoad(), callbackType, JpaAnnotations.POST_LOAD, classDetails, xmlDocumentContext);
    }

    private static <A extends Annotation> void applyLifecycleCallback(JaxbLifecycleCallback lifecycleCallback, JpaEventListenerStyle callbackType, AnnotationDescriptor<A> annotationDescriptor, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (lifecycleCallback != null) {
            MutableMemberDetails methodDetails = XmlAnnotationHelper.getCallbackMethodDetails(lifecycleCallback.getMethodName(), callbackType, (ClassDetails)classDetails);
            if (methodDetails == null) {
                throw new AnnotationException(String.format("Lifecycle callback method not found - %s (%s)", lifecycleCallback.getMethodName(), classDetails.getName()));
            }
            methodDetails.applyAnnotationUsage(annotationDescriptor, xmlDocumentContext.getModelBuildingContext());
        }
    }

    private static MutableMemberDetails getCallbackMethodDetails(String name, JpaEventListenerStyle callbackType, ClassDetails classDetails) {
        for (MethodDetails method : classDetails.getMethods()) {
            if (!method.getName().equals(name) || !JpaEventListener.matchesSignature(callbackType, method)) continue;
            return (MutableMemberDetails)method;
        }
        return null;
    }

    static void applyRowId(String rowId, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (rowId == null) {
            return;
        }
        MutableAnnotationUsage rowIdAnn = target.applyAnnotationUsage(HibernateAnnotations.ROW_ID, xmlDocumentContext.getModelBuildingContext());
        XmlProcessingHelper.applyAttributeIfSpecified("value", rowId, rowIdAnn);
    }

    private static String prefixIfNotAlready(String value, String prefix) {
        String previous;
        if (StringHelper.isNotEmpty(prefix) && !(previous = StringHelper.unqualify(value)).equalsIgnoreCase(prefix)) {
            return StringHelper.qualify(prefix, value);
        }
        return value;
    }

    static void applyDiscriminatorValue(String discriminatorValue, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isEmpty(discriminatorValue)) {
            return;
        }
        MutableAnnotationUsage valueAnn = target.applyAnnotationUsage(JpaAnnotations.DISCRIMINATOR_VALUE, xmlDocumentContext.getModelBuildingContext());
        valueAnn.setAttributeValue("value", (Object)discriminatorValue);
    }

    static void applyDiscriminatorColumn(JaxbDiscriminatorColumnImpl jaxbDiscriminatorColumn, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbDiscriminatorColumn == null) {
            return;
        }
        MutableAnnotationUsage discriminatorColumnAnn = target.applyAnnotationUsage(JpaAnnotations.DISCRIMINATOR_COLUMN, xmlDocumentContext.getModelBuildingContext());
        AnnotationUsageHelper.applyStringAttributeIfSpecified("name", jaxbDiscriminatorColumn.getName(), discriminatorColumnAnn);
        AnnotationUsageHelper.applyAttributeIfSpecified("discriminatorType", jaxbDiscriminatorColumn.getDiscriminatorType(), discriminatorColumnAnn);
        XmlAnnotationHelper.applyOr(jaxbDiscriminatorColumn, JaxbDiscriminatorColumnImpl::getColumnDefinition, "columnDefinition", discriminatorColumnAnn, JpaAnnotations.DISCRIMINATOR_COLUMN);
        XmlAnnotationHelper.applyOr(jaxbDiscriminatorColumn, JaxbDiscriminatorColumnImpl::getOptions, "options", discriminatorColumnAnn, JpaAnnotations.DISCRIMINATOR_COLUMN);
        XmlAnnotationHelper.applyOr(jaxbDiscriminatorColumn, JaxbDiscriminatorColumnImpl::getLength, "length", discriminatorColumnAnn, JpaAnnotations.DISCRIMINATOR_COLUMN);
        if (jaxbDiscriminatorColumn.isForceSelection() || jaxbDiscriminatorColumn.isInsertable() == Boolean.FALSE) {
            MutableAnnotationUsage optionsAnn = target.applyAnnotationUsage(HibernateAnnotations.DISCRIMINATOR_OPTIONS, xmlDocumentContext.getModelBuildingContext());
            optionsAnn.setAttributeValue("force", (Object)true);
            AnnotationUsageHelper.applyAttributeIfSpecified("insert", jaxbDiscriminatorColumn.isInsertable(), discriminatorColumnAnn);
        }
    }

    public static void applyDiscriminatorFormula(@Nullable JaxbDiscriminatorFormulaImpl jaxbDiscriminatorFormula, MutableClassDetails target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbDiscriminatorFormula == null) {
            return;
        }
        if (StringHelper.isEmpty(jaxbDiscriminatorFormula.getFragment())) {
            return;
        }
        MutableAnnotationUsage discriminatorFormulaAnn = target.applyAnnotationUsage(HibernateAnnotations.DISCRIMINATOR_FORMULA, xmlDocumentContext.getModelBuildingContext());
        discriminatorFormulaAnn.setAttributeValue("value", (Object)jaxbDiscriminatorFormula.getFragment());
        XmlProcessingHelper.applyAttributeIfSpecified("discriminatorType", jaxbDiscriminatorFormula.getDiscriminatorType(), discriminatorFormulaAnn);
        if (jaxbDiscriminatorFormula.isForceSelection()) {
            MutableAnnotationUsage optionsAnn = target.applyAnnotationUsage(HibernateAnnotations.DISCRIMINATOR_OPTIONS, xmlDocumentContext.getModelBuildingContext());
            optionsAnn.setAttributeValue("force", (Object)true);
        }
    }

    public static String determineTargetName(String explicitName, XmlDocumentContext xmlDocumentContext) {
        String qualifiedName = StringHelper.qualifyConditionallyIfNot(xmlDocumentContext.getXmlDocument().getDefaults().getPackage(), explicitName);
        ClassDetails classDetails = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().resolveClassDetails(qualifiedName);
        if (classDetails != null) {
            return classDetails.getName();
        }
        return explicitName;
    }

    public static <T, N, A extends Annotation> void applyOrSchema(JaxbSchemaAware jaxbNode, MutableAnnotationUsage<A> annotationUsage, AnnotationDescriptor<A> annotationDescriptor, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyOr(jaxbNode, (N table) -> {
            if (StringHelper.isNotEmpty(table.getSchema())) {
                return table.getSchema();
            }
            if (StringHelper.isNotEmpty(XmlAnnotationHelper.defaultSchema(xmlDocumentContext))) {
                return XmlAnnotationHelper.defaultSchema(xmlDocumentContext);
            }
            return null;
        }, "schema", annotationUsage, annotationDescriptor);
    }

    private static String defaultSchema(XmlDocumentContext xmlDocumentContext) {
        return xmlDocumentContext.getXmlDocument().getDefaults().getSchema();
    }

    public static <T, N, A extends Annotation> void applyOrCatalog(JaxbSchemaAware jaxbNode, MutableAnnotationUsage<A> annotationUsage, AnnotationDescriptor<A> annotationDescriptor, XmlDocumentContext xmlDocumentContext) {
        XmlAnnotationHelper.applyOr(jaxbNode, (N table) -> {
            if (StringHelper.isNotEmpty(table.getCatalog())) {
                return table.getCatalog();
            }
            if (StringHelper.isNotEmpty(XmlAnnotationHelper.defaultCatalog(xmlDocumentContext))) {
                return XmlAnnotationHelper.defaultCatalog(xmlDocumentContext);
            }
            return null;
        }, "catalog", annotationUsage, annotationDescriptor);
    }

    private static String defaultCatalog(XmlDocumentContext xmlDocumentContext) {
        return xmlDocumentContext.getXmlDocument().getDefaults().getCatalog();
    }
}

