/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.AccessType;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManagedType;
import org.hibernate.boot.models.MemberResolutionException;
import org.hibernate.boot.models.internal.AnnotationUsageHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class XmlProcessingHelper {
    public static String determineClassName(JaxbEntityMappingsImpl jaxbRoot, JaxbManagedType jaxbManagedType) {
        return StringHelper.qualifyConditionallyIfNot(jaxbRoot.getPackage(), jaxbManagedType.getClazz());
    }

    public static AccessType inverse(AccessType accessType) {
        return accessType == AccessType.FIELD ? AccessType.PROPERTY : AccessType.FIELD;
    }

    public static MutableMemberDetails getAttributeMember(String attributeName, AccessType accessType, MutableClassDetails classDetails) {
        MutableMemberDetails result = XmlProcessingHelper.findAttributeMember(attributeName, accessType, classDetails);
        if (result == null) {
            throw new MemberResolutionException(String.format("Could not locate attribute member - %s (%s)", attributeName, classDetails.getName()));
        }
        return result;
    }

    public static MutableMemberDetails findAttributeMember(String attributeName, AccessType accessType, MutableClassDetails classDetails) {
        block4: {
            block3: {
                if (accessType != AccessType.PROPERTY) break block3;
                for (int i = 0; i < classDetails.getMethods().size(); ++i) {
                    String decapitalizedStemName;
                    String stemName;
                    MethodDetails methodDetails = (MethodDetails)classDetails.getMethods().get(i);
                    if (methodDetails.getMethodKind() != MethodDetails.MethodKind.GETTER) continue;
                    if (methodDetails.getName().startsWith("get")) {
                        stemName = methodDetails.getName().substring(3);
                        decapitalizedStemName = Introspector.decapitalize(stemName);
                        if (!stemName.equals(attributeName) && !decapitalizedStemName.equals(attributeName)) continue;
                        return (MutableMemberDetails)methodDetails;
                    }
                    if (!methodDetails.getName().startsWith("is")) continue;
                    stemName = methodDetails.getName().substring(2);
                    decapitalizedStemName = Introspector.decapitalize(stemName);
                    if (!stemName.equals(attributeName) && !decapitalizedStemName.equals(attributeName)) continue;
                    return (MutableMemberDetails)methodDetails;
                }
                break block4;
            }
            if (accessType != AccessType.FIELD) break block4;
            for (int i = 0; i < classDetails.getFields().size(); ++i) {
                FieldDetails fieldDetails = (FieldDetails)classDetails.getFields().get(i);
                if (!fieldDetails.getName().equals(attributeName)) continue;
                return (MutableMemberDetails)fieldDetails;
            }
        }
        return null;
    }

    public static <A extends Annotation> void applyAttributeIfSpecified(String attributeName, String value, MutableAnnotationUsage<A> annotationUsage) {
        AnnotationUsageHelper.applyStringAttributeIfSpecified(attributeName, value, annotationUsage);
    }

    public static <A extends Annotation> void applyAttributeIfSpecified(String attributeName, Object value, MutableAnnotationUsage<A> annotationUsage) {
        AnnotationUsageHelper.applyAttributeIfSpecified(attributeName, value, annotationUsage);
    }
}

