/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import jakarta.persistence.DiscriminatorType;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.Any;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyDiscriminatorValueMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingDiscriminatorImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingKeyImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.ColumnProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class AnyMappingAttributeProcessing {
    public static MutableMemberDetails processAnyMappingAttribute(JaxbAnyMappingImpl jaxbHbmAnyMapping, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbHbmAnyMapping.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbHbmAnyMapping.getName(), accessType, declarer);
        MutableAnnotationUsage anyAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.ANY, xmlDocumentContext.getModelBuildingContext());
        CommonAttributeProcessing.applyAttributeBasics(jaxbHbmAnyMapping, memberDetails, anyAnn, accessType, xmlDocumentContext);
        AnyMappingAttributeProcessing.applyDiscriminator(memberDetails, jaxbHbmAnyMapping, (MutableAnnotationUsage<Any>)anyAnn, xmlDocumentContext);
        AnyMappingAttributeProcessing.applyKey(memberDetails, jaxbHbmAnyMapping, (MutableAnnotationUsage<Any>)anyAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyCascading(jaxbHbmAnyMapping.getCascade(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }

    private static void applyDiscriminator(MutableMemberDetails memberDetails, JaxbAnyMappingImpl jaxbHbmAnyMapping, MutableAnnotationUsage<Any> anyAnn, XmlDocumentContext xmlDocumentContext) {
        JaxbAnyMappingDiscriminatorImpl jaxbDiscriminator = jaxbHbmAnyMapping.getDiscriminator();
        MutableAnnotationUsage anyDiscriminatorAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.ANY_DISCRIMINATOR, xmlDocumentContext.getModelBuildingContext());
        if (jaxbDiscriminator == null) {
            return;
        }
        DiscriminatorType discriminatorType = jaxbDiscriminator.getType();
        XmlProcessingHelper.applyAttributeIfSpecified("value", discriminatorType, anyDiscriminatorAnn);
        JaxbColumnImpl jaxbColumn = jaxbDiscriminator.getColumn();
        MutableAnnotationUsage columnAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.COLUMN, xmlDocumentContext.getModelBuildingContext());
        if (jaxbColumn != null) {
            ColumnProcessing.applyColumnDetails(jaxbColumn, (AnnotationTarget)memberDetails, columnAnn, xmlDocumentContext);
        }
        ClassDetailsRegistry classDetailsRegistry = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry();
        List<JaxbAnyDiscriminatorValueMappingImpl> valueMappings = jaxbDiscriminator.getValueMappings();
        if (CollectionHelper.isNotEmpty(valueMappings)) {
            MutableAnnotationUsage discriminatorValuesUsage = memberDetails.replaceAnnotationUsage(HibernateAnnotations.ANY_DISCRIMINATOR_VALUE, HibernateAnnotations.ANY_DISCRIMINATOR_VALUES, xmlDocumentContext.getModelBuildingContext());
            ArrayList valueList = CollectionHelper.arrayList(valueMappings.size());
            discriminatorValuesUsage.setAttributeValue("value", valueList);
            valueMappings.forEach(valueMapping -> {
                MutableAnnotationUsage discriminatorValueUsage = HibernateAnnotations.ANY_DISCRIMINATOR_VALUE.createUsage(xmlDocumentContext.getModelBuildingContext());
                valueList.add(discriminatorValueUsage);
                discriminatorValueUsage.setAttributeValue("discriminator", (Object)valueMapping.getDiscriminatorValue());
                String name = StringHelper.qualifyConditionally(xmlDocumentContext.getXmlDocument().getDefaults().getPackage(), valueMapping.getCorrespondingEntityName());
                ClassDetails entityClassDetails = classDetailsRegistry.resolveClassDetails(name);
                discriminatorValueUsage.setAttributeValue("entity", (Object)entityClassDetails);
            });
        }
    }

    private static void applyKey(MutableMemberDetails memberDetails, JaxbAnyMappingImpl jaxbHbmAnyMapping, MutableAnnotationUsage<Any> anyAnn, XmlDocumentContext xmlDocumentContext) {
        JaxbAnyMappingKeyImpl jaxbKey = jaxbHbmAnyMapping.getKey();
        if (StringHelper.isNotEmpty(jaxbKey.getType())) {
            MutableAnnotationUsage keyTypeUsage = memberDetails.applyAnnotationUsage(HibernateAnnotations.ANY_KEY_TYPE, xmlDocumentContext.getModelBuildingContext());
            keyTypeUsage.setAttributeValue("value", (Object)jaxbKey.getType());
        }
        if (jaxbKey.getColumns().isEmpty()) {
            memberDetails.applyAnnotationUsage(JpaAnnotations.JOIN_COLUMN, xmlDocumentContext.getModelBuildingContext());
        } else {
            MutableAnnotationUsage joinColumnsUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.JOIN_COLUMNS, xmlDocumentContext.getModelBuildingContext());
            ArrayList columnAnnList = CollectionHelper.arrayList(jaxbKey.getColumns().size());
            joinColumnsUsage.setAttributeValue("value", columnAnnList);
            jaxbKey.getColumns().forEach(jaxbColumn -> {
                MutableAnnotationUsage joinColumnUsage = JpaAnnotations.JOIN_COLUMN.createUsage(xmlDocumentContext.getModelBuildingContext());
                columnAnnList.add(joinColumnUsage);
                ColumnProcessing.applyColumnDetails(jaxbColumn, (AnnotationTarget)memberDetails, joinColumnUsage, xmlDocumentContext);
            });
        }
    }
}

