/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbBasicImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.ColumnProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class BasicAttributeProcessing {
    public static MutableMemberDetails processBasicAttribute(JaxbBasicImpl jaxbBasic, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbBasic.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbBasic.getName(), accessType, declarer);
        MutableAnnotationUsage basicAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.BASIC, xmlDocumentContext.getModelBuildingContext());
        CommonAttributeProcessing.applyAttributeBasics(jaxbBasic, memberDetails, basicAnn, accessType, xmlDocumentContext);
        if (StringHelper.isNotEmpty(jaxbBasic.getFormula())) {
            assert (jaxbBasic.getColumn() == null);
            MutableAnnotationUsage formulaAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.FORMULA, xmlDocumentContext.getModelBuildingContext());
            formulaAnn.setAttributeValue("value", (Object)jaxbBasic.getFormula());
        } else if (jaxbBasic.getColumn() != null) {
            MutableAnnotationUsage columnAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.COLUMN, xmlDocumentContext.getModelBuildingContext());
            ColumnProcessing.applyColumnDetails(jaxbBasic.getColumn(), (AnnotationTarget)memberDetails, columnAnn, xmlDocumentContext);
        }
        XmlAnnotationHelper.applyConvert(jaxbBasic.getConvert(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyBasicTypeComposition(jaxbBasic, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyTemporal(jaxbBasic.getTemporal(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLob(jaxbBasic.getLob(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyEnumerated(jaxbBasic.getEnumerated(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyNationalized(jaxbBasic.getNationalized(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }
}

