/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbIdImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class BasicIdAttributeProcessing {
    public static MutableMemberDetails processBasicIdAttribute(JaxbIdImpl jaxbId, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbId.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbId.getName(), accessType, declarer);
        memberDetails.applyAnnotationUsage(JpaAnnotations.ID, xmlDocumentContext.getModelBuildingContext());
        MutableAnnotationUsage basicAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.BASIC, xmlDocumentContext.getModelBuildingContext());
        CommonAttributeProcessing.applyAttributeBasics(jaxbId, memberDetails, basicAnn, accessType, xmlDocumentContext);
        XmlAnnotationHelper.applyColumn(jaxbId.getColumn(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyBasicTypeComposition(jaxbId, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyTemporal(jaxbId.getTemporal(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyGeneratedValue(jaxbId.getGeneratedValue(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applySequenceGenerator(jaxbId.getSequenceGenerator(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyTableGenerator(jaxbId.getTableGenerator(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyUuidGenerator(jaxbId.getUuidGenerator(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }
}

