/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import jakarta.persistence.FetchType;
import java.lang.annotation.Annotation;
import org.hibernate.annotations.FetchMode;
import org.hibernate.boot.jaxb.mapping.spi.JaxbAnyMappingImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbLockableAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPersistentAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSingularAssociationAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbSingularFetchModeImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbStandardAttribute;
import org.hibernate.boot.jaxb.mapping.spi.JaxbTransientImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class CommonAttributeProcessing {
    public static <A extends Annotation> void applyAttributeBasics(JaxbPersistentAttribute jaxbAttribute, MutableMemberDetails memberDetails, MutableAnnotationUsage<A> attributeAnn, AccessType accessType, XmlDocumentContext xmlDocumentContext) {
        CommonAttributeProcessing.applyAccess(accessType, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeAccessor(jaxbAttribute, memberDetails, xmlDocumentContext);
        if (jaxbAttribute instanceof JaxbStandardAttribute) {
            JaxbStandardAttribute jaxbStandardAttribute = (JaxbStandardAttribute)jaxbAttribute;
            CommonAttributeProcessing.applyFetching(jaxbStandardAttribute, memberDetails, attributeAnn, xmlDocumentContext);
            CommonAttributeProcessing.applyOptionality(jaxbStandardAttribute, memberDetails, attributeAnn, xmlDocumentContext);
        }
        if (jaxbAttribute instanceof JaxbLockableAttribute) {
            JaxbLockableAttribute jaxbLockableAttribute = (JaxbLockableAttribute)jaxbAttribute;
            CommonAttributeProcessing.applyOptimisticLock(jaxbLockableAttribute, memberDetails, xmlDocumentContext);
        }
    }

    public static void applyAccess(AccessType accessType, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage accessAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.ACCESS, xmlDocumentContext.getModelBuildingContext());
        accessAnn.setAttributeValue("value", (Object)accessType);
    }

    public static <A extends Annotation> void applyAttributeAccessor(JaxbPersistentAttribute jaxbAttribute, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        String attributeAccessor = jaxbAttribute.getAttributeAccessor();
        if (attributeAccessor == null) {
            return;
        }
        MutableAnnotationUsage accessorAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.ATTRIBUTE_ACCESSOR, xmlDocumentContext.getModelBuildingContext());
        ClassDetails strategyClassDetails = xmlDocumentContext.getModelBuildingContext().getClassDetailsRegistry().getClassDetails(attributeAccessor);
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)accessorAnn, "strategy", strategyClassDetails);
    }

    public static <A extends Annotation> void applyOptionality(JaxbStandardAttribute jaxbAttribute, MutableMemberDetails memberDetails, MutableAnnotationUsage<A> attributeAnn, XmlDocumentContext xmlDocumentContext) {
        if (jaxbAttribute.isOptional() == null) {
            return;
        }
        attributeAnn.setAttributeValue("optional", (Object)jaxbAttribute.isOptional());
    }

    public static <A extends Annotation> void applyOptimisticLock(JaxbLockableAttribute jaxbAttribute, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        boolean includeInOptimisticLock = jaxbAttribute.isOptimisticLock();
        MutableAnnotationUsage optLockAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.OPTIMISTIC_LOCK, xmlDocumentContext.getModelBuildingContext());
        optLockAnn.setAttributeValue("excluded", (Object)(!includeInOptimisticLock ? 1 : 0));
    }

    public static <A extends Annotation> void applyFetching(JaxbStandardAttribute jaxbAttribute, MutableMemberDetails memberDetails, MutableAnnotationUsage<A> attributeAnn, XmlDocumentContext xmlDocumentContext) {
        FetchType fetchType = jaxbAttribute.getFetch();
        XmlProcessingHelper.applyAttributeIfSpecified("fetch", fetchType, attributeAnn);
        if (jaxbAttribute instanceof JaxbSingularAssociationAttribute) {
            JaxbSingularAssociationAttribute jaxbSingularAttribute = (JaxbSingularAssociationAttribute)jaxbAttribute;
            JaxbSingularFetchModeImpl jaxbFetchMode = jaxbSingularAttribute.getFetchMode();
            CommonAttributeProcessing.applyFetchMode(memberDetails, jaxbFetchMode, xmlDocumentContext);
        } else if (jaxbAttribute instanceof JaxbAnyMappingImpl) {
            JaxbAnyMappingImpl jaxbAnyAttribute = (JaxbAnyMappingImpl)jaxbAttribute;
            JaxbSingularFetchModeImpl jaxbFetchMode = jaxbAnyAttribute.getFetchMode();
            CommonAttributeProcessing.applyFetchMode(memberDetails, jaxbFetchMode, xmlDocumentContext);
        }
    }

    private static void applyFetchMode(MutableMemberDetails memberDetails, JaxbSingularFetchModeImpl jaxbFetchMode, XmlDocumentContext xmlDocumentContext) {
        if (jaxbFetchMode != null) {
            FetchMode fetchMode = FetchMode.valueOf(jaxbFetchMode.value());
            MutableAnnotationUsage fetchAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.FETCH, xmlDocumentContext.getModelBuildingContext());
            fetchAnn.setAttributeValue("value", (Object)fetchMode);
        }
    }

    public static void applyTransient(JaxbTransientImpl jaxbTransient, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbTransient.getName(), classAccessType, declarer);
        memberDetails.applyAnnotationUsage(JpaAnnotations.TRANSIENT, xmlDocumentContext.getModelBuildingContext());
    }
}

