/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import java.lang.annotation.Annotation;
import org.hibernate.boot.internal.LimitedCollectionClassification;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOrderColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbPluralAttribute;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.db.ColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassDetailsRegistry;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class CommonPluralAttributeProcessing {
    public static void applyPluralAttributeStructure(JaxbPluralAttribute jaxbPluralAttribute, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        SourceModelBuildingContext buildingContext = xmlDocumentContext.getModelBuildingContext();
        ClassDetailsRegistry classDetailsRegistry = buildingContext.getClassDetailsRegistry();
        if (jaxbPluralAttribute.getFetchMode() != null) {
            MutableAnnotationUsage fetchAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.FETCH, buildingContext);
            fetchAnn.setAttributeValue("value", (Object)jaxbPluralAttribute.getFetchMode());
        }
        if (jaxbPluralAttribute.getClassification() != null) {
            if (jaxbPluralAttribute.getClassification() == LimitedCollectionClassification.BAG) {
                memberDetails.applyAnnotationUsage(HibernateAnnotations.BAG, buildingContext);
            } else {
                MutableAnnotationUsage collectionClassificationAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.COLLECTION_CLASSIFICATION, buildingContext);
                collectionClassificationAnn.setAttributeValue("value", (Object)jaxbPluralAttribute.getClassification());
            }
        }
        XmlAnnotationHelper.applyCollectionUserType(jaxbPluralAttribute.getCollectionType(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyCollectionId(jaxbPluralAttribute.getCollectionId(), memberDetails, xmlDocumentContext);
        if (StringHelper.isNotEmpty(jaxbPluralAttribute.getOrderBy())) {
            MutableAnnotationUsage orderByAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.ORDER_BY, buildingContext);
            orderByAnn.setAttributeValue("value", (Object)jaxbPluralAttribute.getOrderBy());
        }
        CommonPluralAttributeProcessing.applyOrderColumn(jaxbPluralAttribute, memberDetails, xmlDocumentContext);
        if (StringHelper.isNotEmpty(jaxbPluralAttribute.getSort())) {
            MutableAnnotationUsage sortAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.SORT_COMPARATOR, buildingContext);
            ClassDetails comparatorClassDetails = classDetailsRegistry.resolveClassDetails(jaxbPluralAttribute.getSort());
            sortAnn.setAttributeValue("value", (Object)comparatorClassDetails);
        }
        if (jaxbPluralAttribute.getSortNatural() != null) {
            memberDetails.applyAnnotationUsage(HibernateAnnotations.SORT_NATURAL, buildingContext);
        }
        if (jaxbPluralAttribute.getMapKey() != null) {
            MutableAnnotationUsage mapKeyAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.MAP_KEY, buildingContext);
            if (jaxbPluralAttribute.getMapKey() != null) {
                XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)mapKeyAnn, "name", jaxbPluralAttribute.getMapKey().getName());
            }
        }
        if (jaxbPluralAttribute.getMapKeyClass() != null) {
            String className = xmlDocumentContext.resolveClassName(jaxbPluralAttribute.getMapKeyClass().getClazz());
            ClassDetails mapKeyClass = classDetailsRegistry.resolveClassDetails(className);
            MutableAnnotationUsage mapKeyClassAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.MAP_KEY_CLASS, buildingContext);
            mapKeyClassAnn.setAttributeValue("value", (Object)mapKeyClass);
        }
        if (jaxbPluralAttribute.getMapKeyTemporal() != null) {
            MutableAnnotationUsage mapKeyTemporalAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.MAP_KEY_TEMPORAL, buildingContext);
            mapKeyTemporalAnn.setAttributeValue("value", (Object)jaxbPluralAttribute.getMapKeyTemporal());
        }
        if (jaxbPluralAttribute.getMapKeyEnumerated() != null) {
            MutableAnnotationUsage mapKeyEnumeratedAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.MAP_KEY_ENUMERATED, buildingContext);
            mapKeyEnumeratedAnn.setAttributeValue("value", (Object)jaxbPluralAttribute.getMapKeyEnumerated());
        }
        jaxbPluralAttribute.getMapKeyConverts().forEach(jaxbConvert -> XmlAnnotationHelper.applyConvert(jaxbConvert, memberDetails, "key", xmlDocumentContext));
        ColumnProcessing.applyMapKeyColumn(jaxbPluralAttribute.getMapKeyColumn(), memberDetails, xmlDocumentContext);
        JoinColumnProcessing.applyMapKeyJoinColumns(jaxbPluralAttribute.getMapKeyJoinColumns(), memberDetails, xmlDocumentContext);
        ForeignKeyProcessing.applyForeignKey(jaxbPluralAttribute.getMapKeyForeignKey(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyFilters(jaxbPluralAttribute.getFilters(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applySqlRestriction(jaxbPluralAttribute.getSqlRestriction(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbPluralAttribute.getSqlInsert(), (MutableAnnotationTarget)memberDetails, HibernateAnnotations.SQL_INSERT, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbPluralAttribute.getSqlUpdate(), (MutableAnnotationTarget)memberDetails, HibernateAnnotations.SQL_UPDATE, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbPluralAttribute.getSqlDelete(), (MutableAnnotationTarget)memberDetails, HibernateAnnotations.SQL_DELETE, xmlDocumentContext);
        XmlAnnotationHelper.applyCustomSql(jaxbPluralAttribute.getSqlDeleteAll(), (MutableAnnotationTarget)memberDetails, HibernateAnnotations.SQL_DELETE_ALL, xmlDocumentContext);
    }

    private static void applyOrderColumn(JaxbPluralAttribute jaxbPluralAttribute, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        JaxbOrderColumnImpl jaxbOrderColumn = jaxbPluralAttribute.getOrderColumn();
        if (jaxbOrderColumn == null) {
            return;
        }
        MutableAnnotationUsage orderColumnAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.ORDER_COLUMN, xmlDocumentContext.getModelBuildingContext());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)orderColumnAnn, "name", jaxbOrderColumn.getName());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)orderColumnAnn, "nullable", jaxbOrderColumn.isNullable());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)orderColumnAnn, "insertable", jaxbOrderColumn.isInsertable());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)orderColumnAnn, "updatable", jaxbOrderColumn.isUpdatable());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)orderColumnAnn, "columnDefinition", jaxbOrderColumn.getColumnDefinition());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)orderColumnAnn, "options", jaxbOrderColumn.getOptions());
    }
}

