/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import jakarta.persistence.CollectionTable;
import org.hibernate.boot.jaxb.mapping.spi.JaxbCollectionTableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbElementCollectionImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.CommonPluralAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class ElementCollectionAttributeProcessing {
    public static MutableMemberDetails processElementCollectionAttribute(JaxbElementCollectionImpl jaxbElementCollection, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbElementCollection.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbElementCollection.getName(), accessType, declarer);
        MutableAnnotationUsage elementCollectionUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.ELEMENT_COLLECTION, xmlDocumentContext.getModelBuildingContext());
        XmlProcessingHelper.applyAttributeIfSpecified("fetch", jaxbElementCollection.getFetch(), elementCollectionUsage);
        String targetClass = jaxbElementCollection.getTargetClass();
        if (targetClass != null) {
            MutableAnnotationUsage targetUsage = memberDetails.applyAnnotationUsage(HibernateAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
            targetUsage.setAttributeValue("value", (Object)xmlDocumentContext.resolveClassName(targetClass));
        }
        XmlAnnotationHelper.applyConverts(jaxbElementCollection.getConverts(), null, memberDetails, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeBasics(jaxbElementCollection, memberDetails, elementCollectionUsage, accessType, xmlDocumentContext);
        CommonPluralAttributeProcessing.applyPluralAttributeStructure(jaxbElementCollection, memberDetails, xmlDocumentContext);
        ElementCollectionAttributeProcessing.applyCollectionTable(jaxbElementCollection.getCollectionTable(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyColumn(jaxbElementCollection.getColumn(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyEnumerated(jaxbElementCollection.getEnumerated(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyLob(jaxbElementCollection.getLob(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyNationalized(jaxbElementCollection.getNationalized(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyTemporal(jaxbElementCollection.getTemporal(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyBasicTypeComposition(jaxbElementCollection, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyAttributeOverrides(jaxbElementCollection, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyAssociationOverrides(jaxbElementCollection.getAssociationOverrides(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        return memberDetails;
    }

    public static void applyCollectionTable(JaxbCollectionTableImpl jaxbCollectionTable, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbCollectionTable == null) {
            return;
        }
        MutableAnnotationUsage collectionTableAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.COLLECTION_TABLE, xmlDocumentContext.getModelBuildingContext());
        AnnotationDescriptor collectionTableDescriptor = xmlDocumentContext.getModelBuildingContext().getAnnotationDescriptorRegistry().getDescriptor(CollectionTable.class);
        XmlAnnotationHelper.applyOr(jaxbCollectionTable, JaxbCollectionTableImpl::getName, "name", collectionTableAnn, collectionTableDescriptor);
        XmlAnnotationHelper.applyOrSchema(jaxbCollectionTable, collectionTableAnn, collectionTableDescriptor, xmlDocumentContext);
        XmlAnnotationHelper.applyOrCatalog(jaxbCollectionTable, collectionTableAnn, collectionTableDescriptor, xmlDocumentContext);
        XmlAnnotationHelper.applyOr(jaxbCollectionTable, JaxbCollectionTableImpl::getOptions, "options", collectionTableAnn, collectionTableDescriptor);
        collectionTableAnn.setAttributeValue("joinColumns", JoinColumnProcessing.transformJoinColumnList(jaxbCollectionTable.getJoinColumns(), (AnnotationTarget)memberDetails, xmlDocumentContext));
        if (jaxbCollectionTable.getForeignKeys() != null) {
            collectionTableAnn.setAttributeValue("foreignKey", ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbCollectionTable.getForeignKeys(), (AnnotationTarget)memberDetails, xmlDocumentContext));
        }
        XmlAnnotationHelper.applyUniqueConstraints(jaxbCollectionTable.getUniqueConstraints(), (AnnotationTarget)memberDetails, collectionTableAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyIndexes(jaxbCollectionTable.getIndexes(), (AnnotationTarget)memberDetails, collectionTableAnn, xmlDocumentContext);
    }
}

