/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class EmbeddedAttributeProcessing {
    public static MutableMemberDetails processEmbeddedAttribute(JaxbEmbeddedImpl jaxbEmbedded, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbEmbedded.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbEmbedded.getName(), accessType, declarer);
        MutableAnnotationUsage embeddedAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.EMBEDDED, xmlDocumentContext.getModelBuildingContext());
        if (StringHelper.isNotEmpty(jaxbEmbedded.getTarget())) {
            MutableAnnotationUsage targetAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
            targetAnn.setAttributeValue("value", (Object)XmlAnnotationHelper.determineTargetName(jaxbEmbedded.getTarget(), xmlDocumentContext));
        }
        CommonAttributeProcessing.applyAttributeBasics(jaxbEmbedded, memberDetails, embeddedAnn, accessType, xmlDocumentContext);
        XmlAnnotationHelper.applyAttributeOverrides(jaxbEmbedded.getAttributeOverrides(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyAssociationOverrides(jaxbEmbedded.getAssociationOverrides(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        return memberDetails;
    }
}

