/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddedIdImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class EmbeddedIdAttributeProcessing {
    public static MutableMemberDetails processEmbeddedIdAttribute(JaxbEmbeddedIdImpl jaxbEmbeddedId, MutableClassDetails classDetails, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbEmbeddedId.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.findAttributeMember(jaxbEmbeddedId.getName(), accessType, classDetails);
        MutableAnnotationUsage idAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.EMBEDDED_ID, xmlDocumentContext.getModelBuildingContext());
        CommonAttributeProcessing.applyAttributeBasics(jaxbEmbeddedId, memberDetails, idAnn, accessType, xmlDocumentContext);
        if (StringHelper.isNotEmpty(jaxbEmbeddedId.getTarget())) {
            MutableAnnotationUsage targetAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
            targetAnn.setAttributeValue("value", (Object)XmlAnnotationHelper.determineTargetName(jaxbEmbeddedId.getTarget(), xmlDocumentContext));
        }
        XmlAnnotationHelper.applyAttributeOverrides(jaxbEmbeddedId.getAttributeOverrides(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }
}

