/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import jakarta.persistence.ManyToOne;
import java.lang.annotation.Annotation;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.boot.jaxb.mapping.spi.JaxbManyToOneImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.TableProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class ManyToOneAttributeProcessing {
    public static MutableMemberDetails processManyToOneAttribute(JaxbManyToOneImpl jaxbManyToOne, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbManyToOne.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbManyToOne.getName(), accessType, declarer);
        MutableAnnotationUsage<ManyToOne> manyToOneAnn = ManyToOneAttributeProcessing.applyManyToOne(memberDetails, jaxbManyToOne, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeBasics(jaxbManyToOne, memberDetails, manyToOneAnn, accessType, xmlDocumentContext);
        TableProcessing.transformJoinTable(jaxbManyToOne.getJoinTable(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        JoinColumnProcessing.applyJoinColumns(jaxbManyToOne.getJoinColumns(), memberDetails, xmlDocumentContext);
        ManyToOneAttributeProcessing.applyNotFound(memberDetails, jaxbManyToOne, manyToOneAnn, xmlDocumentContext);
        ManyToOneAttributeProcessing.applyOnDelete(memberDetails, jaxbManyToOne, manyToOneAnn, xmlDocumentContext);
        ManyToOneAttributeProcessing.applyTarget(memberDetails, jaxbManyToOne, manyToOneAnn, xmlDocumentContext);
        XmlAnnotationHelper.applyCascading(jaxbManyToOne.getCascade(), memberDetails, xmlDocumentContext);
        return memberDetails;
    }

    private static MutableAnnotationUsage<ManyToOne> applyManyToOne(MutableMemberDetails memberDetails, JaxbManyToOneImpl jaxbManyToOne, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage manyToOneUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.MANY_TO_ONE, xmlDocumentContext.getModelBuildingContext());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)manyToOneUsage, "fetch", jaxbManyToOne.getFetch());
        if (jaxbManyToOne.isId() == Boolean.TRUE) {
            memberDetails.applyAnnotationUsage(JpaAnnotations.ID, xmlDocumentContext.getModelBuildingContext());
        }
        if (StringHelper.isNotEmpty(jaxbManyToOne.getMapsId())) {
            MutableAnnotationUsage mapsIdUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.MAPS_ID, xmlDocumentContext.getModelBuildingContext());
            mapsIdUsage.setAttributeValue("value", (Object)jaxbManyToOne.getMapsId());
        }
        return manyToOneUsage;
    }

    private static void applyNotFound(MutableMemberDetails memberDetails, JaxbManyToOneImpl jaxbManyToOne, MutableAnnotationUsage<ManyToOne> manyToOneAnn, XmlDocumentContext xmlDocumentContext) {
        NotFoundAction notFoundAction = jaxbManyToOne.getNotFound();
        if (notFoundAction == null) {
            return;
        }
        MutableAnnotationUsage notFoundAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.NOT_FOUND, xmlDocumentContext.getModelBuildingContext());
        notFoundAnn.setAttributeValue("action", (Object)notFoundAction);
    }

    private static void applyOnDelete(MutableMemberDetails memberDetails, JaxbManyToOneImpl jaxbManyToOne, MutableAnnotationUsage<ManyToOne> manyToOneAnn, XmlDocumentContext xmlDocumentContext) {
        OnDeleteAction action = jaxbManyToOne.getOnDelete();
        if (action == null) {
            return;
        }
        MutableAnnotationUsage notFoundAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.ON_DELETE, xmlDocumentContext.getModelBuildingContext());
        notFoundAnn.setAttributeValue("action", (Object)action);
    }

    private static void applyTarget(MutableMemberDetails memberDetails, JaxbManyToOneImpl jaxbManyToOne, MutableAnnotationUsage<ManyToOne> manyToOneAnn, XmlDocumentContext xmlDocumentContext) {
        String targetEntityName = jaxbManyToOne.getTargetEntity();
        if (StringHelper.isEmpty(targetEntityName)) {
            return;
        }
        MutableAnnotationUsage targetAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.TARGET, xmlDocumentContext.getModelBuildingContext());
        targetAnn.setAttributeValue("value", (Object)XmlAnnotationHelper.determineTargetName(targetEntityName, xmlDocumentContext));
    }
}

