/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.attr;

import jakarta.persistence.AccessType;
import jakarta.persistence.OneToMany;
import java.lang.annotation.Annotation;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.boot.jaxb.mapping.spi.JaxbOneToManyImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.XmlProcessingHelper;
import org.hibernate.boot.models.xml.internal.attr.CommonAttributeProcessing;
import org.hibernate.boot.models.xml.internal.attr.CommonPluralAttributeProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.internal.db.TableProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;

public class OneToManyAttributeProcessing {
    public static MutableMemberDetails processOneToManyAttribute(JaxbOneToManyImpl jaxbOneToMany, MutableClassDetails declarer, AccessType classAccessType, XmlDocumentContext xmlDocumentContext) {
        AccessType accessType = NullnessHelper.coalesce(jaxbOneToMany.getAccess(), classAccessType);
        MutableMemberDetails memberDetails = XmlProcessingHelper.getAttributeMember(jaxbOneToMany.getName(), accessType, declarer);
        MutableAnnotationUsage<OneToMany> oneToManyAnn = OneToManyAttributeProcessing.applyOneToMany(jaxbOneToMany, memberDetails, xmlDocumentContext);
        OneToManyAttributeProcessing.applyTargetEntity(jaxbOneToMany, oneToManyAnn, xmlDocumentContext);
        CommonAttributeProcessing.applyAttributeBasics(jaxbOneToMany, memberDetails, oneToManyAnn, accessType, xmlDocumentContext);
        CommonPluralAttributeProcessing.applyPluralAttributeStructure(jaxbOneToMany, memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyCascading(jaxbOneToMany.getCascade(), memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyAttributeOverrides(jaxbOneToMany.getMapKeyAttributeOverrides(), (MutableAnnotationTarget)memberDetails, "key", xmlDocumentContext);
        TableProcessing.transformJoinTable(jaxbOneToMany.getJoinTable(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applySqlJoinTableRestriction(jaxbOneToMany.getSqlJoinTableRestriction(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        XmlAnnotationHelper.applyJoinTableFilters(jaxbOneToMany.getJoinTableFilters(), (MutableAnnotationTarget)memberDetails, xmlDocumentContext);
        JoinColumnProcessing.applyJoinColumns(jaxbOneToMany.getJoinColumn(), memberDetails, xmlDocumentContext);
        if (jaxbOneToMany.getOnDelete() != null) {
            MutableAnnotationUsage onDeleteAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.ON_DELETE, xmlDocumentContext.getModelBuildingContext());
            onDeleteAnn.setAttributeValue("action", (Object)jaxbOneToMany.getOnDelete());
        }
        if (jaxbOneToMany.getNotFound() != null && jaxbOneToMany.getNotFound() != NotFoundAction.EXCEPTION) {
            MutableAnnotationUsage notFoundAnn = memberDetails.applyAnnotationUsage(HibernateAnnotations.NOT_FOUND, xmlDocumentContext.getModelBuildingContext());
            notFoundAnn.setAttributeValue("action", (Object)jaxbOneToMany.getNotFound());
        }
        return memberDetails;
    }

    private static MutableAnnotationUsage<OneToMany> applyOneToMany(JaxbOneToManyImpl jaxbOneToMany, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        MutableAnnotationUsage oneToManyAnn = memberDetails.applyAnnotationUsage(JpaAnnotations.ONE_TO_MANY, xmlDocumentContext.getModelBuildingContext());
        if (jaxbOneToMany != null) {
            XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)oneToManyAnn, "fetch", jaxbOneToMany.getFetch());
            XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)oneToManyAnn, "mappedBy", jaxbOneToMany.getMappedBy());
            XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)oneToManyAnn, "orphanRemoval", jaxbOneToMany.isOrphanRemoval());
        }
        return oneToManyAnn;
    }

    private static void applyTargetEntity(JaxbOneToManyImpl jaxbOneToMany, MutableAnnotationUsage<OneToMany> oneToManyAnn, XmlDocumentContext xmlDocumentContext) {
        String targetEntity = jaxbOneToMany.getTargetEntity();
        if (StringHelper.isNotEmpty(targetEntity)) {
            oneToManyAnn.setAttributeValue("targetEntity", (Object)xmlDocumentContext.resolveJavaType(targetEntity));
        }
    }
}

