/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.db;

import jakarta.persistence.ForeignKey;
import java.lang.annotation.Annotation;
import org.hibernate.boot.jaxb.mapping.spi.JaxbForeignKeyImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;
import org.hibernate.models.spi.MutableMemberDetails;

public class ForeignKeyProcessing {
    public static void applyForeignKey(JaxbForeignKeyImpl jaxbForeignKey, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbForeignKey == null) {
            return;
        }
        ForeignKeyProcessing.createForeignKeyAnnotation(jaxbForeignKey, memberDetails, xmlDocumentContext);
    }

    public static MutableAnnotationUsage<ForeignKey> createForeignKeyAnnotation(JaxbForeignKeyImpl jaxbForeignKey, MutableMemberDetails memberDetails, XmlDocumentContext xmlDocumentContext) {
        if (jaxbForeignKey == null) {
            return null;
        }
        MutableAnnotationUsage foreignKeyUsage = memberDetails.applyAnnotationUsage(JpaAnnotations.FOREIGN_KEY, xmlDocumentContext.getModelBuildingContext());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)foreignKeyUsage, "name", jaxbForeignKey.getName());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)foreignKeyUsage, "value", jaxbForeignKey.getConstraintMode());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)foreignKeyUsage, "foreignKeyDefinition", jaxbForeignKey.getForeignKeyDefinition());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)foreignKeyUsage, "options", jaxbForeignKey.getOptions());
        return foreignKeyUsage;
    }

    public static MutableAnnotationUsage<ForeignKey> createNestedForeignKeyAnnotation(JaxbForeignKeyImpl jaxbForeignKey, AnnotationTarget annotationTarget, XmlDocumentContext xmlDocumentContext) {
        assert (jaxbForeignKey != null);
        MutableAnnotationUsage foreignKeyUsage = JpaAnnotations.FOREIGN_KEY.createUsage(xmlDocumentContext.getModelBuildingContext());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)foreignKeyUsage, "name", jaxbForeignKey.getName());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)foreignKeyUsage, "value", jaxbForeignKey.getConstraintMode());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)foreignKeyUsage, "foreignKeyDefinition", jaxbForeignKey.getForeignKeyDefinition());
        XmlAnnotationHelper.applyOptionalAttribute((MutableAnnotationUsage<? extends Annotation>)foreignKeyUsage, "options", jaxbForeignKey.getOptions());
        return foreignKeyUsage;
    }
}

