/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal.db;

import jakarta.persistence.JoinTable;
import java.util.List;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinColumnImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbJoinTableImpl;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.xml.internal.XmlAnnotationHelper;
import org.hibernate.boot.models.xml.internal.db.ForeignKeyProcessing;
import org.hibernate.boot.models.xml.internal.db.JoinColumnProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationTarget;
import org.hibernate.models.spi.MutableAnnotationUsage;

public class TableProcessing {
    public static MutableAnnotationUsage<JoinTable> transformJoinTable(JaxbJoinTableImpl jaxbJoinTable, MutableAnnotationTarget target, XmlDocumentContext xmlDocumentContext) {
        if (jaxbJoinTable == null) {
            return null;
        }
        MutableAnnotationUsage joinTableUsage = target.applyAnnotationUsage(JpaAnnotations.JOIN_TABLE, xmlDocumentContext.getModelBuildingContext());
        TableProcessing.applyJoinTable(jaxbJoinTable, (MutableAnnotationUsage<JoinTable>)joinTableUsage, (AnnotationTarget)target, xmlDocumentContext);
        return joinTableUsage;
    }

    private static void applyJoinTable(JaxbJoinTableImpl jaxbJoinTable, MutableAnnotationUsage<JoinTable> joinTableUsage, AnnotationTarget annotationTarget, XmlDocumentContext xmlDocumentContext) {
        List<JaxbJoinColumnImpl> inverseJoinColumns;
        XmlAnnotationHelper.applyOptionalAttribute(joinTableUsage, "name", jaxbJoinTable.getName());
        XmlAnnotationHelper.applyTableAttributes(jaxbJoinTable, annotationTarget, joinTableUsage, JpaAnnotations.JOIN_TABLE, xmlDocumentContext);
        List<JaxbJoinColumnImpl> joinColumns = jaxbJoinTable.getJoinColumn();
        if (CollectionHelper.isNotEmpty(joinColumns)) {
            joinTableUsage.setAttributeValue("joinColumns", JoinColumnProcessing.transformJoinColumnList(joinColumns, annotationTarget, xmlDocumentContext));
        }
        if (CollectionHelper.isNotEmpty(inverseJoinColumns = jaxbJoinTable.getInverseJoinColumn())) {
            joinTableUsage.setAttributeValue("inverseJoinColumns", JoinColumnProcessing.transformJoinColumnList(inverseJoinColumns, annotationTarget, xmlDocumentContext));
        }
        if (jaxbJoinTable.getForeignKey() != null) {
            joinTableUsage.setAttributeValue("foreignKey", ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbJoinTable.getForeignKey(), annotationTarget, xmlDocumentContext));
        }
        if (jaxbJoinTable.getInverseForeignKey() != null) {
            joinTableUsage.setAttributeValue("inverseForeignKey", ForeignKeyProcessing.createNestedForeignKeyAnnotation(jaxbJoinTable.getInverseForeignKey(), annotationTarget, xmlDocumentContext));
        }
    }
}

