/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.spi;

import org.hibernate.boot.internal.RootMappingDefaults;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEmbeddableImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbMappedSuperclassImpl;
import org.hibernate.boot.models.categorize.internal.DomainModelCategorizationCollector;
import org.hibernate.boot.models.xml.internal.ManagedTypeProcessor;
import org.hibernate.boot.models.xml.internal.XmlDocumentContextImpl;
import org.hibernate.boot.models.xml.internal.XmlDocumentImpl;
import org.hibernate.boot.models.xml.internal.XmlProcessingResultImpl;
import org.hibernate.boot.models.xml.spi.XmlPreProcessingResult;
import org.hibernate.boot.models.xml.spi.XmlProcessingResult;
import org.hibernate.boot.spi.BootstrapContext;
import org.hibernate.models.spi.SourceModelBuildingContext;

public class XmlProcessor {
    public static XmlProcessingResult processXml(XmlPreProcessingResult xmlPreProcessingResult, DomainModelCategorizationCollector modelCategorizationCollector, SourceModelBuildingContext sourceModelBuildingContext, BootstrapContext bootstrapContext, RootMappingDefaults mappingDefaults) {
        boolean xmlMappingsGloballyComplete = xmlPreProcessingResult.getPersistenceUnitMetadata().areXmlMappingsComplete();
        XmlProcessingResultImpl xmlOverlay = new XmlProcessingResultImpl();
        xmlPreProcessingResult.getDocuments().forEach(jaxbRoot -> {
            modelCategorizationCollector.apply((JaxbEntityMappingsImpl)jaxbRoot);
            XmlDocumentImpl xmlDocument = XmlDocumentImpl.consume(jaxbRoot, xmlPreProcessingResult.getPersistenceUnitMetadata());
            XmlDocumentContextImpl xmlDocumentContext = new XmlDocumentContextImpl(xmlDocument, mappingDefaults, sourceModelBuildingContext, bootstrapContext);
            jaxbRoot.getEmbeddables().forEach(jaxbEmbeddable -> {
                if (xmlMappingsGloballyComplete || jaxbEmbeddable.isMetadataComplete() == Boolean.TRUE) {
                    ManagedTypeProcessor.processCompleteEmbeddable(jaxbRoot, jaxbEmbeddable, xmlDocumentContext);
                } else {
                    xmlOverlay.addEmbeddableOverride(new XmlProcessingResult.OverrideTuple<JaxbEmbeddableImpl>((JaxbEntityMappingsImpl)jaxbRoot, xmlDocumentContext, (JaxbEmbeddableImpl)jaxbEmbeddable));
                }
            });
            jaxbRoot.getMappedSuperclasses().forEach(jaxbMappedSuperclass -> {
                if (xmlMappingsGloballyComplete || jaxbMappedSuperclass.isMetadataComplete() == Boolean.TRUE) {
                    ManagedTypeProcessor.processCompleteMappedSuperclass(jaxbRoot, jaxbMappedSuperclass, xmlDocumentContext);
                } else {
                    xmlOverlay.addMappedSuperclassesOverride(new XmlProcessingResult.OverrideTuple<JaxbMappedSuperclassImpl>((JaxbEntityMappingsImpl)jaxbRoot, xmlDocumentContext, (JaxbMappedSuperclassImpl)jaxbMappedSuperclass));
                }
            });
            jaxbRoot.getEntities().forEach(jaxbEntity -> {
                if (xmlMappingsGloballyComplete || jaxbEntity.isMetadataComplete() == Boolean.TRUE) {
                    ManagedTypeProcessor.processCompleteEntity(jaxbRoot, jaxbEntity, xmlDocumentContext);
                } else {
                    xmlOverlay.addEntityOverride(new XmlProcessingResult.OverrideTuple<JaxbEntityImpl>((JaxbEntityMappingsImpl)jaxbRoot, xmlDocumentContext, (JaxbEntityImpl)jaxbEntity));
                }
            });
        });
        return xmlOverlay;
    }
}

