/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import org.hibernate.AssertionFailure;
import org.hibernate.annotations.OptimisticLockType;

public enum OptimisticLockStyle {
    NONE,
    VERSION,
    DIRTY,
    ALL;


    public static OptimisticLockStyle fromLockType(OptimisticLockType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case OptimisticLockType.VERSION -> VERSION;
            case OptimisticLockType.NONE -> NONE;
            case OptimisticLockType.DIRTY -> DIRTY;
            case OptimisticLockType.ALL -> ALL;
        };
    }

    public boolean isAllOrDirty() {
        return this.isAll() || this.isDirty();
    }

    public boolean isAll() {
        return this == ALL;
    }

    public boolean isDirty() {
        return this == DIRTY;
    }

    public boolean isVersion() {
        return this == VERSION;
    }

    public boolean isNone() {
        return this == NONE;
    }

    @Deprecated(since="6.2", forRemoval=true)
    public int getOldCode() {
        switch (this) {
            case NONE: {
                return -1;
            }
            case VERSION: {
                return 0;
            }
            case DIRTY: {
                return 1;
            }
            case ALL: {
                return 2;
            }
        }
        throw new AssertionFailure("Unknown OptimisticLockStyle");
    }

    @Deprecated(since="6.2", forRemoval=true)
    public static OptimisticLockStyle interpretOldCode(int oldCode) {
        switch (oldCode) {
            case -1: {
                return NONE;
            }
            case 0: {
                return VERSION;
            }
            case 1: {
                return DIRTY;
            }
            case 2: {
                return ALL;
            }
        }
        throw new IllegalArgumentException("Illegal legacy optimistic lock style code : " + oldCode);
    }
}

